/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rtm.base.ui.rexpr;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.statet.ecommons.emf.core.IContext;
import org.eclipse.statet.ecommons.emf.core.IEMFPropertyContext;
import org.eclipse.statet.ecommons.emf.ui.forms.EFEditor;
import org.eclipse.statet.ecommons.emf.ui.forms.EFPropertySheetPage;
import org.eclipse.statet.ecommons.emf.ui.forms.EFToolkit;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.rtm.base.ui.rexpr.RExprTypeUIAdapter;
import org.eclipse.statet.rtm.base.ui.rexpr.RExprWidget;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;

public class HyperlinkType
extends RExprWidget.TypeDef
implements IHyperlinkListener {
    private Hyperlink link;
    private PropertyTabLink descriptor;

    public HyperlinkType(RExprTypeUIAdapter type) {
        super(type);
    }

    @Override
    public boolean hasDetail() {
        return true;
    }

    @Override
    protected Control createDetailControl(Composite parent) {
        IEMFPropertyContext context = (IEMFPropertyContext)this.getContext();
        IHyperlinkProvider linkProvider = (IHyperlinkProvider)this.getContext().getAdapter(IHyperlinkProvider.class);
        if (context == null || linkProvider == null) {
            return null;
        }
        this.descriptor = linkProvider.get(context.getEClass(), context.getEFeature());
        EFEditor editor = (EFEditor)((Object)context.getAdapter(EFEditor.class));
        EFToolkit toolkit = editor.getToolkit();
        this.link = toolkit.createHyperlink(parent, this.descriptor.label, 0);
        this.link.addHyperlinkListener((IHyperlinkListener)this);
        return this.link;
    }

    public void linkEntered(HyperlinkEvent e) {
    }

    public void linkExited(HyperlinkEvent e) {
    }

    public void linkActivated(HyperlinkEvent e) {
        if (this.descriptor != null) {
            this.descriptor.run(this.getContext());
        }
    }

    public static interface IHyperlinkProvider {
        public PropertyTabLink get(EClass var1, EStructuralFeature var2);
    }

    public static class PropertyTabLink {
        private final String label;
        final String propertyTabId;

        public PropertyTabLink(String label, String propertyTabId) {
            this.label = label;
            this.propertyTabId = propertyTabId;
        }

        protected void run(IContext context) {
            this.showProperties(context);
        }

        protected void showProperties(IContext context) {
            IViewReference viewReference;
            EFEditor editor = (EFEditor)((Object)context.getAdapter(EFEditor.class));
            IWorkbenchPage workbenchPage = UIAccess.getActiveWorkbenchPage((boolean)true);
            IViewReference[] viewReferences = workbenchPage.getViewReferences();
            IViewReference[] rated = new IViewReference[10];
            IViewReference[] iViewReferenceArray = viewReferences;
            int n = viewReferences.length;
            int n2 = 0;
            while (n2 < n) {
                viewReference = iViewReferenceArray[n2];
                int rate = this.ratePropertyView(viewReference, editor);
                if (rate >= 0 && rated[rate] == null) {
                    rated[rate] = viewReference;
                }
                ++n2;
            }
            iViewReferenceArray = rated;
            n = rated.length;
            n2 = 0;
            while (n2 < n) {
                viewReference = iViewReferenceArray[n2];
                if (viewReference != null) {
                    PropertySheet view = (PropertySheet)viewReference.getView(true);
                    workbenchPage.activate((IWorkbenchPart)view);
                    this.showPropertyTab(view);
                    return;
                }
                ++n2;
            }
            try {
                PropertySheet view = (PropertySheet)workbenchPage.showView("org.eclipse.ui.views.PropertySheet");
                if (!view.isPinned()) {
                    this.showPropertyTab(view);
                    return;
                }
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
        }

        private int ratePropertyView(IViewReference viewReference, EFEditor editor) {
            if (viewReference == null || !viewReference.getId().equals("org.eclipse.ui.views.PropertySheet")) {
                return -1;
            }
            PropertySheet view = (PropertySheet)viewReference.getPart(false);
            if (view != null) {
                int rate;
                boolean matches;
                if (!(view.getCurrentPage() instanceof EFPropertySheetPage)) {
                    return -1;
                }
                EFPropertySheetPage page = (EFPropertySheetPage)view.getCurrentPage();
                ITabDescriptor tab = page.getSelectedTab();
                boolean bl = matches = page.getEditor() == editor && tab != null && tab.getId().equals(this.propertyTabId);
                if (view.isPinned()) {
                    if (matches) {
                        return 1;
                    }
                    return -1;
                }
                int n = rate = view.getViewSite().getPage().isPartVisible((IWorkbenchPart)view) ? 2 : 5;
                if (matches) {
                    return rate;
                }
                if (viewReference.getSecondaryId() == null) {
                    return rate + 1;
                }
                return rate + 2;
            }
            if (viewReference.getSecondaryId() == null) {
                return 8;
            }
            return 9;
        }

        private void showPropertyTab(PropertySheet view) {
            EFPropertySheetPage efPage = (EFPropertySheetPage)view.getCurrentPage();
            efPage.setSelectedTab(this.propertyTabId);
        }
    }
}

