/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.emf.ui.forms;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.emf.core.databinding.IEMFEditContext;
import org.eclipse.statet.ecommons.emf.ui.forms.EFEditor;
import org.eclipse.swt.widgets.Control;

public class EFDataBindingSupport
extends DataBindingSupport
implements IEMFEditContext {
    private final EFEditor editor;
    private final IObservableValue<EObject> rootObject;
    private final IAdapterFactory adapterFactory;

    public EFDataBindingSupport(EFEditor editor, IAdapterFactory adapterFactory) {
        super(editor.getAdapter(Control.class));
        this.editor = editor;
        Resource resource = (Resource)this.editor.getEditingDomain().getResourceSet().getResources().get(0);
        this.rootObject = new WritableValue(this.getRealm(), (Object)this.getRootObject(resource), EObject.class);
        resource.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(final Notification notification) {
                if (notification.getFeatureID(Resource.class) == 4 && notification.getNewBooleanValue()) {
                    EFDataBindingSupport.this.getRealm().exec(new Runnable(){

                        @Override
                        public void run() {
                            EObject rootObject = EFDataBindingSupport.this.getRootObject((Resource)notification.getNotifier());
                            (this).EFDataBindingSupport.this.rootObject.setValue((Object)rootObject);
                        }
                    });
                }
            }
        });
        this.adapterFactory = adapterFactory;
    }

    protected DataBindingContext createContext(Realm realm) {
        return new EMFDataBindingContext(realm);
    }

    protected EObject getRootObject(Resource resource) {
        return (EObject)resource.getContents().get(0);
    }

    public EditingDomain getEditingDomain() {
        return this.editor.getEditingDomain();
    }

    public IObservableValue<EObject> getRootObservable() {
        return this.rootObject;
    }

    public DataBindingContext getDataBindingContext() {
        return this.getContext();
    }

    public IObservableValue<EObject> getBaseObservable() {
        return this.getRootObservable();
    }

    public <T> T getAdapter(Class<T> adapterType) {
        if (adapterType.isInstance((Object)this)) {
            return (T)((Object)this);
        }
        if (adapterType.equals(IShellProvider.class)) {
            return (T)this.editor.getSite();
        }
        if (adapterType.equals(EFEditor.class)) {
            return (T)((Object)this.editor);
        }
        if (this.adapterFactory != null) {
            return (T)this.adapterFactory.getAdapter((Object)this, adapterType);
        }
        return null;
    }
}

