/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.compare;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.preferences.ui.SettingsUpdater;
import org.eclipse.statet.ecommons.text.ui.TextViewerJFaceUpdater;
import org.eclipse.statet.ecommons.ui.ISettingsChangedHandler;
import org.eclipse.statet.ltk.ui.compare.CompareUtilities;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.statet.ltk.ui.sourceediting.ViewerSourceEditorAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CompareTextViewer
extends Viewer {
    private final SourceViewer sourceViewer;
    private final SourceEditorViewerConfigurator configurator;
    private Object input;

    public CompareTextViewer(Composite parent, CompareConfiguration compareConfig, SourceEditorViewerConfigurator viewerConfig) {
        this.configurator = viewerConfig;
        this.sourceViewer = new SourceViewer(parent, null, 0x2000B02);
        this.sourceViewer.setEditable(false);
    }

    protected void initSourceViewer() {
        this.configurator.setTarget(new ViewerSourceEditorAdapter(this.sourceViewer, this.configurator){

            @Override
            public boolean isEditable(boolean validate) {
                return CompareTextViewer.this.input instanceof IEditableContent && ((IEditableContent)CompareTextViewer.this.input).isEditable();
            }
        });
        new TextViewerJFaceUpdater((ISourceViewer)this.sourceViewer, this.configurator.getSourceViewerConfiguration().getPreferences());
        new SettingsUpdater((ISettingsChangedHandler)this.configurator, this.sourceViewer.getControl());
        this.sourceViewer.activatePlugins();
    }

    public Control getControl() {
        return this.sourceViewer.getControl();
    }

    public void setInput(Object input) {
        this.input = input;
        if (input instanceof IStreamContentAccessor) {
            Document document = new Document(CompareUtilities.readString((IStreamContentAccessor)input));
            this.configurator.getDocumentSetupParticipant().setup((IDocument)document);
            this.sourceViewer.setDocument((IDocument)document);
        }
    }

    public Object getInput() {
        return this.input;
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.sourceViewer.setSelection(selection, reveal);
    }

    public ISelection getSelection() {
        return this.sourceViewer.getSelection();
    }

    public void refresh() {
    }
}

