/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rhelp.core.http;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.statet.internal.rhelp.core.RHelpWebapp;
import org.eclipse.statet.internal.rhelp.core.server.ServerClientSupport;
import org.eclipse.statet.jcommons.io.UriUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.rhelp.core.REnvHelp;
import org.eclipse.statet.rhelp.core.REnvHelpConfiguration;
import org.eclipse.statet.rhelp.core.RHelpManager;
import org.eclipse.statet.rhelp.core.RHelpPage;
import org.eclipse.statet.rhelp.core.RHelpTopicLookup;
import org.eclipse.statet.rhelp.core.RPkgHelp;
import org.eclipse.statet.rj.renv.core.REnv;

@NonNullByDefault
public abstract class RHelpHttpService {
    public static final String HTTP_SCHEME = "http";
    public static final String PORTABLE_URI_SCHEME = "erhelp";
    private static final String RHELP_TOPIC_PATH = "/topic";
    private static final String RHELP_PAGE_PATH = "/page";
    private static final String ABOUT_BLANK_URI_STRING = "about:blank";
    private static final URI ABOUT_BLANK_URI = URI.create("about:blank");
    private final String contextPath = "/rhelp";
    private final RHelpManager rHelpManager;
    public static final String BROWSE_TARGET = "browse";

    public RHelpHttpService(RHelpManager rHelpManager) {
        this.rHelpManager = rHelpManager;
    }

    public abstract boolean ensureIsRunning();

    protected abstract String getHost();

    protected abstract int getPort();

    protected void checkRunning() {
        if (!this.ensureIsRunning()) {
            throw new UnsupportedOperationException("Help is not available.");
        }
    }

    public boolean isDynamicUrl(URI url) {
        String path;
        this.checkRunning();
        return HTTP_SCHEME.equals(url.getScheme()) && this.getHost().equals(url.getHost()) && this.getPort() == url.getPort() && (path = url.getPath()) != null && path.startsWith("/rhelp");
    }

    private String getDynamicPath(URI url) {
        return url.getPath().substring("/rhelp".length());
    }

    protected URI createHttpUrl(StringBuilder encPath, @Nullable String encQuery, @Nullable String encFragment) throws URISyntaxException {
        String host = this.getHost();
        StringBuilder sb = new StringBuilder(host.length() + encPath.length() + 16);
        sb.append(HTTP_SCHEME);
        sb.append("://");
        sb.append(this.getHost());
        if (this.getPort() != -1) {
            sb.append(':');
            sb.append(this.getPort());
        }
        sb.append((CharSequence)encPath);
        if (encQuery != null) {
            sb.append('?');
            sb.append(encQuery);
        }
        if (encFragment != null) {
            sb.append('#');
            sb.append(encFragment);
        }
        return new URI(sb.toString());
    }

    protected URI createHttpUrl(StringBuilder encPath) {
        try {
            return this.createHttpUrl(encPath, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public URI getPageHttpUrl(RHelpPage page, String target) {
        RPkgHelp pkgHelp = page.getPackage();
        return this.getPageHttpUrl(pkgHelp.getName(), page.getName(), pkgHelp.getREnv(), target);
    }

    public URI getPageHttpUrl(String pkgName, @Nullable String pageName, REnv rEnv, String target) {
        this.checkRunning();
        StringBuilder p = new StringBuilder(64);
        p.append("/rhelp");
        p.append('/');
        p.append(target);
        p.append('/');
        p.append(rEnv.getId());
        p.append('/');
        p.append("library");
        p.append('/');
        p.append(pkgName);
        p.append('/');
        if (pageName != null) {
            p.append("html");
            p.append('/');
            p.append(pageName);
            p.append(".html");
        }
        return this.createHttpUrl(p);
    }

    public URI getTopicHttpUrl(String topic, @Nullable String pkgName, REnv rEnv, String target) {
        this.checkRunning();
        StringBuilder p = new StringBuilder(64);
        p.append("/rhelp");
        p.append('/');
        p.append(target);
        p.append('/');
        p.append(rEnv.getId());
        p.append('/');
        p.append("library");
        p.append('/');
        p.append(pkgName != null ? pkgName : "-");
        p.append('/');
        p.append("help");
        p.append('/');
        p.append(UriUtils.encodePathSegment((String)topic));
        return this.createHttpUrl(p);
    }

    public URI getREnvHttpUrl(REnv rEnv, String target) {
        this.checkRunning();
        StringBuilder p = new StringBuilder(64);
        p.append("/rhelp");
        p.append('/');
        p.append(target);
        p.append('/');
        p.append(rEnv.getId());
        p.append('/');
        return this.createHttpUrl(p);
    }

    public URI getPackageHttpUrl(RPkgHelp pkgHelp, String target) {
        return this.getPageHttpUrl(pkgHelp.getName(), null, pkgHelp.getREnv(), target);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public @Nullable URI toHttpUrl(String url, @Nullable REnv rEnv, @Nullable String target) {
        this.checkRunning();
        if (url.startsWith("rhelp:///")) {
            int n;
            int idx1;
            if (rEnv == null) return null;
            if (target == null) {
                return null;
            }
            String path = url.substring(8);
            int n2 = idx1 = path.length() > 0 ? path.indexOf(47, 1) : -1;
            if (idx1 <= 0) {
                if (path.length() != 1) return null;
                return this.getREnvHttpUrl(rEnv, target);
            }
            String command = path.substring(0, idx1);
            if (!command.equals(RHELP_PAGE_PATH)) {
                if (!command.equals(RHELP_TOPIC_PATH)) return null;
                return this.getTopicHttpUrl(path.substring(idx1 + 1), null, rEnv, target);
            }
            int idx2 = path.indexOf(47, idx1 + 1);
            if (idx2 > idx1 + 1 && idx2 < path.length() - 1) {
                return this.getPageHttpUrl(path.substring(idx1 + 1, idx2), path.substring(idx2 + 1), rEnv, target);
            }
            if (idx2 > 0) {
                n = idx2;
                return this.getPageHttpUrl(path.substring(idx1 + 1, n), null, rEnv, target);
            }
            n = path.length();
            return this.getPageHttpUrl(path.substring(idx1 + 1, n), null, rEnv, target);
        }
        if (!url.startsWith("http://")) return null;
        try {
            URI uri = new URI(url);
            if (!this.isDynamicUrl(uri)) return uri;
            if (rEnv == null && target == null) {
                return null;
            }
            String path = this.getDynamicPath(uri);
            int targetEnd = path.indexOf(47, 1);
            if (targetEnd <= 1) return null;
            StringBuilder p = new StringBuilder(path.length() + 16);
            p.append("/rhelp");
            p.append('/');
            p.append(target != null ? target : path.substring(1, targetEnd));
            String info = path.substring(targetEnd + 1);
            if (rEnv == null) {
                p.append('/');
                p.append(info);
                return this.createHttpUrl(p, uri.getRawQuery(), uri.getRawFragment());
            }
            int idx3 = info.indexOf(47);
            if (idx3 < 0) {
                return null;
            }
            p.append('/');
            p.append(rEnv.getId());
            p.append(info.substring(idx3));
            return this.createHttpUrl(p, uri.getRawQuery(), uri.getRawFragment());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public @Nullable URI toHttpUrl(Object object, String target) {
        if (object == this) {
            return ABOUT_BLANK_URI;
        }
        if (object instanceof REnv) {
            return this.getREnvHttpUrl((REnv)object, target);
        }
        if (object instanceof REnvHelpConfiguration) {
            return this.getREnvHttpUrl(((REnvHelpConfiguration)object).getREnv(), target);
        }
        if (object instanceof RPkgHelp) {
            return this.getPackageHttpUrl((RPkgHelp)object, target);
        }
        if (object instanceof RHelpPage) {
            return this.getPageHttpUrl((RHelpPage)object, target);
        }
        Object object2 = object;
        if (object2 instanceof RHelpTopicLookup) {
            void lookup;
            RHelpTopicLookup rHelpTopicLookup = (RHelpTopicLookup)object2;
            RHelpTopicLookup cfr_ignored_0 = (RHelpTopicLookup)object2;
            return this.getTopicHttpUrl(lookup.getTopic(), null, lookup.getREnv(), target);
        }
        Object object3 = object;
        if (object3 instanceof String) {
            void s;
            String string = (String)object3;
            String cfr_ignored_1 = (String)object3;
            if (s.startsWith("http://")) {
                try {
                    return new URI((String)s);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public @Nullable Object getContentOfUrl(String url) {
        try {
            return this.getContentOfUrl(new URI(url));
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public @Nullable Object getContentOfUrl(URI url) {
        RHelpWebapp.RequestInfo info;
        String path;
        int targetEnd;
        if (this.isDynamicUrl(url) && (targetEnd = (path = this.getDynamicPath(url)).indexOf(47, 1)) > 1 && (info = RHelpWebapp.extractRequestInfo(path.substring(targetEnd))) != null) {
            REnv rEnv = this.rHelpManager.getREnv(info.rEnvId);
            if (rEnv != null && info.cat == "library") {
                REnvHelp help = this.rHelpManager.getHelp(rEnv);
                if (help != null) {
                    try {
                        RHelpPage page;
                        RPkgHelp pkgHelp = help.getPkgHelp(info.pkgName);
                        if (pkgHelp != null && info.cmd == 2 && (page = pkgHelp.getPage(info.detail)) != null) {
                            RHelpPage rHelpPage = page;
                            return rHelpPage;
                        }
                        RPkgHelp rPkgHelp = pkgHelp;
                        return rPkgHelp;
                    }
                    finally {
                        help.unlock();
                    }
                }
                return null;
            }
            if (rEnv != null && info.cat == "doc") {
                Object[] objectArray = new Object[2];
                objectArray[0] = rEnv;
                return objectArray;
            }
            return rEnv;
        }
        return null;
    }

    public boolean isPortableUrl(URI url) {
        return PORTABLE_URI_SCHEME.equals(url.getScheme());
    }

    public URI toHttpUrl(URI url) throws URISyntaxException {
        if (this.isPortableUrl(url)) {
            String path = (String)ObjectUtils.nonNullElse((Object)url.getPath(), (Object)"/");
            StringBuilder p = new StringBuilder("/rhelp".length() + path.length() + 2);
            p.append("/rhelp");
            if (path.isEmpty() || path.charAt(0) != '/') {
                p.append('/');
            }
            p.append(path);
            return this.createHttpUrl(p);
        }
        return url;
    }

    protected URI createPortableUrl(String path) throws URISyntaxException {
        return new URI(PORTABLE_URI_SCHEME, null, null, -1, path, null, null);
    }

    public @Nullable URI toPortableUrl(URI url) throws URISyntaxException {
        if (this.isDynamicUrl(url)) {
            String path = this.getDynamicPath(url);
            return this.createPortableUrl(path);
        }
        if (this.isPortableUrl(url)) {
            return url;
        }
        return null;
    }

    public @Nullable URI toServerUrl(URI url) {
        if (this.isDynamicUrl(url)) {
            REnvHelpConfiguration rEnvConfig;
            REnv rEnv;
            int envIdEnd;
            String path = this.getDynamicPath(url);
            int targetEnd = path.indexOf(47, 1);
            if (targetEnd > 1 && path.substring(1, targetEnd).equals(BROWSE_TARGET) && (envIdEnd = path.indexOf(47, targetEnd + 1)) > targetEnd + 2 && (rEnv = this.rHelpManager.getREnv(path.substring(targetEnd + 1, envIdEnd))) != null && (rEnvConfig = (REnvHelpConfiguration)rEnv.get(REnvHelpConfiguration.class)) != null && rEnvConfig.getStateSharedType() == "server") {
                try {
                    ServerClientSupport serverSupport = ServerClientSupport.getInstance();
                    return serverSupport.toServerBrowseUrl(rEnvConfig, path.substring(envIdEnd));
                }
                catch (Exception exception) {}
            }
        } else {
            String path = url.getPath();
            if (path != null && path.startsWith("/rhelp")) {
                return url;
            }
        }
        return null;
    }
}

