/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.core.util;

import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public abstract class AbstractSynchronizableDocument
extends AbstractDocument
implements ISynchronizable {
    private final Object lockObject;

    public AbstractSynchronizableDocument() {
        this.lockObject = this;
    }

    public AbstractSynchronizableDocument(Object lockObject) {
        this.lockObject = ObjectUtils.nonNullAssert((Object)lockObject);
    }

    public final Object getLockObject() {
        return this.lockObject;
    }

    public final void setLockObject(@Nullable Object lockObject) {
        throw new IllegalStateException("lock object already set");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get() {
        Object object = this.getLockObject();
        synchronized (object) {
            return super.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(int offset, int length) throws BadLocationException {
        Object object = this.getLockObject();
        synchronized (object) {
            return super.get(offset, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char getChar(int offset) throws BadLocationException {
        Object object = this.getLockObject();
        synchronized (object) {
            return super.getChar(offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getModificationStamp() {
        Object object = this.getLockObject();
        synchronized (object) {
            return super.getModificationStamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(int offset, int length, String text) throws BadLocationException {
        Object object = this.getLockObject();
        synchronized (object) {
            super.replace(offset, length, text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(int offset, int length, String text, long modificationStamp) throws BadLocationException {
        Object object = this.getLockObject();
        synchronized (object) {
            super.replace(offset, length, text, modificationStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String text) {
        Object object = this.getLockObject();
        synchronized (object) {
            super.set(text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String text, long modificationStamp) {
        Object object = this.getLockObject();
        synchronized (object) {
            super.set(text, modificationStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void startSequentialRewrite(boolean normalized) {
        Object object = this.getLockObject();
        synchronized (object) {
            super.startSequentialRewrite(normalized);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void stopSequentialRewrite() {
        Object object = this.getLockObject();
        synchronized (object) {
            super.stopSequentialRewrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentRewriteSession startRewriteSession(DocumentRewriteSessionType sessionType) {
        Object object = this.getLockObject();
        synchronized (object) {
            return super.startRewriteSession(sessionType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRewriteSession(DocumentRewriteSession session) {
        Object object = this.getLockObject();
        synchronized (object) {
            super.stopRewriteSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPositionCategory(String category) {
        Object object = this.getLockObject();
        synchronized (object) {
            super.addPositionCategory(category);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePositionCategory(String category) throws BadPositionCategoryException {
        Object object = this.getLockObject();
        synchronized (object) {
            super.removePositionCategory(category);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPosition(String category, Position position) throws BadLocationException, BadPositionCategoryException {
        Object object = this.getLockObject();
        synchronized (object) {
            super.addPosition(category, position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePosition(String category, @Nullable Position position) throws BadPositionCategoryException {
        Object object = this.getLockObject();
        synchronized (object) {
            super.removePosition(category, position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull Position[] getPositions(String category) throws BadPositionCategoryException {
        Object object = this.getLockObject();
        synchronized (object) {
            return super.getPositions(category);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull Position[] getPositions(String category, int offset, int length, boolean canStartBefore, boolean canEndAfter) throws BadPositionCategoryException {
        Object object = this.getLockObject();
        synchronized (object) {
            return super.getPositions(category, offset, length, canStartBefore, canEndAfter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull String[] getPartitionings() {
        Object object = this.getLockObject();
        synchronized (object) {
            return super.getPartitionings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentType(String partitioning, int offset, boolean preferOpenPartitions) throws BadLocationException, BadPartitioningException {
        Object object = this.getLockObject();
        synchronized (object) {
            return super.getContentType(partitioning, offset, preferOpenPartitions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull ITypedRegion[] computePartitioning(String partitioning, int offset, int length, boolean includeZeroLengthPartitions) throws BadLocationException, BadPartitioningException {
        Object object = this.getLockObject();
        synchronized (object) {
            return super.computePartitioning(partitioning, offset, length, includeZeroLengthPartitions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInitialLineDelimiter(String lineDelimiter) {
        Object object = this.getLockObject();
        synchronized (object) {
            super.setInitialLineDelimiter(lineDelimiter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultLineDelimiter() {
        Object object = this.getLockObject();
        synchronized (object) {
            return super.getDefaultLineDelimiter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable String getLineDelimiter(int line) throws BadLocationException {
        Object object = this.getLockObject();
        synchronized (object) {
            return super.getLineDelimiter(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfLines() {
        Object object = this.getLockObject();
        synchronized (object) {
            return super.getNumberOfLines();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfLines(int offset, int length) throws BadLocationException {
        Object object = this.getLockObject();
        synchronized (object) {
            return super.getNumberOfLines(offset, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineOfOffset(int pos) throws BadLocationException {
        Object object = this.getLockObject();
        synchronized (object) {
            return super.getLineOfOffset(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineOffset(int line) throws BadLocationException {
        Object object = this.getLockObject();
        synchronized (object) {
            return super.getLineOffset(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineLength(int line) throws BadLocationException {
        Object object = this.getLockObject();
        synchronized (object) {
            return super.getLineLength(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRegion getLineInformation(int line) throws BadLocationException {
        Object object = this.getLockObject();
        synchronized (object) {
            return super.getLineInformation(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRegion getLineInformationOfOffset(int offset) throws BadLocationException {
        Object object = this.getLockObject();
        synchronized (object) {
            return super.getLineInformationOfOffset(offset);
        }
    }
}

