/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.builder;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.r.core.project.RTaskMarkerHandler;

public class RdParser {
    private static final char[][] PLATFORM_KEYWORDS = new char[][]{"ifdef".toCharArray(), "ifndef".toCharArray(), "endif".toCharArray()};
    private final SourceContent sourceContent;
    private final char[] content;
    private final RTaskMarkerHandler markers;
    private int currentOffset = 0;
    private final int currentLine = 1;
    private Last lastChar = Last.NONE;

    public RdParser(SourceContent sourceContent, RTaskMarkerHandler markers) {
        this.sourceContent = sourceContent;
        this.content = sourceContent.getString().toCharArray();
        this.markers = markers;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void check() throws CoreException {
        while (this.currentOffset < this.content.length) {
            if (!this.checkNewLine() && !this.checkBackslash()) {
                char current = this.content[this.currentOffset];
                switch (current) {
                    case '%': {
                        this.readComment();
                        break;
                    }
                    case '#': {
                        if (this.lastChar != Last.NEWLINE) break;
                        int i = 0;
                        while (i < PLATFORM_KEYWORDS.length) {
                            int offset = this.currentOffset + 1;
                            int j = 0;
                            while (true) {
                                if (j >= PLATFORM_KEYWORDS[i].length) {
                                    this.readPlatformInstruction(PLATFORM_KEYWORDS[i]);
                                    break;
                                }
                                if (offset >= this.content.length || PLATFORM_KEYWORDS[i][j] != this.content[offset++]) break;
                                ++j;
                            }
                            ++i;
                        }
                        break;
                    }
                }
            }
            ++this.currentOffset;
        }
    }

    private void readPlatformInstruction(char[] keyword) {
        int start = this.currentOffset;
        int end = this.currentOffset++;
        while (this.currentOffset < this.content.length) {
            end = this.currentOffset++;
            if (this.checkNewLine()) break;
        }
    }

    private void readComment() throws CoreException {
        int start = this.currentOffset;
        int end = this.currentOffset++;
        while (this.currentOffset < this.content.length) {
            end = this.currentOffset++;
            if (!this.checkNewLine()) continue;
            --end;
            break;
        }
        try {
            this.markers.checkForTasks(start, end);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private boolean checkNewLine() {
        char current = this.content[this.currentOffset];
        if (current == '\r' || current == '\n') {
            if (current == '\r' && this.currentOffset + 1 < this.content.length && this.content[this.currentOffset + 1] == '\n') {
                ++this.currentOffset;
            }
            this.lastChar = Last.NEWLINE;
            return true;
        }
        return false;
    }

    private boolean checkBackslash() {
        if (this.content[this.currentOffset] == '\\') {
            this.lastChar = Last.BACKSLASH;
            return true;
        }
        if (this.lastChar == Last.BACKSLASH) {
            this.lastChar = Last.NONE;
            return true;
        }
        return false;
    }

    private static enum Last {
        NONE,
        NEWLINE,
        BACKSLASH;

    }
}

