/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core;

import org.eclipse.statet.ecommons.preferences.AbstractPreferencesModelObject;
import org.eclipse.statet.ecommons.preferences.PreferencesManageListener;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.RCodeStyleSettings;
import org.eclipse.statet.r.core.RCoreAccess;
import org.eclipse.statet.r.core.rsource.RSourceConfig;
import org.eclipse.statet.rj.renv.core.REnv;

@NonNullByDefault
final class RCoreAccessImpl
implements RCoreAccess {
    private boolean isDisposed;
    private final PreferenceAccess prefs;
    private final RSourceConfig rSourceConfig;
    private volatile @Nullable RCodeStyleSettings codeStyle;
    private @Nullable PreferencesManageListener codeStyleListener;
    private final REnv rEnv;

    RCoreAccessImpl(PreferenceAccess prefs, REnv rEnv, RSourceConfig rSourceConfig) {
        this.prefs = prefs;
        this.rEnv = rEnv;
        this.rSourceConfig = rSourceConfig;
    }

    @Override
    public PreferenceAccess getPrefs() {
        return this.prefs;
    }

    @Override
    public REnv getREnv() {
        return this.rEnv;
    }

    @Override
    public RSourceConfig getRSourceConfig() {
        return this.rSourceConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RCodeStyleSettings getRCodeStyle() {
        RCodeStyleSettings codeStyle = this.codeStyle;
        if (codeStyle == null) {
            RCoreAccessImpl rCoreAccessImpl = this;
            synchronized (rCoreAccessImpl) {
                codeStyle = this.codeStyle;
                if (codeStyle == null) {
                    codeStyle = new RCodeStyleSettings(1);
                    if (!this.isDisposed) {
                        this.codeStyleListener = new PreferencesManageListener((AbstractPreferencesModelObject)codeStyle, this.prefs, RCodeStyleSettings.ALL_GROUP_IDS);
                    }
                    codeStyle.load(this.prefs);
                    codeStyle.resetDirty();
                    this.codeStyle = codeStyle;
                }
            }
        }
        return codeStyle;
    }

    public synchronized void dispose() {
        this.isDisposed = true;
        if (this.codeStyleListener != null) {
            this.codeStyleListener.dispose();
            this.codeStyleListener = null;
        }
    }
}

