/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.redocs.tex.r.ui.editors;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.statet.docmlet.base.ui.sourceediting.DocEditor;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstNode;
import org.eclipse.statet.docmlet.tex.core.model.TexModel;
import org.eclipse.statet.docmlet.tex.ui.editors.LtxDefaultFoldingProvider;
import org.eclipse.statet.docmlet.tex.ui.editors.TexMarkOccurrencesLocator;
import org.eclipse.statet.docmlet.tex.ui.sourceediting.TexEditingSettings;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.internal.redocs.tex.r.RedocsTexRPlugin;
import org.eclipse.statet.internal.redocs.tex.r.ui.editors.LtxRweaveEditorTemplatesPage;
import org.eclipse.statet.internal.redocs.tex.r.ui.editors.LtxRweaveOutlinePage;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.util.AstSelection;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.ltk.ui.sourceediting.AbstractMarkOccurrencesProvider;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1OutlinePage;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorAddon;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.statet.ltk.ui.sourceediting.folding.FoldingEditorAddon;
import org.eclipse.statet.ltk.ui.sourceediting.folding.FoldingProvider;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.RCoreAccess;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.source.RDocumentConstants;
import org.eclipse.statet.r.ui.editors.RCorrectIndentHandler;
import org.eclipse.statet.r.ui.editors.RDefaultFoldingProvider;
import org.eclipse.statet.r.ui.editors.RMarkOccurrencesLocator;
import org.eclipse.statet.r.ui.editors.RSourceEditor;
import org.eclipse.statet.r.ui.sourceediting.InsertAssignmentHandler;
import org.eclipse.statet.redocs.r.core.source.DocContentSectionsRweaveExtension;
import org.eclipse.statet.redocs.r.ui.sourceediting.actions.RweaveToggleCommentHandler;
import org.eclipse.statet.redocs.tex.r.core.TexRweaveCore;
import org.eclipse.statet.redocs.tex.r.core.model.LtxRweaveSourceUnit;
import org.eclipse.statet.redocs.tex.r.core.source.LtxRweaveDocumentContentInfo;
import org.eclipse.statet.redocs.tex.r.ui.editors.LtxRweaveEditor;
import org.eclipse.statet.redocs.tex.r.ui.sourceediting.LtxRweaveSourceViewerConfiguration;
import org.eclipse.statet.redocs.tex.r.ui.sourceediting.LtxRweaveSourceViewerConfigurator;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.templates.ITemplatesPage;

@NonNullByDefault
public class LtxRweaveDocEditor
extends SourceEditor1
implements LtxRweaveEditor,
DocEditor {
    private static final ImList<String> KEY_CONTEXTS = ImCollections.newIdentityList((Object[])new String[]{"org.eclipse.statet.docmlet.contexts.TexEditor", "org.eclipse.statet.docmlet.contexts.DocEditor", "org.eclipse.statet.redocs.contexts.RweaveEditorScope"});
    private static final ImList<String> CONTEXT_IDS = ImCollections.concatList((Collection)ACTION_SET_CONTEXT_IDS, KEY_CONTEXTS);
    private LtxRweaveSourceViewerConfigurator combinedConfig;

    public LtxRweaveDocEditor() {
        super(TexRweaveCore.LTX_R_CONTENT_TYPE);
        this.combinedConfig = (LtxRweaveSourceViewerConfigurator)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.combinedConfig)));
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setEditorContextMenuId("org.eclipse.statet.redocs.menus.LtxRweaveEditorContextMenu");
        this.setRulerContextMenuId("org.eclipse.statet.redocs.menus.LtxRweaveEditorRulerMenu");
    }

    protected SourceEditorViewerConfigurator createConfiguration() {
        this.setDocumentProvider((IDocumentProvider)RedocsTexRPlugin.getInstance().getDocRDocumentProvider());
        this.enableStructuralFeatures(TexModel.getLtxModelManager(), (Preference)TexEditingSettings.FOLDING_ENABLED_PREF, (Preference)TexEditingSettings.MARKOCCURRENCES_ENABLED_PREF);
        this.combinedConfig = new LtxRweaveSourceViewerConfigurator(TexRweaveCore.TEX_WORKBENCH_ACCESS, RCore.WORKBENCH_ACCESS, new LtxRweaveSourceViewerConfiguration(0, this, null, null, null));
        return this.combinedConfig;
    }

    protected Collection<String> getContextIds() {
        return CONTEXT_IDS;
    }

    protected SourceEditorAddon createCodeFoldingProvider() {
        return new FoldingEditorAddon((FoldingProvider)new LtxDefaultFoldingProvider(Collections.singletonMap("R", new RDefaultFoldingProvider())));
    }

    protected SourceEditorAddon createMarkOccurrencesProvider() {
        return new ThisMarkOccurrencesProvider(this);
    }

    public RCoreAccess getRCoreAccess() {
        return this.combinedConfig.getRCoreAccess();
    }

    public DocContentSectionsRweaveExtension getDocumentContentInfo() {
        return (DocContentSectionsRweaveExtension)super.getDocumentContentInfo();
    }

    @Override
    public @Nullable LtxRweaveSourceUnit getSourceUnit() {
        return (LtxRweaveSourceUnit)super.getSourceUnit();
    }

    protected void setupConfiguration(@Nullable IEditorInput newInput) {
        super.setupConfiguration(newInput);
        LtxRweaveSourceUnit su = this.getSourceUnit();
        this.combinedConfig.setSource(su != null ? su.getTexCoreAccess() : TexRweaveCore.TEX_WORKBENCH_ACCESS, su != null ? su.getRCoreAccess() : RCore.WORKBENCH_ACCESS);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        if ("tabWidth".equals(event.getProperty()) || "spacesForTabs".equals(event.getProperty())) {
            return;
        }
        super.handlePreferenceStoreChanged(event);
    }

    protected boolean isTabsToSpacesConversionEnabled() {
        return false;
    }

    public void updateSettings(boolean indentChanged) {
        if (indentChanged) {
            this.updateIndentPrefixes();
        }
    }

    protected void collectContextMenuPreferencePages(List<String> pageIds) {
        super.collectContextMenuPreferencePages(pageIds);
        pageIds.add("org.eclipse.statet.r.preferencePages.LtxRweaveEditor");
        pageIds.add("org.eclipse.statet.docmlet.preferencePages.TexEditor");
        pageIds.add("org.eclipse.statet.docmlet.preferencePages.LtxTextStyles");
        pageIds.add("org.eclipse.statet.docmlet.preferencePages.LtxEditorTemplates");
        pageIds.add("org.eclipse.statet.docmlet.preferencePages.TexCodeStyle");
        pageIds.add("org.eclipse.statet.r.preferencePages.REditorOptions");
        pageIds.add("org.eclipse.statet.r.preferencePages.RTextStyles");
        pageIds.add("org.eclipse.statet.r.preferencePages.REditorTemplates");
        pageIds.add("org.eclipse.statet.r.preferencePages.RCodeStyle");
    }

    protected void createActions() {
        super.createActions();
        IHandlerService handlerService = (IHandlerService)ObjectUtils.nonNullAssert((Object)((IHandlerService)this.getServiceLocator().getService(IHandlerService.class)));
        InsertAssignmentHandler handler = new InsertAssignmentHandler((SourceEditor)this);
        handlerService.activateHandler("org.eclipse.statet.ltk.commands.InsertAssignment", (IHandler)handler);
        this.markAsStateDependentHandler((IHandler2)handler, true);
    }

    protected IHandler2 createToggleCommentHandler() {
        RweaveToggleCommentHandler handler = new RweaveToggleCommentHandler(this){

            protected void doPrefixPrimary(AbstractDocument document, IRegion block) throws BadLocationException, BadPartitioningException {
                this.doPrefix(document, block, "%");
            }
        };
        this.markAsStateDependentHandler((IHandler2)handler, true);
        return handler;
    }

    protected IHandler2 createCorrectIndentHandler() {
        DocContentSectionIndentHandler handler = new DocContentSectionIndentHandler((RSourceEditor)this);
        this.markAsStateDependentHandler((IHandler2)handler, true);
        return handler;
    }

    protected void editorContextMenuAboutToShow(IMenuManager m) {
        IWorkbenchPartSite site = this.getSite();
        LtxRweaveSourceUnit su = this.getSourceUnit();
        super.editorContextMenuAboutToShow(m);
        m.insertBefore("additions", (IContributionItem)new Separator("stat.submit"));
        IContributionItem additions = m.find("additions");
        if (additions != null) {
            additions.setVisible(false);
        }
        m.remove("ShiftRight");
        m.remove("ShiftLeft");
        m.appendToGroup("stat.submit", (IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)site, null, "org.eclipse.statet.r.commands.SubmitSelectionToR", 8)));
        m.appendToGroup("stat.submit", (IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)site, null, "org.eclipse.statet.r.commands.SubmitUptoSelectionToR", 8)));
    }

    protected SourceEditor1OutlinePage createOutlinePage() {
        return new LtxRweaveOutlinePage(this);
    }

    protected ITemplatesPage createTemplatesPage() {
        return new LtxRweaveEditorTemplatesPage(this);
    }

    public @NonNull String[] getShowInTargetIds() {
        return new String[]{"org.eclipse.ui.navigator.ProjectExplorer", "org.eclipse.ui.views.ContentOutline", "org.eclipse.statet.r.views.RHelp"};
    }

    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (adapterType == REnv.class) {
            return (T)this.getRCoreAccess().getREnv();
        }
        return (T)super.getAdapter(adapterType);
    }

    private static class DocContentSectionIndentHandler
    extends RCorrectIndentHandler {
        public DocContentSectionIndentHandler(RSourceEditor editor) {
            super((SourceEditor)editor);
        }

        protected List<? extends TextRegion> getCodeRanges(AbstractDocument document, ITextSelection selection) throws BadLocationException {
            return LtxRweaveDocumentContentInfo.INSTANCE.getRChunkCodeRegions((IDocument)document, selection.getOffset(), selection.getLength());
        }
    }

    private static class ThisMarkOccurrencesProvider
    extends AbstractMarkOccurrencesProvider {
        private final TexMarkOccurrencesLocator docLocator = new TexMarkOccurrencesLocator();
        private final RMarkOccurrencesLocator rLocator = new RMarkOccurrencesLocator();

        public ThisMarkOccurrencesProvider(SourceEditor1 editor) {
            super(editor, RDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT);
        }

        protected void doUpdate(AbstractMarkOccurrencesProvider.RunData run, SourceUnitModelInfo info, AstSelection astSelection, @Nullable ITextSelection orgSelection) throws BadLocationException, BadPartitioningException, UnsupportedOperationException {
            if (astSelection.getCovering() instanceof TexAstNode) {
                this.docLocator.run(run, info, astSelection, orgSelection);
            } else if (astSelection.getCovering() instanceof RAstNode) {
                this.rLocator.run(run, info, astSelection, orgSelection);
            }
        }
    }
}

