/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.statet.ecommons.text.core.util.NonDeletingPositionUpdater;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class SourceEditorViewer
extends ProjectionViewer {
    public static final int SHOW_SOURCE_OUTLINE = 51;
    public static final int SHOW_ELEMENT_OUTLINE = 52;
    public static final int SHOW_ELEMENT_HIERARCHY = 53;
    public static final int VARIABLE_LINE_HEIGHT = 16;
    private static final int QUICK_PRESENTER_START = 51;
    private static final int QUICK_PRESENTER_END = 53;
    private final int flags;
    private int lastSentSelectionOffset;
    private int lastSentSelectionLength;
    private IInformationPresenter sourceOutlinePresenter;
    private IInformationPresenter elementOutlinePresenter;
    private IInformationPresenter elementHierarchyPresenter;
    private ViewerState viewerState;

    public SourceEditorViewer(Composite parent, IVerticalRuler ruler, IOverviewRuler overviewRuler, boolean showsAnnotationOverview, int styles, int flags) {
        super(parent, ruler, overviewRuler, showsAnnotationOverview, styles);
        this.flags = flags;
        this.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ITextSelection selection = (ITextSelection)event.getSelection();
                if (SourceEditorViewer.this.lastSentSelectionOffset != selection.getOffset() || SourceEditorViewer.this.lastSentSelectionLength != selection.getLength()) {
                    Point currentSelection = SourceEditorViewer.this.getSelectedRange();
                    if (currentSelection.x == selection.getOffset() && currentSelection.y == selection.getLength()) {
                        SourceEditorViewer.this.fireSelectionChanged(currentSelection.x, currentSelection.y);
                    }
                }
            }
        });
    }

    protected void fireSelectionChanged(SelectionChangedEvent event) {
        ITextSelection selection = (ITextSelection)event.getSelection();
        this.lastSentSelectionOffset = selection.getOffset();
        this.lastSentSelectionLength = selection.getLength();
        super.fireSelectionChanged(event);
    }

    private IInformationPresenter getPresenter(int operation) {
        switch (operation) {
            case 51: {
                return this.sourceOutlinePresenter;
            }
            case 52: {
                return this.elementOutlinePresenter;
            }
            case 53: {
                return this.elementHierarchyPresenter;
            }
        }
        return null;
    }

    private void setPresenter(int operation, IInformationPresenter presenter) {
        switch (operation) {
            case 51: {
                this.sourceOutlinePresenter = presenter;
                return;
            }
            case 52: {
                this.elementOutlinePresenter = presenter;
                return;
            }
            case 53: {
                this.elementHierarchyPresenter = presenter;
                return;
            }
        }
        if (presenter != null) {
            presenter.uninstall();
        }
    }

    public boolean canDoOperation(int operation) {
        switch (operation) {
            case 51: 
            case 52: 
            case 53: {
                return this.getPresenter(operation) != null;
            }
        }
        return super.canDoOperation(operation);
    }

    public void doOperation(int operation) {
        switch (operation) {
            case 51: 
            case 52: 
            case 53: {
                IInformationPresenter presenter = this.getPresenter(operation);
                if (presenter != null) {
                    presenter.showInformation();
                }
                return;
            }
        }
        super.doOperation(operation);
    }

    public void configure(SourceViewerConfiguration configuration) {
        super.configure(configuration);
        if (configuration instanceof SourceEditorViewerConfiguration) {
            int operation = 51;
            while (operation < 53) {
                IInformationPresenter presenter = ((SourceEditorViewerConfiguration)configuration).getQuickPresenter((ISourceViewer)this, operation);
                if (presenter != null) {
                    presenter.install((ITextViewer)this);
                }
                this.setPresenter(operation, presenter);
                ++operation;
            }
        }
    }

    public void unconfigure() {
        int operation = 51;
        while (operation < 53) {
            IInformationPresenter presenter = this.getPresenter(operation);
            if (presenter != null) {
                presenter.uninstall();
                this.setPresenter(operation, null);
            }
            ++operation;
        }
        super.unconfigure();
    }

    public @NonNull String @Nullable [] getDefaultPrefixes(String contentType) {
        return this.fDefaultPrefixChars != null ? (String[])this.fDefaultPrefixChars.get(contentType) : null;
    }

    protected void disableRedrawing() {
        if ((this.flags & 0x10) != 0) {
            this.viewerState = new ViewerState();
        }
        super.disableRedrawing();
    }

    protected void enabledRedrawing(int topIndex) {
        super.enabledRedrawing(topIndex);
        if (this.viewerState != null) {
            this.viewerState.disconnect();
            if (topIndex == -1) {
                this.viewerState.updateViewport();
            }
            this.viewerState = null;
        }
    }

    public void setSelectedRange(int selectionOffset, int selectionLength) {
        if (this.viewerState != null && !this.redraws()) {
            this.viewerState.updateSelection(selectionOffset, selectionLength);
            return;
        }
        super.setSelectedRange(selectionOffset, selectionLength);
    }

    private final class ViewerState {
        private Position selection;
        private Position stableLine;
        private int stablePixel;
        private IPositionUpdater updater;
        private IDocument updaterDocument;
        private String updaterCategory;
        private int topPixel;

        public ViewerState() {
            IDocument document = SourceEditorViewer.this.getDocument();
            if (document != null) {
                this.connect(document);
            }
        }

        public void updateSelection(int offset, int length) {
            if (this.selection == null) {
                this.selection = new Position(offset, length);
                if (this.isConnected()) {
                    try {
                        this.updaterDocument.addPosition(this.updaterCategory, this.selection);
                    }
                    catch (BadLocationException | BadPositionCategoryException throwable) {}
                }
            } else {
                this.updatePosition(this.selection, offset, length);
            }
        }

        private void updateViewport() {
            StyledText textWidget = SourceEditorViewer.this.getTextWidget();
            if (this.selection != null) {
                textWidget.setTopPixel(this.topPixel);
                SourceEditorViewer.this.revealRange(this.selection.getOffset(), this.selection.getLength());
            } else if (this.stableLine != null) {
                int stableLine;
                try {
                    stableLine = this.updaterDocument.getLineOfOffset(this.stableLine.getOffset());
                }
                catch (BadLocationException x) {
                    textWidget.setTopPixel(this.topPixel);
                    return;
                }
                int stableWidgetLine = SourceEditorViewer.this.getClosestWidgetLineForModelLine(stableLine);
                if (stableWidgetLine == -1) {
                    textWidget.setTopPixel(this.topPixel);
                    return;
                }
                int linePixel = textWidget.getLinePixel(stableWidgetLine);
                int delta = this.stablePixel - linePixel;
                int topPixel = textWidget.getTopPixel();
                textWidget.setTopPixel(topPixel - delta);
            }
        }

        private void connect(IDocument document) {
            Assert.isLegal((document != null ? 1 : 0) != 0);
            Assert.isLegal((!this.isConnected() ? 1 : 0) != 0);
            this.updaterDocument = document;
            try {
                StyledText textWidget = SourceEditorViewer.this.getTextWidget();
                this.updaterCategory = "ViewerState-" + this.hashCode();
                this.updater = new NonDeletingPositionUpdater(this.updaterCategory);
                this.updaterDocument.addPositionCategory(this.updaterCategory);
                this.updaterDocument.addPositionUpdater(this.updater);
                int stableLine = this.getStableLine();
                int stableWidgetLine = SourceEditorViewer.this.modelLine2WidgetLine(stableLine);
                this.stablePixel = textWidget.getLinePixel(stableWidgetLine);
                IRegion stableLineInfo = this.updaterDocument.getLineInformation(stableLine);
                this.stableLine = new Position(stableLineInfo.getOffset(), stableLineInfo.getLength());
                this.updaterDocument.addPosition(this.updaterCategory, this.stableLine);
                this.topPixel = textWidget.getTopPixel();
            }
            catch (BadPositionCategoryException e) {
                Assert.isTrue((boolean)false);
            }
            catch (BadLocationException e) {
                this.disconnect();
            }
        }

        private void updatePosition(Position position, int offset, int length) {
            position.setOffset(offset);
            position.setLength(length);
            position.isDeleted = false;
        }

        private int getStableLine() {
            int caretLine = SourceEditorViewer.this.getTextWidget().getLineAtOffset(SourceEditorViewer.this.getTextWidget().getCaretOffset());
            int stableLine = caretLine < JFaceTextUtil.getPartialTopIndex((StyledText)SourceEditorViewer.this.getTextWidget()) || caretLine > JFaceTextUtil.getPartialBottomIndex((StyledText)SourceEditorViewer.this.getTextWidget()) ? JFaceTextUtil.getPartialTopIndex((ITextViewer)SourceEditorViewer.this) : SourceEditorViewer.this.widgetLine2ModelLine(caretLine);
            return stableLine;
        }

        private boolean isConnected() {
            return this.updater != null;
        }

        private void disconnect() {
            if (this.isConnected()) {
                try {
                    this.updaterDocument.removePosition(this.updaterCategory, this.stableLine);
                    this.updaterDocument.removePositionUpdater(this.updater);
                    this.updater = null;
                    this.updaterDocument.removePositionCategory(this.updaterCategory);
                    this.updaterCategory = null;
                }
                catch (BadPositionCategoryException x) {
                    Assert.isTrue((boolean)false);
                }
            }
        }
    }
}

