/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import org.eclipse.statet.internal.jcommons.collections.AbstractImList;
import org.eclipse.statet.internal.jcommons.collections.ArrayUtils;
import org.eclipse.statet.internal.jcommons.collections.ImEmptyList;
import org.eclipse.statet.jcommons.collections.ImCollection;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public final class ImEmptyIdentityList<E>
extends AbstractImList<E>
implements ImIdentityList<E>,
RandomAccess {
    public static final ImEmptyIdentityList INSTANCE = new ImEmptyIdentityList();
    private final ListIterator<E> iterator = new AbstractImList.AbstractImListIter<E>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public E next() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public E previous() {
            throw new NoSuchElementException();
        }
    };

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean contains(@Nullable Object e) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return c.isEmpty();
    }

    @Override
    public E get(int index) {
        throw new IndexOutOfBoundsException("index= " + index);
    }

    @Override
    public E getFirst() {
        throw new NoSuchElementException();
    }

    @Override
    public E getLast() {
        throw new NoSuchElementException();
    }

    @Override
    public int indexOf(@Nullable Object e) {
        return -1;
    }

    @Override
    public int lastIndexOf(@Nullable Object e) {
        return -1;
    }

    @Override
    public Iterator<E> iterator() {
        return this.iterator;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.iterator;
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        return this.iterator;
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.emptySpliterator();
    }

    @Override
    public ImIdentityList<E> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > 0) {
            throw new IndexOutOfBoundsException("fromIndex= " + fromIndex + ", toIndex= " + toIndex + ", size= 1");
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex > toIndex: fromIndex= " + fromIndex + ", toIndex= " + toIndex);
        }
        return this;
    }

    @Override
    public Object[] toArray() {
        return ArrayUtils.EMPTY_OBJ;
    }

    @Override
    public <T> T[] toArray(T[] dest) {
        if (dest.length > 0) {
            dest[0] = null;
        }
        return dest;
    }

    @Override
    public <T> T[] toArray(IntFunction<T[]> generator) {
        return generator.apply(0);
    }

    @Override
    public void copyTo(int srcIndex, Object[] dest, int destIndex, int length) {
        assert (false);
    }

    @Override
    public void copyTo(Object[] dest, int destIndex) {
    }

    @Override
    public ImList<E> toList() {
        return ImEmptyList.INSTANCE;
    }

    @Override
    public ImIdentityList<E> toIdentityList() {
        return this;
    }

    @Override
    public ImIdentityList<E> reversed() {
        return this;
    }

    @Override
    public <R> ImCollection.MappingResult<R> map(Function<E, R> mapper) {
        ObjectUtils.nonNullAssert(mapper);
        return ImEmptyList.INSTANCE;
    }

    @Override
    public @Nullable E findFirst(Predicate<E> predicate) {
        ObjectUtils.nonNullAssert(predicate);
        return null;
    }

    @Override
    public boolean anyMatch(Predicate<? super E> predicate) {
        ObjectUtils.nonNullAssert(predicate);
        return false;
    }

    @Override
    public boolean allMatch(Predicate<? super E> predicate) {
        ObjectUtils.nonNullAssert(predicate);
        return true;
    }

    @Override
    public boolean noneMatch(Predicate<? super E> predicate) {
        ObjectUtils.nonNullAssert(predicate);
        return true;
    }

    @Override
    public int hashCode() {
        return 1;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof List) {
            List other = (List)obj;
            return other.isEmpty();
        }
        return false;
    }

    public String toString() {
        return "[]";
    }
}

