/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.source.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.r.core.source.RTerminal;
import org.eclipse.statet.r.core.source.ast.Expression;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.RAstVisitor;
import org.eclipse.statet.r.core.source.ast.SingleValue;

@NonNullByDefault
public abstract class SubNamed
extends RAstNode {
    final Expression expr = new Expression();
    SingleValue subname;
    int operatorOffset = Integer.MIN_VALUE;

    SubNamed() {
    }

    @Override
    public final boolean hasChildren() {
        return true;
    }

    @Override
    public final int getChildCount() {
        return 2;
    }

    @Override
    public final RAstNode getChild(int index) {
        return switch (index) {
            case 0 -> this.expr.node;
            case 1 -> this.subname;
            default -> throw new IndexOutOfBoundsException();
        };
    }

    @Override
    public final int getChildIndex(AstNode child) {
        if (this.expr.node == child) {
            return 0;
        }
        if (this.subname == child) {
            return 1;
        }
        return -1;
    }

    public final RAstNode getRefChild() {
        return this.expr.node;
    }

    public final RAstNode getSubnameChild() {
        return this.subname;
    }

    @Override
    public final void acceptInR(RAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    @Override
    public final void acceptInRChildren(RAstVisitor visitor) throws InvocationTargetException {
        this.expr.node.acceptInR(visitor);
        this.subname.acceptInR(visitor);
    }

    public final void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        visitor.visit((AstNode)this.expr.node);
        visitor.visit((AstNode)this.subname);
    }

    @Override
    final @Nullable Expression getExpr(RAstNode child) {
        if (this.expr.node == child) {
            return this.expr;
        }
        return null;
    }

    @Override
    final Expression getLeftExpr() {
        return this.expr;
    }

    @Override
    final @Nullable Expression getRightExpr() {
        return null;
    }

    @Override
    public final boolean equalsSingle(RAstNode element) {
        if (this.getNodeType() == element.getNodeType()) {
            SubNamed other = (SubNamed)element;
            return (this.expr.node == other.expr.node || this.expr.node != null && this.expr.node.equalsSingle(other.expr.node)) && (this.subname == other.subname || this.subname != null && this.subname.equalsSingle(other.subname));
        }
        return false;
    }

    @Override
    final int getMissingExprStatus(Expression expr) {
        if (this.expr == expr) {
            return 4195089;
        }
        throw new IllegalArgumentException();
    }

    final void updateOffsets() {
        this.doSetStartEndOffset(this.expr.node.getStartOffset(), this.subname.getEndOffset());
    }

    static final class Named
    extends SubNamed {
        Named() {
        }

        @Override
        public final NodeType getNodeType() {
            return NodeType.SUB_NAMED_PART;
        }

        @Override
        public final RTerminal getOperator(int index) {
            return RTerminal.SUB_NAMED_PART;
        }
    }

    static final class Slot
    extends SubNamed {
        Slot() {
        }

        @Override
        public final NodeType getNodeType() {
            return NodeType.SUB_NAMED_SLOT;
        }

        @Override
        public final RTerminal getOperator(int index) {
            return RTerminal.SUB_NAMED_SLOT;
        }
    }
}

