/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.net.core.ssh.sshd;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.channel.ChannelDirectTcpip;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.forward.ExplicitPortForwardingTracker;
import org.apache.sshd.client.session.forward.PortForwardingTracker;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.eclipse.jgit.internal.transport.sshd.AuthenticationCanceledException;
import org.eclipse.jgit.internal.transport.sshd.AuthenticationLogger;
import org.eclipse.jgit.internal.transport.sshd.JGitSshClient;
import org.eclipse.statet.internal.jcommons.net.core.sshd.Messages;
import org.eclipse.statet.internal.jcommons.net.core.sshd.SshdUtils;
import org.eclipse.statet.internal.jcommons.net.core.sshd.StatetSshdInternals;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.io.IOUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.net.CommonsNet;
import org.eclipse.statet.jcommons.net.core.RemoteProcess;
import org.eclipse.statet.jcommons.net.core.TunnelClientSocketImpl;
import org.eclipse.statet.jcommons.net.core.ssh.BasicSshClientSession;
import org.eclipse.statet.jcommons.net.core.ssh.OpenSshConfigUtils;
import org.eclipse.statet.jcommons.net.core.ssh.SshTarget;
import org.eclipse.statet.jcommons.runtime.ProcessConfig;
import org.eclipse.statet.jcommons.status.CancelStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;

@NonNullByDefault
public class SshdClientSession
extends BasicSshClientSession<ClientSession> {
    private static final SshdSocketAddress LOCAL_LOCALHOST_ADDRESS = new SshdSocketAddress(CommonsNet.LOCAL_LOOPBACK_STRING, 0);
    private static final int MAX_DEPTH = 10;
    private final SshClient client;

    public SshdClientSession(SshTarget target, @Nullable Duration timeout, SshClient client) {
        super(target, timeout);
        this.client = client;
        this.client.start();
    }

    protected ClientSession connect(@Nullable Duration timeout, ProgressMonitor m) throws Exception {
        SshTarget target = this.getTarget();
        return this.connect(target.getUri(), (List<URI>)ImCollections.emptyList(), (SshFutureListener<CloseFuture>)((SshFutureListener)future -> this.disconnect()), timeout, 10, m);
    }

    private ClientSession connect(URI target, List<URI> jumps, @Nullable SshFutureListener<CloseFuture> listener, @Nullable Duration timeout, int depth, ProgressMonitor m) throws IOException, StatusException {
        if (--depth < 0) {
            throw new IOException(MessageFormat.format(Messages.get().proxyJumpAbort, target));
        }
        String host = target.getHost();
        if (host == null) {
            throw new IOException("The host component is missing: " + String.valueOf(target));
        }
        HostConfigEntry hostConfig = this.getHostConfig(target.getUserInfo(), host, target.getPort());
        jumps = SshdUtils.determineHops(jumps, hostConfig, host);
        m.setWorkRemaining((jumps.size() + 1) * 2);
        ClientSession resultSession = null;
        ClientSession proxySession = null;
        ExplicitPortForwardingTracker portForward = null;
        try {
            Duration hostTimeout;
            if (!jumps.isEmpty()) {
                URI hop = jumps.remove(0);
                if (StatetSshdInternals.isDebugEnabled()) {
                    StatetSshdInternals.logDebug(String.format("Connecting to jump host: %1$s", hop));
                }
                proxySession = this.connect(hop, jumps, null, timeout, depth, m);
            }
            AttributeRepository context = null;
            if (proxySession != null) {
                SshdSocketAddress remoteAddress = new SshdSocketAddress(hostConfig.getHostName(), hostConfig.getPort());
                portForward = proxySession.createLocalPortForwardingTracker(SshdSocketAddress.LOCALHOST_ADDRESS, remoteAddress);
                context = AttributeRepository.ofKeyValuePair((AttributeRepository.AttributeKey)JGitSshClient.LOCAL_FORWARD_ADDRESS, (Object)portForward.getBoundAddress());
            }
            resultSession = this.connect(hostConfig, context, (hostTimeout = OpenSshConfigUtils.parseDuration((String)hostConfig.getProperty("ConnectTimeout"))) != null ? hostTimeout : timeout, m);
            m.addWorked(1);
            if (proxySession != null) {
                ExplicitPortForwardingTracker tracker = portForward;
                ClientSession pSession = proxySession;
                resultSession.addCloseFutureListener(arg_0 -> SshdClientSession.lambda$1((PortForwardingTracker)tracker, pSession, arg_0));
                portForward = null;
                proxySession = null;
            }
            if (listener != null) {
                resultSession.addCloseFutureListener(listener);
            }
            this.auth(resultSession, hostConfig, m);
            m.addWorked(1);
            return resultSession;
        }
        catch (Exception e) {
            IOUtils.close(portForward, (Throwable)e);
            IOUtils.close(proxySession, (Throwable)e);
            IOUtils.close(resultSession, (Throwable)e);
            throw e;
        }
    }

    private ClientSession connect(HostConfigEntry hostConfig, @Nullable AttributeRepository context, @Nullable Duration timeout, ProgressMonitor m) throws IOException, StatusException {
        m.beginSubTask(String.format("Connecting to '%1$s'...", hostConfig.getHostName()));
        ConnectFuture connect = (ConnectFuture)SshdUtils.verify(() -> this.client.connect(hostConfig, context, null), timeout, m);
        return connect.getClientSession();
    }

    private void auth(ClientSession session, HostConfigEntry hostConfig, ProgressMonitor m) throws IOException, StatusException {
        m.beginSubTask(String.format("Connecting to '%1$s' \u2022 Authenticate...", hostConfig.getHostName()));
        AuthenticationLogger authLog = null;
        try {
            try {
                authLog = new AuthenticationLogger(session);
                long authStartTime = System.nanoTime();
                SshdUtils.verify(session.auth(), authStartTime, session.getAuthTimeout(), m);
                m.beginSubTask(String.format("Connecting to '%1$s' \u2022 Authenticate \u2713", hostConfig.getHostName()));
            }
            catch (SshException e) {
                String host = hostConfig.getHostName();
                int port = hostConfig.getPort();
                if (e.getDisconnectCode() == 14) {
                    String message = MessageFormat.format(Messages.get().loginDenied, host, Integer.toString(port));
                    throw new IOException(SshdUtils.attachAuthLog(message, authLog), e);
                }
                if (e.getCause() instanceof AuthenticationCanceledException) {
                    String message = (String)ObjectUtils.nonNullElse((Object)e.getCause().getMessage(), (Object)"Canceled");
                    throw new StatusException((Status)new CancelStatus("org.eclipse.statet.jcommons.net.core.ssh.apache", SshdUtils.attachAuthLog(message, authLog), e.getCause()));
                }
                throw e;
            }
        }
        finally {
            if (authLog != null) {
                authLog.clear();
            }
        }
    }

    protected void disconnect(@Nullable ClientSession session) throws Exception {
        try {
            if (session != null) {
                session.close();
            }
        }
        finally {
            this.client.close();
        }
    }

    private HostConfigEntry getHostConfig(String username, String host, int port) throws IOException {
        HostConfigEntry entry = this.client.getHostConfigEntryResolver().resolveEffectiveHost(host, port, null, username, null, null);
        if (entry == null) {
            if (SshdSocketAddress.isIPv6Address((String)host)) {
                return new HostConfigEntry("", host, port, username);
            }
            return new HostConfigEntry(host, host, port, username);
        }
        return entry;
    }

    public RemoteProcess exec(ClientSession session, ProcessConfig processConfig, @Nullable Duration timeout, ProgressMonitor m) throws Exception {
        ChannelExec channel = session.createExecChannel(processConfig.getCommandString(), null, processConfig.getEnvironmentVars());
        try {
            InputStream in = processConfig.getInputStream();
            OutputStream out = IOUtils.orNullStream((OutputStream)processConfig.getOutputStream());
            channel.setIn(in);
            channel.setOut(out);
            channel.setRedirectErrorStream(true);
            SshdUtils.verify(() -> channel.open(), timeout, m);
            return new SshdExecProcess(processConfig, channel);
        }
        catch (Exception e) {
            channel.close(true);
            throw e;
        }
    }

    public TunnelClientSocketImpl createDirectTcpIpSocketImpl(ClientSession session) throws Exception {
        return new SshdDirectClientSocketImpl(session);
    }

    protected InetSocketAddress startPortForwardingL(ClientSession session, InetSocketAddress targetAddress, @Nullable Duration timeout) throws Exception {
        SshdSocketAddress localAddress = session.startLocalPortForwarding(LOCAL_LOCALHOST_ADDRESS, new SshdSocketAddress(targetAddress));
        return localAddress.toInetSocketAddress();
    }

    protected void stopPortForwardingL(ClientSession session, InetSocketAddress targetAddress, InetSocketAddress localAddress, @Nullable Duration timeout) throws Exception {
        session.stopLocalPortForwarding(new SshdSocketAddress(localAddress));
    }

    private static /* synthetic */ void lambda$1(PortForwardingTracker portForwardingTracker, ClientSession clientSession, CloseFuture future) {
        IoUtils.closeQuietly((Closeable)portForwardingTracker);
        String sessionName = clientSession.toString();
        try {
            clientSession.close();
        }
        catch (IOException e) {
            StatetSshdInternals.logError(MessageFormat.format(Messages.get().sshProxySessionCloseFailed, sessionName), e);
        }
    }

    private static class SshdDirectClientSocketImpl
    extends TunnelClientSocketImpl {
        private final ClientSession session;
        private @Nullable ChannelDirectTcpip channel;

        public SshdDirectClientSocketImpl(ClientSession session) throws IOException {
            this.session = session;
        }

        protected void connectRemote(InetSocketAddress targetAddress, @Nullable Duration timeout, ProgressMonitor m) throws IOException, StatusException {
            ChannelDirectTcpip channel;
            this.channel = channel = this.session.createDirectTcpipChannel(LOCAL_LOCALHOST_ADDRESS, new SshdSocketAddress(targetAddress));
            SshdUtils.verify(() -> channel.open(), timeout, m);
            InputStream in = channel.getIn();
            this.setInputStream(in);
            ChannelOutputStream out = (ChannelOutputStream)channel.getOut();
            out.setNoDelay(this.tcpNoDelay);
            this.setOutputStream((OutputStream)out);
        }

        protected void close() throws IOException {
            super.close();
            ChannelDirectTcpip channel = this.channel;
            if (channel == null) {
                return;
            }
            channel.close();
        }

        public void setOption(int optID, Object value) throws SocketException {
            switch (optID) {
                case 1: {
                    boolean tcpNoDelay = (Boolean)value;
                    if (tcpNoDelay != this.tcpNoDelay) {
                        this.tcpNoDelay = tcpNoDelay;
                        try {
                            ((ChannelOutputStream)this.getOutputStream()).setNoDelay(tcpNoDelay);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return;
                }
            }
            super.setOption(optID, value);
        }
    }

    private static class SshdExecProcess
    extends RemoteProcess {
        private static final Set<ClientChannelEvent> EXIT_EVENTS = EnumSet.of(ClientChannelEvent.EXIT_STATUS, ClientChannelEvent.CLOSED);
        private final ChannelExec channel;

        public SshdExecProcess(ProcessConfig processConfig, ChannelExec channel) {
            super(processConfig.getCommandString());
            this.channel = channel;
        }

        public boolean isAlive() {
            return !this.channel.isClosed() && this.channel.getExitStatus() == null;
        }

        public boolean waitFor(@Nullable Duration timeout) throws InterruptedException {
            this.channel.waitFor(EXIT_EVENTS, timeout);
            return this.isAlive();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int waitFor(@Nullable Duration timeout, ProgressMonitor m) throws StatusException {
            futureLock = this.channel.getFutureLock();
            if (timeout == null) ** GOTO lbl38
            timeoutTime = System.nanoTime() + timeout.toNanos();
            var6_6 = futureLock;
            synchronized (var6_6) {
                while (true) {
                    if (!this.isAlive()) {
                        return this.getExitStatusCode();
                    }
                    if (m.isCanceled()) {
                        throw this.newCancelException();
                    }
                    remainingNanos = timeoutTime - System.nanoTime();
                    if (remainingNanos <= 0L) {
                        throw this.newTimeoutException(timeout);
                    }
                    try {
                        futureLock.wait(Math.min(TimeUnit.NANOSECONDS.toMillis(remainingNanos), 100L));
                    }
                    catch (InterruptedException var9_8) {
                        // empty catch block
                    }
                }
            }
lbl-1000:
            // 1 sources

            {
                if (m.isCanceled()) {
                    throw this.newCancelException();
                }
                var4_5 = futureLock;
                synchronized (var4_5) {
                    if (!this.isAlive()) {
                        return this.getExitStatusCode();
                    }
                    try {
                        futureLock.wait(100L);
                    }
                    catch (InterruptedException var5_9) {
                        // empty catch block
                    }
                    continue;
                }
lbl38:
                // 3 sources

                ** while (this.isAlive())
            }
lbl39:
            // 1 sources

            return this.getExitStatusCode();
        }

        public int getExitStatusCode() {
            boolean closed = this.channel.isClosed();
            Integer exitCode = this.channel.getExitStatus();
            if (exitCode == null) {
                if (closed) {
                    return -1;
                }
                throw new IllegalThreadStateException("The process has not terminated");
            }
            return exitCode;
        }

        public void close() {
            if (this.channel.isOpen()) {
                this.channel.close(false);
            }
        }
    }
}

