/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.preferences;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.ui.ManagedConfigurationBlock;
import org.eclipse.statet.ecommons.runtime.core.StatusChangeListener;
import org.eclipse.statet.ecommons.ui.components.EditableTextList;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.viewers.ComparatorViewerComparator;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.internal.r.ui.RIdentifierCellValidator;
import org.eclipse.statet.internal.r.ui.preferences.Messages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.r.core.RSymbolComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

class RIdentifiersBlock
extends ManagedConfigurationBlock {
    private TableViewer categoryList;
    private EditableTextList wordList;
    private Category[] categories;
    private Category activeCategory;
    private final StatusChangeListener statusListener;

    public RIdentifiersBlock(StatusChangeListener statusListener) {
        super(null, null);
        this.statusListener = statusListener;
    }

    protected void createBlockArea(Composite pageComposite) {
        this.categories = new Category[]{new Category(Messages.RSyntaxColoring_Identifier_Assignment_label, "text_R_rDefault.Assignment.items"), new Category(Messages.RSyntaxColoring_Identifier_FlowControl_label, "text_R_rDefault.Flowcontrol.items"), new Category(Messages.RSyntaxColoring_Identifier_Logical_label, "text_R_rDefault.Logical.items"), new Category(Messages.RSyntaxColoring_Identifier_Custom1_label, "text_R_rDefault.Custom2.items"), new Category(Messages.RSyntaxColoring_Identifier_Custom2_label, "text_R_rDefault.Custom1.items")};
        HashMap<Preference.StringArrayPref, String> prefs = new HashMap<Preference.StringArrayPref, String>();
        int i = 0;
        while (i < this.categories.length) {
            prefs.put(this.categories[i].pref, "r.editor/identifiergroups");
            ++i;
        }
        this.setupPreferenceManager(prefs);
        Label label = new Label(pageComposite, 0);
        label.setText(Messages.RIdentifiers_GroupsList_label);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ViewerUtils.TableComposite categoryComposite = new ViewerUtils.TableComposite(pageComposite, 68100);
        GridData gd = new GridData(4, 4, true, false);
        gd.heightHint = LayoutUtils.hintHeight((Table)categoryComposite.table, (int)4);
        categoryComposite.setLayoutData((Object)gd);
        this.categoryList = categoryComposite.viewer;
        this.categoryList.setContentProvider((IContentProvider)new ArrayContentProvider());
        TableViewerColumn column = new TableViewerColumn(this.categoryList, 0);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
        categoryComposite.layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(100));
        label = new Label(pageComposite, 0);
        label.setText(Messages.RIdentifiers_IdentifiersList_label);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.wordList = new EditableTextList();
        Control control = this.wordList.create(pageComposite, (ViewerComparator)new ComparatorViewerComparator((Comparator)new RSymbolComparator()));
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        this.wordList.getColumn().setEditingSupport((EditingSupport)new WordEditing(this.wordList));
        this.categoryList.setInput((Object)this.categories);
        this.categoryList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Category cat = (Category)((IStructuredSelection)event.getSelection()).getFirstElement();
                RIdentifiersBlock.this.wordList.setInput(cat.set);
                RIdentifiersBlock.this.activeCategory = cat;
            }
        });
        this.activeCategory = this.categories[0];
        this.updateControls();
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (UIAccess.isOkToUse((Viewer)RIdentifiersBlock.this.categoryList)) {
                    RIdentifiersBlock.this.categoryList.setSelection((ISelection)new StructuredSelection((Object)RIdentifiersBlock.this.activeCategory));
                }
            }
        });
    }

    public void updatePreferences() {
        int i = 0;
        while (i < this.categories.length) {
            this.categories[i].save();
            ++i;
        }
        super.updatePreferences();
    }

    protected void updateControls() {
        int i = 0;
        while (i < this.categories.length) {
            this.categories[i].load();
            ++i;
        }
        this.wordList.refresh();
    }

    private class Category {
        private final String label;
        private final Preference.StringArrayPref pref;
        private final IObservableSet<String> set = new WritableSet();

        public Category(String label, String prefKey) {
            this.label = label;
            this.pref = new Preference.StringArrayPref("org.eclipse.statet.r.ui", prefKey);
        }

        void load() {
            this.set.clear();
            Object[] words = (String[])RIdentifiersBlock.this.getPreferenceValue((Preference)this.pref);
            if (words != null) {
                this.set.addAll((Collection)ImCollections.newList((Object[])words));
            }
        }

        void save() {
            RIdentifiersBlock.this.setPrefValue((Preference)this.pref, (String[])this.set.toArray((Object[])new String[this.set.size()]));
        }

        public String toString() {
            return this.label;
        }
    }

    private class WordEditing
    extends EditingSupport {
        private final TextCellEditor cellEditor;
        private final EditableTextList list;
        private Object last;

        public WordEditing(EditableTextList list) {
            super((ColumnViewer)list.getViewer());
            this.list = list;
            this.cellEditor = new TextCellEditor((Composite)list.getViewer().getTable());
            this.cellEditor.addListener(new ICellEditorListener(){

                public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                    if (!newValidState) {
                        ((WordEditing)WordEditing.this).RIdentifiersBlock.this.statusListener.statusChanged((IStatus)new Status(4, "org.eclipse.statet.r.ui", WordEditing.this.cellEditor.getErrorMessage()));
                    } else {
                        ((WordEditing)WordEditing.this).RIdentifiersBlock.this.statusListener.statusChanged(Status.OK_STATUS);
                    }
                }

                public void applyEditorValue() {
                    WordEditing.this.last = null;
                    ((WordEditing)WordEditing.this).RIdentifiersBlock.this.statusListener.statusChanged(Status.OK_STATUS);
                }

                public void cancelEditor() {
                    if (WordEditing.this.last == "") {
                        WordEditing.this.list.applyChange((Object)"", null);
                    }
                    ((WordEditing)WordEditing.this).RIdentifiersBlock.this.statusListener.statusChanged(Status.OK_STATUS);
                }
            });
            this.cellEditor.setValidator((ICellEditorValidator)new RIdentifierCellValidator(){

                @Override
                public String isValid(Object value) {
                    String valid = super.isValid(value);
                    if (valid == null) {
                        if (!value.equals(WordEditing.this.last) && ((WordEditing)WordEditing.this).RIdentifiersBlock.this.activeCategory.set.contains(value)) {
                            return Messages.RIdentifiers_Identifier_error_AlreadyExistingInSameGroup_message;
                        }
                        int i = 0;
                        while (i < ((WordEditing)WordEditing.this).RIdentifiersBlock.this.categories.length) {
                            if (((WordEditing)WordEditing.this).RIdentifiersBlock.this.categories[i] != ((WordEditing)WordEditing.this).RIdentifiersBlock.this.activeCategory && ((WordEditing)WordEditing.this).RIdentifiersBlock.this.categories[i].set.contains(value)) {
                                return NLS.bind((String)Messages.RIdentifiers_Identifier_error_AlreadyExistingInOtherGroup_message, (Object)((WordEditing)WordEditing.this).RIdentifiersBlock.this.categories[i].label);
                            }
                            ++i;
                        }
                    }
                    return valid;
                }
            });
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.cellEditor;
        }

        protected Object getValue(Object element) {
            this.last = element;
            return element;
        }

        protected void setValue(Object element, Object value) {
            if (value != null) {
                this.list.applyChange(element, value != "" ? value : null);
            }
        }
    }
}

