/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import com.ibm.icu.text.Collator;
import java.util.Comparator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.InclusivePositionUpdater;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.statet.ecommons.text.ui.DefaultBrowserInformationInput;
import org.eclipse.statet.ecommons.text.ui.assist.PositionBasedCompletionProposal;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.SearchPattern;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ui.LtkUI;
import org.eclipse.statet.ltk.ui.sourceediting.TextEditToolSynchronizer;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.SourceProposal;
import org.eclipse.statet.ltk.ui.templates.IWorkbenchTemplateContext;
import org.eclipse.statet.ltk.ui.util.LTKSelectionUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public class TemplateProposal
extends SourceProposal
implements ICompletionProposalExtension5 {
    private final Template template;
    private final DocumentTemplateContext templateContext;
    private final Image image;
    private TextRegion region;
    private @Nullable InclusivePositionUpdater updater;

    public TemplateProposal(TemplateProposalParameters<?> parameters, Image image) {
        super(parameters);
        this.template = (Template)ObjectUtils.nonNullAssert((Object)parameters.template);
        this.templateContext = (DocumentTemplateContext)ObjectUtils.nonNullAssert((Object)parameters.templateContext);
        this.image = (Image)ObjectUtils.nonNullAssert((Object)image);
        this.region = (TextRegion)ObjectUtils.nonNullAssert((Object)parameters.region);
    }

    public TemplateProposal(TemplateProposalParameters<?> parameters) {
        this(parameters, LtkUI.getUIResources().getImage("org.eclipse.statet.ltk/images/obj/text-Template"));
    }

    protected TemplateContext getContext() {
        return this.templateContext;
    }

    protected Template getTemplate() {
        return this.template;
    }

    protected boolean isSelectionTemplate() {
        DocumentTemplateContext docContext;
        return this.templateContext instanceof DocumentTemplateContext && (docContext = this.templateContext).getCompletionLength() > 0;
    }

    @Override
    protected String getName() {
        return this.template.getName();
    }

    @Override
    public String getSortingString() {
        return this.template.getName();
    }

    @Override
    public String getDisplayString() {
        return this.getStyledDisplayString().getString();
    }

    @Override
    public StyledString computeStyledText() {
        StyledString styledText = new StyledString(this.template.getName());
        if (!this.template.getDescription().isEmpty()) {
            styledText.append("\u2002\u2013\u2002", StyledString.QUALIFIER_STYLER);
            styledText.append(this.template.getDescription(), StyledString.QUALIFIER_STYLER);
        }
        return styledText;
    }

    @Override
    public Image getImage() {
        return this.image;
    }

    public @Nullable Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        try {
            String preview;
            TemplateContext context = this.getContext();
            context.setReadOnly(true);
            if (context instanceof IWorkbenchTemplateContext) {
                preview = ((IWorkbenchTemplateContext)context).evaluateInfo(this.getTemplate());
            } else {
                TemplateBuffer templateBuffer = context.evaluate(this.getTemplate());
                String string = preview = templateBuffer != null ? templateBuffer.toString() : null;
            }
            if (preview != null) {
                return new DefaultBrowserInformationInput(this.getDisplayString(), preview, 2, ((AssistInvocationContext)this.getInvocationContext()).getTabWidth());
            }
        }
        catch (BadLocationException | TemplateException throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean isAutoInsertable() {
        if (this.isSelectionTemplate()) {
            return false;
        }
        return this.template.isAutoInsertable();
    }

    @Override
    public @Nullable CharSequence getPrefixCompletionText(IDocument document, int offset) {
        if (this.isSelectionTemplate()) {
            return null;
        }
        return super.getPrefixCompletionText(document, offset);
    }

    @Override
    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        block16: {
            IDocument document = viewer.getDocument();
            SourceProposal.ApplyData applyData = this.getApplyData();
            Position regionPosition = new Position(this.region.getStartOffset(), this.region.getLength());
            Position offsetPosition = new Position(offset, 0);
            try {
                TemplateBuffer templateBuffer;
                document.addPosition(regionPosition);
                document.addPosition(offsetPosition);
                this.templateContext.setReadOnly(false);
                try {
                    templateBuffer = (TemplateBuffer)ObjectUtils.nonNullAssert((Object)this.templateContext.evaluate(this.template));
                }
                catch (NullPointerException | TemplateException e) {
                    applyData.setSelection(this.region);
                    document.removePosition(regionPosition);
                    document.removePosition(offsetPosition);
                    return;
                }
                try {
                    this.region = LTKSelectionUtils.toTextRegion(regionPosition);
                    int start = this.getReplaceOffset();
                    int end = Math.max(this.getReplaceEndOffset(), offsetPosition.getOffset());
                    String templateString = templateBuffer.getString();
                    document.replace(start, end - start, templateString);
                    LinkedModeModel model = new LinkedModeModel();
                    TemplateVariable[] variables = templateBuffer.getVariables();
                    boolean hasPositions = false;
                    int i = 0;
                    while (i != variables.length) {
                        TemplateVariable variable = variables[i];
                        if (!variable.isUnambiguous()) {
                            LinkedPositionGroup group = new LinkedPositionGroup();
                            int[] offsets = variable.getOffsets();
                            int length = variable.getLength();
                            String[] values = variable.getValues();
                            ICompletionProposal[] proposals = new ICompletionProposal[values.length];
                            int j = 0;
                            while (j < values.length) {
                                this.ensurePositionCategoryInstalled(document, model);
                                Position pos = new Position(offsets[0] + start, length);
                                document.addPosition(this.getCategory(), pos);
                                proposals[j] = new PositionBasedCompletionProposal(values[j], pos, length);
                                ++j;
                            }
                            j = 0;
                            while (j < offsets.length) {
                                if (j == 0 && proposals.length > 1) {
                                    group.addPosition((LinkedPosition)new ProposalPosition(document, offsets[j] + start, length, proposals));
                                } else {
                                    group.addPosition(new LinkedPosition(document, offsets[j] + start, length));
                                }
                                ++j;
                            }
                            model.addGroup(group);
                            hasPositions = true;
                        }
                        ++i;
                    }
                    if (hasPositions) {
                        model.forceInstall();
                        TextEditToolSynchronizer toolSynchronizer = ((AssistInvocationContext)this.getInvocationContext()).getEditor().getTextEditToolSynchronizer();
                        if (toolSynchronizer != null) {
                            toolSynchronizer.install(model);
                        }
                        LinkedModeUI ui = new LinkedModeUI(model, viewer);
                        ui.setExitPosition(viewer, this.getCaretOffset(templateBuffer) + start, 0, Integer.MAX_VALUE);
                        ui.enter();
                        applyData.setSelection(LTKSelectionUtils.toTextRegion(ui.getSelectedRegion()));
                        break block16;
                    }
                    this.ensurePositionCategoryRemoved(document);
                    applyData.setSelection(this.getCaretOffset(templateBuffer) + start);
                }
                catch (BadLocationException | BadPositionCategoryException e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ltk.ui", 0, "Template Evaluation Error", e));
                    applyData.clearSelection();
                }
            }
            finally {
                document.removePosition(regionPosition);
                document.removePosition(offsetPosition);
            }
        }
    }

    private String getCategory() {
        return "TemplateProposalCategory_" + this.toString();
    }

    private void ensurePositionCategoryInstalled(final IDocument document, LinkedModeModel model) {
        if (!document.containsPositionCategory(this.getCategory())) {
            document.addPositionCategory(this.getCategory());
            this.updater = new InclusivePositionUpdater(this.getCategory());
            document.addPositionUpdater((IPositionUpdater)this.updater);
            model.addLinkingListener(new ILinkedModeListener(){

                public void left(LinkedModeModel environment, int flags) {
                    TemplateProposal.this.ensurePositionCategoryRemoved(document);
                }

                public void suspend(LinkedModeModel environment) {
                }

                public void resume(LinkedModeModel environment, int flags) {
                }
            });
        }
    }

    private void ensurePositionCategoryRemoved(IDocument document) {
        if (document.containsPositionCategory(this.getCategory())) {
            try {
                document.removePositionCategory(this.getCategory());
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                // empty catch block
            }
            document.removePositionUpdater((IPositionUpdater)this.updater);
        }
    }

    private int getCaretOffset(TemplateBuffer buffer) {
        TemplateVariable[] variables = buffer.getVariables();
        int i = 0;
        while (i != variables.length) {
            TemplateVariable variable = variables[i];
            if (variable.getType().equals("cursor")) {
                return variable.getOffsets()[0];
            }
            ++i;
        }
        return buffer.getString().length();
    }

    protected final int getReplaceOffset() {
        int start;
        if (this.templateContext instanceof DocumentTemplateContext) {
            DocumentTemplateContext docContext = this.templateContext;
            start = docContext.getStart();
        } else {
            start = this.region.getStartOffset();
        }
        return start;
    }

    protected final int getReplaceEndOffset() {
        int end;
        if (this.templateContext instanceof DocumentTemplateContext) {
            DocumentTemplateContext docContext = this.templateContext;
            end = docContext.getEnd();
        } else {
            end = this.region.getEndOffset();
        }
        return end;
    }

    @Override
    public int getContextInformationPosition() {
        return this.region.getStartOffset();
    }

    public static class TemplateComparator
    implements Comparator<TemplateProposal> {
        private final Collator collator = Collator.getInstance();

        @Override
        public int compare(TemplateProposal arg0, TemplateProposal arg1) {
            int result = this.collator.compare(arg0.getTemplate().getName(), arg1.getTemplate().getName());
            if (result != 0) {
                return result;
            }
            return this.collator.compare(arg0.getDisplayString(), arg1.getDisplayString());
        }
    }

    public static class TemplateProposalParameters<TContext extends AssistInvocationContext>
    extends SourceProposal.ProposalParameters<TContext> {
        public final DocumentTemplateContext templateContext;
        public final TextRegion region;
        public Template template;

        public TemplateProposalParameters(TContext context, TextRegion region, SearchPattern namePattern, DocumentTemplateContext templateContext) {
            super(context, region.getStartOffset(), namePattern);
            this.templateContext = templateContext;
            this.region = region;
        }

        public TemplateProposalParameters(TContext context, TextRegion region, DocumentTemplateContext templateContext, Template template) {
            super(context, region.getStartOffset(), 0);
            this.templateContext = templateContext;
            this.region = region;
            this.template = template;
        }
    }
}

