/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ltk.ui.config;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.masterdetail.MasterDetailObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.databinding.core.validation.IntegerValidator;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.ui.ColorSelectorObservableValue;
import org.eclipse.statet.ecommons.preferences.ui.ManagedConfigurationBlock;
import org.eclipse.statet.ecommons.preferences.ui.RGBPref;
import org.eclipse.statet.ecommons.runtime.core.StatusChangeListener;
import org.eclipse.statet.ecommons.text.ui.settings.DecorationPreferences;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.internal.ltk.ui.config.Messages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.LtkUIPreferences;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistPreferences;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

@NonNullByDefault
class EditorsConfigurationBlock
extends ManagedConfigurationBlock {
    private ListViewer colorList;
    private ColorSelector colorEditor;
    private Preference.BooleanPref matchingBracketsPref;
    private Button matchingBracketsControl;
    private Preference.IntPref contentAssistDelayPref;
    private Text contentAssistDelayControl;
    private Preference<Boolean> contentAssistShowSubstringMatchesPref;
    private Button contentAssistShowSubstringMatchesControl;
    private Preference.BooleanPref contentAssistAutoSinglePref;
    private Button contentAssistSingleControl;
    private Preference.BooleanPref contentAssistAutoCommonPref;
    private Button contentAssistAutoCommonControl;

    public EditorsConfigurationBlock(@Nullable StatusChangeListener statusListener) {
        super(null, Messages.Editors_title, statusListener);
    }

    protected void createBlockArea(Composite pageComposite) {
        HashMap<Object, @Nullable String> prefs = new HashMap<Object, String>();
        ArrayList<AppearanceColorsItem> colors = new ArrayList<AppearanceColorsItem>();
        DecorationPreferences decoPrefs = LtkUIPreferences.getEditorDecorationPreferences();
        this.matchingBracketsPref = decoPrefs.getMatchingBracketsEnabled();
        prefs.put(this.matchingBracketsPref, null);
        AppearanceColorsItem color = new AppearanceColorsItem(Messages.Editors_MatchingBracketsHighlightColor, decoPrefs.getMatchingBracketsColor());
        colors.add(color);
        prefs.put(color.pref, null);
        color = new AppearanceColorsItem(Messages.Editors_CodeAssistParametersForegrondColor, LtkUIPreferences.CONTEXT_INFO_FOREGROUND_COLOR_PREF);
        colors.add(color);
        prefs.put(color.pref, "Ltk/assist");
        color = new AppearanceColorsItem(Messages.Editors_CodeAssistParametersBackgroundColor, LtkUIPreferences.CONTEXT_INFO_BACKGROUND_COLOR_PREF);
        colors.add(color);
        prefs.put(color.pref, "Ltk/assist");
        AssistPreferences assistPreferences = LtkUIPreferences.getAssistPreferences();
        this.contentAssistShowSubstringMatchesPref = assistPreferences.getShowSubstringMatchesPref();
        prefs.put(this.contentAssistShowSubstringMatchesPref, "Ltk/assist");
        this.contentAssistDelayPref = LtkUIPreferences.CONTENT_ASSIST_AUTO_ACTIVATION_DELAY_PREF;
        prefs.put(this.contentAssistDelayPref, "Ltk/assist");
        this.contentAssistAutoSinglePref = assistPreferences.getAutoInsertSinglePref();
        prefs.put(this.contentAssistAutoSinglePref, "Ltk/assist");
        this.contentAssistAutoCommonPref = assistPreferences.getAutoInsertPrefixPref();
        prefs.put(this.contentAssistAutoCommonPref, "Ltk/assist");
        this.setupPreferenceManager(prefs);
        this.addLinkHeader(pageComposite, Messages.Editors_link);
        Composite group = this.createAppearanceSection(pageComposite);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        LayoutUtils.addSmallFiller((Composite)pageComposite, (boolean)false);
        group = this.createAssistSection(pageComposite);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        this.colorList.setInput((Object)colors.toArray(new AppearanceColorsItem[colors.size()]));
        this.colorList.setSelection((ISelection)new StructuredSelection(colors.get(0)));
        this.initBindings();
        this.updateControls();
    }

    private Composite createAppearanceSection(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.Editors_Appearance);
        group.setLayout((Layout)LayoutUtils.newGroupGrid((int)2));
        this.matchingBracketsControl = new Button((Composite)group, 16416);
        this.matchingBracketsControl.setText(Messages.Editors_HighlightMatchingBrackets);
        this.matchingBracketsControl.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        LayoutUtils.addSmallFiller((Composite)group, (boolean)false);
        Composite colorComposite = new Composite((Composite)group, 0);
        GridData gd = new GridData(4, 4, true, false, 2, 1);
        colorComposite.setLayoutData((Object)gd);
        colorComposite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        Label label = new Label(colorComposite, 16384);
        label.setText(Messages.Editors_AppearanceColors);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.colorList = new ListViewer(colorComposite, 2564);
        this.colorList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.colorList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(@Nullable Object element) {
                AppearanceColorsItem item = (AppearanceColorsItem)element;
                return item.name;
            }
        });
        this.colorList.getControl().setLayoutData((Object)new GridData(4, 4, false, false));
        Composite colorOptions = new Composite(colorComposite, 0);
        colorOptions.setLayoutData((Object)new GridData(4, 4, true, true));
        colorOptions.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        label = new Label(colorOptions, 16384);
        label.setText(Messages.Editors_Color);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.colorEditor = new ColorSelector(colorOptions);
        this.colorEditor.getButton().setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        return group;
    }

    private Composite createAssistSection(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setText(Messages.Editors_ContentAssist);
        composite.setLayout((Layout)LayoutUtils.newGroupGrid((int)2));
        Button button = new Button((Composite)composite, 32);
        button.setText(Messages.Editors_ContentAssist_Show_SubstringMatches_label);
        button.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.contentAssistShowSubstringMatchesControl = button;
        LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
        button = new Button((Composite)composite, 32);
        button.setText(Messages.Editors_ContentAssist_AutoInsertSingle);
        button.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.contentAssistSingleControl = button;
        button = new Button((Composite)composite, 32);
        button.setText(Messages.Editors_ContentAssist_AutoInsertCommon);
        button.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.contentAssistAutoCommonControl = button;
        LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
        Label label = new Label((Composite)composite, 16384);
        label.setText(Messages.Editors_ContentAssist_AutoTriggerDelay_label);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Text text = new Text((Composite)composite, 2052);
        GridData gd = new GridData(16384, 0x1000000, true, false);
        gd.widthHint = LayoutUtils.hintWidth((Text)text, (int)4);
        text.setLayoutData((Object)gd);
        this.contentAssistDelayControl = text;
        return composite;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void addBindings(DataBindingSupport db) {
        db.getContext().bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.matchingBracketsControl), this.createObservable((Preference)this.matchingBracketsPref));
        @Nullable IViewerObservableValue colorItem = ViewerProperties.singleSelection(AppearanceColorsItem.class).observe((Viewer)this.colorList);
        db.getContext().bindValue((IObservableValue)new ColorSelectorObservableValue(this.colorEditor), MasterDetailObservables.detailValue((IObservableValue)colorItem, (IObservableFactory)new IObservableFactory<AppearanceColorsItem, IObservableValue<RGB>>(){

            public IObservableValue<@Nullable RGB> createObservable(AppearanceColorsItem target) {
                return EditorsConfigurationBlock.this.createObservable((Preference)target.pref);
            }
        }, RGB.class));
        db.getContext().bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.contentAssistShowSubstringMatchesControl), this.createObservable(this.contentAssistShowSubstringMatchesPref));
        db.getContext().bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.contentAssistDelayControl), this.createObservable((Preference)this.contentAssistDelayPref), new UpdateValueStrategy().setAfterGetValidator((IValidator)new IntegerValidator(10, 2000, Messages.Editors_ContentAssist_AutoTriggerDelay_error_message)), null);
        db.getContext().bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.contentAssistSingleControl), this.createObservable((Preference)this.contentAssistAutoSinglePref));
        db.getContext().bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.contentAssistAutoCommonControl), this.createObservable((Preference)this.contentAssistAutoCommonPref));
    }

    private static class AppearanceColorsItem {
        final String name;
        final RGBPref pref;

        AppearanceColorsItem(String label, RGBPref pref) {
            this.name = label;
            this.pref = pref;
        }
    }
}

