/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.Objects;
import org.eclipse.jetty.server.AliasCheck;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.resource.Resource;

public class TrailingSlashAliasChecker
extends AbstractLifeCycle
implements AliasCheck {
    @Override
    public boolean checkAlias(String pathInContext, Resource resource) {
        String uri = resource.getURI().toString();
        if (uri.isEmpty()) {
            return false;
        }
        String realUri = resource.getRealURI().toString();
        if (uri.endsWith("/") && !realUri.endsWith("/")) {
            return Objects.equals(uri.substring(0, uri.length() - 1), realUri);
        }
        return false;
    }
}

