/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.tools.launch.rwt.internal.tab;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.rap.tools.launch.rwt.internal.config.RWTLaunchConfig;
import org.eclipse.rap.tools.launch.rwt.internal.tab.HelpContextIds;
import org.eclipse.rap.tools.launch.rwt.internal.tab.RWTLaunchTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class ServerSettingsSection
extends RWTLaunchTab {
    private Button cbManualPort;
    private Spinner spnPort;
    private Button cbSessionTimeout;
    private Spinner spnSessionTimeout;
    private Button cbContextPath;
    private Text txtContextPath;

    public String getName() {
        return "Server Settings";
    }

    public void createControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        group.setText("Server Settings");
        group.setLayout((Layout)new GridLayout(4, false));
        this.cbManualPort = this.createCheckButton((Composite)group, "Use a fixed &port:");
        this.cbManualPort.addSelectionListener((SelectionListener)new UpdateConfigSelectionListener());
        this.spnPort = new Spinner((Composite)group, 2048);
        this.spnPort.setLayoutData((Object)new GridData(4, -1, true, false));
        this.spnPort.setMinimum(0);
        this.spnPort.setMaximum(65535);
        this.spnPort.addModifyListener((ModifyListener)new UpdateConfigModifyListener());
        this.cbSessionTimeout = new Button((Composite)group, 32);
        GridDataFactory.fillDefaults().indent(25, 0).applyTo((Control)this.cbSessionTimeout);
        this.cbSessionTimeout.setText("Session &timeout [min]:");
        this.cbSessionTimeout.addSelectionListener((SelectionListener)new UpdateConfigSelectionListener());
        this.spnSessionTimeout = new Spinner((Composite)group, 2048);
        this.spnSessionTimeout.setLayoutData((Object)new GridData(4, -1, true, false));
        this.spnSessionTimeout.setMinimum(0);
        this.spnSessionTimeout.setMaximum(Integer.MAX_VALUE);
        this.spnSessionTimeout.addModifyListener((ModifyListener)new UpdateConfigModifyListener());
        this.cbContextPath = new Button((Composite)group, 32);
        this.cbContextPath.setText("Context pat&h:");
        this.cbContextPath.addSelectionListener((SelectionListener)new UpdateConfigSelectionListener());
        this.txtContextPath = new Text((Composite)group, 2052);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.txtContextPath);
        this.txtContextPath.addModifyListener((ModifyListener)new UpdateConfigModifyListener());
        this.updateEnablement();
        this.setControl((Control)group);
        HelpContextIds.assign(this.getControl(), HelpContextIds.MAIN_TAB);
    }

    public void initializeFrom(RWTLaunchConfig launchConfig) {
        this.cbManualPort.setSelection(launchConfig.getUseManualPort());
        this.spnPort.setSelection(launchConfig.getPort());
        this.cbSessionTimeout.setSelection(launchConfig.getUseSessionTimeout());
        this.spnSessionTimeout.setSelection(launchConfig.getSessionTimeout());
        this.cbContextPath.setSelection(launchConfig.getUseManualContextPath());
        this.txtContextPath.setText(launchConfig.getContextPath());
        this.updateEnablement();
    }

    public void performApply(RWTLaunchConfig launchConfig) {
        launchConfig.setUseManualPort(this.cbManualPort.getSelection());
        launchConfig.setPort(this.spnPort.getSelection());
        launchConfig.setUseSessionTimeout(this.cbSessionTimeout.getSelection());
        launchConfig.setSessionTimeout(this.spnSessionTimeout.getSelection());
        launchConfig.setUseManualContextPath(this.cbContextPath.getSelection());
        launchConfig.setContextPath(this.txtContextPath.getText().trim());
    }

    private void updateEnablement() {
        this.spnPort.setEnabled(this.cbManualPort.getSelection());
        this.spnSessionTimeout.setEnabled(this.cbSessionTimeout.getSelection());
        this.txtContextPath.setEnabled(this.cbContextPath.getSelection());
    }

    private class UpdateConfigModifyListener
    implements ModifyListener {
        private UpdateConfigModifyListener() {
        }

        public void modifyText(ModifyEvent event) {
            ServerSettingsSection.this.updateLaunchConfigurationDialog();
        }
    }

    private class UpdateConfigSelectionListener
    extends SelectionAdapter {
        private UpdateConfigSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            ServerSettingsSection.this.updateEnablement();
            ServerSettingsSection.this.updateLaunchConfigurationDialog();
        }
    }
}

