/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.rwt.tab;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.rap.ui.internal.launch.rwt.config.BrowserMode;
import org.eclipse.rap.ui.internal.launch.rwt.config.RWTLaunchConfig;
import org.eclipse.rap.ui.internal.launch.rwt.tab.HelpContextIds;
import org.eclipse.rap.ui.internal.launch.rwt.tab.RWTLaunchTab;
import org.eclipse.rap.ui.internal.launch.rwt.util.URLBuilder;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class BrowserSection
extends RWTLaunchTab {
    private static final String BROWSER_PREFERENCE_PAGE = "org.eclipse.ui.browser.preferencePage";
    private final GridDataFactory fillHorizontal;
    private Button cbOpenBrowser;
    private Button rbInternalBrowser;
    private Button rbExternalBrowser;
    private Label lblServletPath;
    private Text txtServletPath;
    private Text txtApplicationUrl;

    public BrowserSection() {
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this.fillHorizontal = GridDataFactory.createFrom((GridData)gridData);
    }

    public String getName() {
        return "Browser";
    }

    public void createControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)this.fillHorizontal.create());
        group.setText("Open in Browser");
        group.setLayout((Layout)new GridLayout());
        this.createBrowserActivationPart((Composite)group);
        this.createServletPathPart((Composite)group);
        this.setControl((Control)group);
        HelpContextIds.assign(this.getControl(), HelpContextIds.MAIN_TAB);
        this.updateEnablement();
    }

    private void createBrowserActivationPart(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)this.fillHorizontal.span(2, 1).create());
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        this.cbOpenBrowser = new Button(composite, 32);
        this.cbOpenBrowser.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.cbOpenBrowser.setText("&Open application in");
        this.cbOpenBrowser.addSelectionListener((SelectionListener)new OpenBrowserSelectionListener());
        Link browserPrefsLink = this.createBrowserPrefsLink(composite);
        browserPrefsLink.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        Composite modePart = this.createBrowserModePart(composite);
        modePart.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).indent(17, 0).create());
    }

    private Link createBrowserPrefsLink(Composite composite) {
        Link link = new Link(composite, 0);
        link.setText("<a>Configure Browsers...</a>");
        link.addSelectionListener((SelectionListener)new BrowserPrefsSelectionListener());
        return link;
    }

    private Composite createBrowserModePart(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new RowLayout(256));
        this.rbInternalBrowser = new Button(composite, 16);
        this.rbInternalBrowser.setText("Interna&l web browser");
        this.rbInternalBrowser.addSelectionListener((SelectionListener)new BrowserSelectionListener());
        this.rbExternalBrowser = new Button(composite, 16);
        this.rbExternalBrowser.setText("E&xternal web browser");
        this.rbExternalBrowser.addSelectionListener((SelectionListener)new BrowserSelectionListener());
        return composite;
    }

    private void createServletPathPart(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)this.fillHorizontal.create());
        composite.setLayout((Layout)new GridLayout(2, false));
        this.lblServletPath = new Label(composite, 0);
        this.lblServletPath.setText("&Servlet path:");
        this.txtServletPath = new Text(composite, 2048);
        this.txtServletPath.addModifyListener((ModifyListener)new TextModifyListener());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.txtServletPath);
        Label lblApplicationUrl = new Label(composite, 0);
        lblApplicationUrl.setText("Application URL:");
        this.txtApplicationUrl = new Text(composite, 12);
        this.txtApplicationUrl.setBackground(this.txtApplicationUrl.getParent().getBackground());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.txtApplicationUrl);
    }

    public void initializeFrom(RWTLaunchConfig config) {
        BrowserMode browserMode = config.getBrowserMode();
        this.cbOpenBrowser.setSelection(config.getOpenBrowser());
        this.rbInternalBrowser.setSelection(browserMode == BrowserMode.INTERNAL);
        this.rbExternalBrowser.setSelection(browserMode == BrowserMode.EXTERNAL);
        this.txtServletPath.setText(config.getServletPath());
        this.updateEnablement();
    }

    public void performApply(RWTLaunchConfig config) {
        config.setOpenBrowser(this.cbOpenBrowser.getSelection());
        if (this.rbExternalBrowser.getSelection()) {
            config.setBrowserMode(BrowserMode.EXTERNAL);
        } else {
            config.setBrowserMode(BrowserMode.INTERNAL);
        }
        config.setServletPath(this.txtServletPath.getText().trim());
    }

    private void updateEnablement() {
        boolean openBrowser = this.cbOpenBrowser.getSelection();
        this.rbInternalBrowser.setEnabled(openBrowser);
        this.rbExternalBrowser.setEnabled(openBrowser);
        this.lblServletPath.setEnabled(openBrowser);
        this.txtServletPath.setEnabled(openBrowser);
    }

    private void handleBrowserPrefsLink() {
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)BROWSER_PREFERENCE_PAGE, null, null);
        dialog.open();
        dialog.close();
    }

    public void updateApplicationUrl(RWTLaunchConfig config) {
        this.updateApplicationUrl(URLBuilder.fromLaunchConfig(config));
    }

    private void updateApplicationUrl(final String applicationUrl) {
        if (this.txtApplicationUrl != null && !this.txtApplicationUrl.isDisposed()) {
            this.txtApplicationUrl.getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (!applicationUrl.equals(BrowserSection.this.txtApplicationUrl.getText())) {
                        BrowserSection.this.txtApplicationUrl.setText(applicationUrl);
                    }
                }
            });
        }
    }

    private class BrowserPrefsSelectionListener
    extends SelectionAdapter {
        private BrowserPrefsSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            BrowserSection.this.handleBrowserPrefsLink();
        }
    }

    private class BrowserSelectionListener
    extends SelectionAdapter {
        private BrowserSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            BrowserSection.this.updateLaunchConfigurationDialog();
        }
    }

    private class OpenBrowserSelectionListener
    extends SelectionAdapter {
        private OpenBrowserSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            BrowserSection.this.updateLaunchConfigurationDialog();
            BrowserSection.this.updateEnablement();
        }
    }

    private class TextModifyListener
    implements ModifyListener {
        private TextModifyListener() {
        }

        public void modifyText(ModifyEvent event) {
            BrowserSection.this.updateLaunchConfigurationDialog();
        }
    }
}

