/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.rwt.shortcut;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IType;
import org.eclipse.rap.ui.internal.launch.rwt.config.RWTLaunchConfig;

public class LaunchConfigCreator {
    private final IType type;
    private ILaunchConfigurationWorkingCopy launchConfig;

    public static ILaunchConfiguration fromType(IType type) throws CoreException {
        return new LaunchConfigCreator(type).create();
    }

    private LaunchConfigCreator(IType type) {
        this.type = type;
    }

    private ILaunchConfiguration create() throws CoreException {
        ILaunchConfigurationType configType = RWTLaunchConfig.getType();
        String name = this.launchConfigNameFromType();
        this.launchConfig = configType.newInstance(null, name);
        this.launchConfig.setMappedResources(new IResource[]{this.type.getUnderlyingResource()});
        RWTLaunchConfig.setDefaults(this.launchConfig);
        RWTLaunchConfig rwtLaunchConfig = new RWTLaunchConfig((ILaunchConfiguration)this.launchConfig);
        rwtLaunchConfig.setProjectName(this.getProjectName());
        rwtLaunchConfig.setEntryPoint(this.type.getFullyQualifiedName());
        return this.launchConfig.doSave();
    }

    private String launchConfigNameFromType() {
        String qualifiedName = this.type.getTypeQualifiedName('.');
        return LaunchConfigCreator.getLaunchManager().generateLaunchConfigurationName(qualifiedName);
    }

    private String getProjectName() {
        return this.type.getJavaProject().getElementName();
    }

    private static ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }
}

