/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.rwt.delegate;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.rap.ui.internal.launch.rwt.RWTLaunchActivator;
import org.eclipse.rap.ui.internal.launch.rwt.config.RWTLaunchConfig;
import org.eclipse.rap.ui.internal.launch.rwt.util.IOUtil;

class RWTLaunch {
    private static final String PREFIX = RWTLaunch.class.getName();
    private static final String PORT = String.valueOf(PREFIX) + "#port";
    private final ILaunch launch;
    private final RWTLaunchConfig config;

    RWTLaunch(ILaunch launch) {
        this.launch = launch;
        this.config = new RWTLaunchConfig(launch.getLaunchConfiguration());
    }

    RWTLaunchConfig getLaunchConfig() {
        return this.config;
    }

    void setPort(int port) {
        this.launch.setAttribute(PORT, String.valueOf(port));
    }

    int getPort() {
        int result = -1;
        String attribute = this.launch.getAttribute(PORT);
        if (attribute != null) {
            result = Integer.valueOf(attribute);
        }
        return result;
    }

    void cleanUp() {
        IOUtil.delete(this.getBasePath());
    }

    File getJettyHomePath() {
        return this.getPath("jetty-home");
    }

    File getWebAppPath() {
        return this.getPath("web-app");
    }

    File getWebXmlPath() {
        return new File(this.getWebAppPath(), "WEB-INF/web.xml");
    }

    private File getPath(String suffix) {
        File basePath = this.getBasePath();
        return new File(basePath, suffix);
    }

    private File getBasePath() {
        IPath stateLocation = RWTLaunchActivator.getDefault().getStateLocation();
        IPath basePath = stateLocation.append(this.config.getName());
        return basePath.toFile();
    }
}

