/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.tab;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.rap.ui.internal.launch.tab.AbstractExtension;
import org.eclipse.rap.ui.internal.launch.tab.ExtensionUtil;

public final class ApplicationExtension
extends AbstractExtension {
    public static final String EXTENSION_ID = "org.eclipse.core.runtime.applications";
    private final String id;

    public static ApplicationExtension findById(String id) {
        ApplicationExtension result = null;
        if (id != null) {
            ApplicationExtension[] extensions = ApplicationExtension.findInWorkspace(null);
            int i = 0;
            while (result == null && i < extensions.length) {
                if (id.equals(extensions[i].getId())) {
                    result = extensions[i];
                }
                ++i;
            }
        }
        return result;
    }

    public static ApplicationExtension[] findInWorkspacePlugins(String[] pluginIds, IProgressMonitor monitor) {
        IPluginExtension[] extensions = ExtensionUtil.getWorkspacePluginExtensions(pluginIds, EXTENSION_ID, monitor);
        return ApplicationExtension.findInPluginExtensions(extensions);
    }

    public static ApplicationExtension[] findInActivePlugins(String[] pluginIds, IProgressMonitor monitor) {
        IPluginExtension[] extensions = ExtensionUtil.getActivePluginExtensions(pluginIds, EXTENSION_ID, monitor);
        return ApplicationExtension.findInPluginExtensions(extensions);
    }

    public static ApplicationExtension[] findInWorkspace(IProgressMonitor monitor) {
        IPluginExtension[] extensions = ExtensionUtil.getWorkspaceExtensions(EXTENSION_ID, monitor);
        return ApplicationExtension.findInPluginExtensions(extensions);
    }

    public static ApplicationExtension[] findAllActive(IProgressMonitor monitor) {
        IPluginExtension[] extensions = ExtensionUtil.getActiveExtensions(EXTENSION_ID, monitor);
        return ApplicationExtension.findInPluginExtensions(extensions);
    }

    private static ApplicationExtension[] findInPluginExtensions(IPluginExtension[] extensions) {
        ArrayList<ApplicationExtension> list = new ArrayList<ApplicationExtension>();
        int i = 0;
        while (i < extensions.length) {
            ApplicationExtension[] applications = ApplicationExtension.getApplicationExtensions(extensions[i]);
            list.addAll(Arrays.asList(applications));
            ++i;
        }
        ApplicationExtension[] result = new ApplicationExtension[list.size()];
        list.toArray(result);
        return result;
    }

    private static final ApplicationExtension[] getApplicationExtensions(IPluginExtension pluginExtension) {
        ApplicationExtension[] result = new ApplicationExtension[1];
        String id = pluginExtension.getId();
        String bundleId = pluginExtension.getPluginBase().getId();
        result[0] = new ApplicationExtension(bundleId, id);
        return result;
    }

    public ApplicationExtension(String project, String id) {
        super(project);
        this.id = id;
    }

    public final String getId() {
        return this.id;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        int valueHashCode = this.id == null ? 0 : this.id.hashCode();
        result = prime * result + valueHashCode;
        int projectHashCode = this.project == null ? 0 : this.project.hashCode();
        result = prime * result + projectHashCode;
        return result;
    }

    public final boolean equals(Object obj) {
        boolean result;
        if (this == obj) {
            result = true;
        } else if (obj == null) {
            result = false;
        } else if (this.getClass() != obj.getClass()) {
            result = false;
        } else {
            result = true;
            ApplicationExtension other = (ApplicationExtension)obj;
            if (this.id == null) {
                if (other.id != null) {
                    result = false;
                }
            } else if (!this.id.equals(other.id)) {
                result = false;
            }
            if (this.project == null) {
                if (other.project != null) {
                    result = false;
                }
            } else if (!this.project.equals(other.project)) {
                result = false;
            }
        }
        return result;
    }
}

