/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.data;

import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.composite.parser.IStatusContainer;
import org.w3c.dom.Node;

public class IncompatibleSiblingChecker {
    private IStatusContainer statusContainer;
    private Node parentNode;
    private String existingChild;
    private boolean errorReported = false;

    public IncompatibleSiblingChecker(IStatusContainer statusContainer, Node parentNode) {
        this.statusContainer = statusContainer;
        this.parentNode = parentNode;
    }

    public void checkElement(String elementKind) {
        if (this.isExecutable(elementKind)) {
            if (this.existingChild == null) {
                this.existingChild = elementKind;
            } else {
                this.reportIncompatible(elementKind);
            }
        } else if (this.isSubitem(elementKind) && this.isExecutable(this.existingChild)) {
            this.reportIncompatible(elementKind);
        }
    }

    private boolean isSubitem(String elementKind) {
        return "subitem".equals(elementKind) || "conditional-subitem".equals(elementKind) || "repeated-subitem".equals(elementKind);
    }

    private boolean isExecutable(String elementKind) {
        return "action".equals(elementKind) || "command".equals(elementKind) || "perform-when".equals(elementKind);
    }

    private void reportIncompatible(String elementKind) {
        if (this.errorReported) {
            return;
        }
        this.errorReported = true;
        String message = elementKind.equals(this.existingChild) ? NLS.bind((String)Messages.get().ERROR_PARSING_DUPLICATE_CHILD, (Object[])new Object[]{this.parentNode.getNodeName(), elementKind}) : NLS.bind((String)Messages.get().ERROR_PARSING_INCOMPATIBLE_CHILDREN, (Object[])new Object[]{this.parentNode.getNodeName(), this.existingChild, elementKind});
        this.statusContainer.addStatus(4, message, null);
    }
}

