/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid;

import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class GridEditor
extends ControlEditor {
    Grid table;
    GridItem item;
    int column = -1;
    ControlListener columnListener;
    Listener resizeListener;
    private Listener columnVisibleListener;
    private Listener columnGroupListener;
    private SelectionListener scrollListener;
    private TreeListener treeListener;

    public GridEditor(final Grid table) {
        super((Composite)table);
        this.table = table;
        this.treeListener = new TreeListener(table){
            final Runnable runnable;
            {
                this.runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (GridEditor.this.getEditor() == null || GridEditor.this.getEditor().isDisposed()) {
                            return;
                        }
                        if (grid.isDisposed()) {
                            return;
                        }
                        GridEditor.this.layout();
                        GridEditor.this.getEditor().setVisible(true);
                    }
                };
            }

            public void treeCollapsed(TreeEvent e) {
                if (GridEditor.this.getEditor() == null || GridEditor.this.getEditor().isDisposed()) {
                    return;
                }
                GridEditor.this.getEditor().setVisible(false);
                e.display.asyncExec(this.runnable);
            }

            public void treeExpanded(TreeEvent e) {
                if (GridEditor.this.getEditor() == null || GridEditor.this.getEditor().isDisposed()) {
                    return;
                }
                GridEditor.this.getEditor().setVisible(false);
                e.display.asyncExec(this.runnable);
            }
        };
        table.addTreeListener(this.treeListener);
        this.columnListener = new ControlListener(){

            public void controlMoved(ControlEvent e) {
                GridEditor.this.layout();
            }

            public void controlResized(ControlEvent e) {
                GridEditor.this.layout();
            }
        };
        this.columnVisibleListener = new Listener(){

            public void handleEvent(Event event) {
                GridEditor.this.getEditor().setVisible(((GridColumn)event.widget).isVisible());
                if (GridEditor.this.getEditor().isVisible()) {
                    GridEditor.this.layout();
                }
            }
        };
        this.resizeListener = new Listener(){

            public void handleEvent(Event event) {
                GridEditor.this.layout();
            }
        };
        this.scrollListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GridEditor.this.layout();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.columnGroupListener = new Listener(){

            public void handleEvent(Event event) {
                if (GridEditor.this.getEditor() == null || GridEditor.this.getEditor().isDisposed()) {
                    return;
                }
                GridEditor.this.getEditor().setVisible(table.getColumn(GridEditor.this.getColumn()).isVisible());
                if (GridEditor.this.getEditor().isVisible()) {
                    GridEditor.this.layout();
                }
            }
        };
        table.addListener(11, this.resizeListener);
        if (table.getVerticalScrollBarProxy() != null) {
            table.getVerticalScrollBarProxy().addSelectionListener(this.scrollListener);
        }
        if (table.getHorizontalScrollBarProxy() != null) {
            table.getHorizontalScrollBarProxy().addSelectionListener(this.scrollListener);
        }
        this.grabVertical = true;
    }

    protected Rectangle computeBounds() {
        if (this.item == null || this.column == -1 || this.item.isDisposed()) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle cell = this.item.getBounds(this.column);
        Rectangle area = this.table.getClientArea();
        if (cell.x < area.x + area.width && cell.x + cell.width > area.x + area.width) {
            cell.width = area.x + area.width - cell.x;
        }
        Rectangle editorRect = new Rectangle(cell.x, cell.y, this.minimumWidth, this.minimumHeight);
        if (this.grabHorizontal) {
            editorRect.width = Math.max(cell.width - 1, this.minimumWidth);
        }
        if (this.grabVertical) {
            editorRect.height = Math.max(cell.height, this.minimumHeight);
        }
        if (this.horizontalAlignment == 131072) {
            editorRect.x += cell.width - editorRect.width;
        } else if (this.horizontalAlignment != 16384) {
            editorRect.x += (cell.width - editorRect.width) / 2;
        }
        if (this.verticalAlignment == 1024) {
            editorRect.y += cell.height - editorRect.height;
        } else if (this.verticalAlignment != 128) {
            editorRect.y += (cell.height - editorRect.height) / 2;
        }
        GridColumn c = this.table.getColumn(this.column);
        if (c != null && c.isTree()) {
            int x = this.item.getTextOffset(this.column);
            editorRect.x += x;
            editorRect.width -= x;
        }
        return editorRect;
    }

    public void dispose() {
        if (!this.table.isDisposed() && this.column > -1 && this.column < this.table.getColumnCount()) {
            GridColumn tableColumn = this.table.getColumn(this.column);
            tableColumn.removeControlListener(this.columnListener);
            if (tableColumn.getColumnGroup() != null) {
                tableColumn.getColumnGroup().removeListener(17, this.columnGroupListener);
                tableColumn.getColumnGroup().removeListener(18, this.columnGroupListener);
            }
        }
        if (!this.table.isDisposed()) {
            this.table.removeListener(11, this.resizeListener);
            if (this.table.getVerticalScrollBarProxy() != null) {
                this.table.getVerticalScrollBarProxy().removeSelectionListener(this.scrollListener);
            }
            if (this.table.getHorizontalScrollBarProxy() != null) {
                this.table.getHorizontalScrollBarProxy().removeSelectionListener(this.scrollListener);
            }
        }
        this.columnListener = null;
        this.resizeListener = null;
        this.table = null;
        this.item = null;
        this.column = -1;
        super.dispose();
    }

    public int getColumn() {
        return this.column;
    }

    public GridItem getItem() {
        return this.item;
    }

    public void setColumn(int column) {
        GridColumn tableColumn;
        int columnCount = this.table.getColumnCount();
        if (columnCount == 0) {
            this.column = column == 0 ? 0 : -1;
            this.layout();
            return;
        }
        if (this.column > -1 && this.column < columnCount) {
            tableColumn = this.table.getColumn(this.column);
            tableColumn.removeControlListener(this.columnListener);
            tableColumn.removeListener(22, this.columnVisibleListener);
            tableColumn.removeListener(23, this.columnVisibleListener);
            this.column = -1;
        }
        if (column < 0 || column >= this.table.getColumnCount()) {
            return;
        }
        this.column = column;
        tableColumn = this.table.getColumn(this.column);
        tableColumn.addControlListener(this.columnListener);
        tableColumn.addListener(22, this.columnVisibleListener);
        tableColumn.addListener(23, this.columnVisibleListener);
        if (tableColumn.getColumnGroup() != null) {
            tableColumn.getColumnGroup().addListener(17, this.columnGroupListener);
            tableColumn.getColumnGroup().addListener(18, this.columnGroupListener);
        }
        this.layout();
    }

    public void setItem(GridItem item) {
        this.item = item;
        this.layout();
    }

    public void setEditor(Control editor, GridItem item, int column) {
        this.setItem(item);
        this.setColumn(column);
        this.setEditor(editor);
        this.layout();
    }

    public void layout() {
        if (this.table.isDisposed()) {
            return;
        }
        if (this.item == null || this.item.isDisposed()) {
            return;
        }
        int columnCount = this.table.getColumnCount();
        if (columnCount == 0 && this.column != 0) {
            return;
        }
        if (columnCount > 0 && (this.column < 0 || this.column >= columnCount)) {
            return;
        }
        boolean hadFocus = false;
        if (this.getEditor() == null || this.getEditor().isDisposed()) {
            return;
        }
        if (this.getEditor().getVisible()) {
            hadFocus = this.getEditor().isFocusControl();
        }
        this.getEditor().setBounds(this.computeBounds());
        if (hadFocus) {
            if (this.getEditor() == null || this.getEditor().isDisposed()) {
                return;
            }
            this.getEditor().setFocus();
        }
    }
}

