/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.registration;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.context.ServiceHolder;
import org.eclipse.equinox.http.servlet.internal.multipart.MultipartSupport;
import org.eclipse.equinox.http.servlet.internal.multipart.MultipartSupportFactory;
import org.eclipse.equinox.http.servlet.internal.registration.EndpointRegistration;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.service.http.runtime.dto.ServletDTO;

public class ServletRegistration
extends EndpointRegistration<ServletDTO> {
    private static MultipartSupportFactory factory;
    private final MultipartSupport multipartSupport;

    static {
        ServiceLoader<MultipartSupportFactory> loader = ServiceLoader.load(MultipartSupportFactory.class);
        Iterator<MultipartSupportFactory> iterator = loader.iterator();
        while (iterator.hasNext()) {
            try {
                factory = iterator.next();
                break;
            }
            catch (Throwable throwable) {}
        }
    }

    public ServletRegistration(ServiceHolder<Servlet> servletHolder, ServletDTO servletDTO, ServletContextHelper servletContextHelper, ContextController contextController, ServletContext servletContext) {
        super(servletHolder, servletDTO, servletContextHelper, contextController);
        if (servletDTO.multipartEnabled) {
            if (factory == null) {
                throw new IllegalStateException("Multipart support not enabled due to missing, optional commons-fileupload dependency!");
            }
            this.multipartSupport = factory.newInstance(servletDTO, servletContext);
        } else {
            this.multipartSupport = null;
        }
    }

    @Override
    public String getName() {
        return ((ServletDTO)this.getD()).name;
    }

    @Override
    public String[] getPatterns() {
        return ((ServletDTO)this.getD()).patterns;
    }

    @Override
    public long getServiceId() {
        return ((ServletDTO)this.getD()).serviceId;
    }

    @Override
    public ServiceReference<?> getServiceReference() {
        return this.servletHolder.getServiceReference();
    }

    public List<Part> parseRequest(HttpServletRequest request) throws IOException, ServletException {
        if (this.multipartSupport == null) {
            throw new IOException("Servlet not configured for multipart!");
        }
        return this.multipartSupport.parseRequest(request);
    }
}

