/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.jetty.internal;

import java.io.File;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.equinox.http.jetty.internal.Details;
import org.eclipse.equinox.http.jetty.internal.EquinoxStdErrLog;
import org.eclipse.equinox.http.jetty.internal.HttpServerManager;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.service.cm.ManagedServiceFactory;

public class Activator
implements BundleActivator {
    private static final String JETTY_WORK_DIR = "jettywork";
    private static final String DEFAULT_PID = "default";
    private static final String MANAGED_SERVICE_FACTORY_PID = "org.eclipse.equinox.http.jetty.config";
    private static final String ORG_OSGI_SERVICE_HTTP_PORT = "org.osgi.service.http.port";
    private static final String ORG_OSGI_SERVICE_HTTP_PORT_SECURE = "org.osgi.service.http.port.secure";
    private static final String AUTOSTART = "org.eclipse.equinox.http.jetty.autostart";
    private static final String LOG_STDERR_THRESHOLD = "org.eclipse.equinox.http.jetty.log.stderr.threshold";
    private static HttpServerManager staticServerManager;
    private HttpServerManager httpServerManager;
    private ServiceRegistration<ManagedServiceFactory> registration;

    public void start(BundleContext context) throws Exception {
        File jettyWorkDir = new File(context.getDataFile(""), JETTY_WORK_DIR);
        jettyWorkDir.mkdir();
        EquinoxStdErrLog.setThresholdLogger(context.getProperty(LOG_STDERR_THRESHOLD));
        this.httpServerManager = new HttpServerManager(jettyWorkDir);
        boolean autostart = Details.getBoolean(context, AUTOSTART, false);
        if (autostart || !this.isBundleLazyActivationPolicyUsed(context)) {
            Dictionary<String, Object> defaultSettings = this.createDefaultSettings(context);
            this.httpServerManager.updated(DEFAULT_PID, defaultSettings);
        }
        Hashtable<String, String> dictionary = new Hashtable<String, String>();
        ((Dictionary)dictionary).put("service.pid", MANAGED_SERVICE_FACTORY_PID);
        this.registration = context.registerService(ManagedServiceFactory.class, (Object)this.httpServerManager, dictionary);
        Activator.setStaticServerManager(this.httpServerManager);
    }

    private boolean isBundleLazyActivationPolicyUsed(BundleContext context) {
        if (((BundleStartLevel)context.getBundle().adapt(BundleStartLevel.class)).isActivationPolicyUsed()) {
            List moduleData = ((BundleRevision)context.getBundle().adapt(BundleRevision.class)).getDeclaredCapabilities("equinox.module.data");
            String activationPolicy = null;
            activationPolicy = moduleData.isEmpty() ? (String)context.getBundle().getHeaders("").get("Bundle-ActivationPolicy") : (String)((BundleCapability)moduleData.get(0)).getAttributes().get("activation.policy");
            return activationPolicy == null ? false : activationPolicy.startsWith("lazy");
        }
        return false;
    }

    public void stop(BundleContext context) throws Exception {
        Activator.setStaticServerManager(null);
        this.registration.unregister();
        this.registration = null;
        this.httpServerManager.shutdown();
        this.httpServerManager = null;
    }

    private Dictionary<String, Object> createDefaultSettings(BundleContext context) {
        String customizerClass;
        String otherInfo;
        String houseKeeperInterval;
        String sessionInactiveInterval;
        String contextpath;
        int maxThreads;
        Hashtable<String, Object> defaultSettings = new Hashtable<String, Object>();
        ((Dictionary)defaultSettings).put("service.pid", DEFAULT_PID);
        Boolean httpEnabled = Details.getBooleanProp(context, "http.enabled", true);
        ((Dictionary)defaultSettings).put("http.enabled", httpEnabled);
        int httpPort = Details.getIntProp(context, "http.port", -1);
        if (httpPort == -1) {
            httpPort = Details.getInt(context, ORG_OSGI_SERVICE_HTTP_PORT, 0);
        }
        ((Dictionary)defaultSettings).put("http.port", httpPort);
        String httpHost = Details.getStringProp(context, "http.host", null);
        if (httpHost != null) {
            ((Dictionary)defaultSettings).put("http.host", httpHost);
        }
        Boolean httpsEnabled = Details.getBooleanProp(context, "https.enabled", false);
        ((Dictionary)defaultSettings).put("https.enabled", httpsEnabled);
        int minThreads = Details.getIntProp(context, "http.minThreads", 8);
        if (minThreads != -1) {
            ((Dictionary)defaultSettings).put("http.minThreads", minThreads);
        }
        if ((maxThreads = Details.getIntProp(context, "http.maxThreads", 200)) != -1) {
            ((Dictionary)defaultSettings).put("http.maxThreads", maxThreads);
        }
        if (httpsEnabled.booleanValue()) {
            String keystoretype;
            String algorithm;
            String protocol;
            String wantclientauth;
            String needclientauth;
            String keypassword;
            String password;
            String keystore;
            int httpsPort = Details.getIntProp(context, "https.port", -1);
            if (httpsPort == -1) {
                httpsPort = Details.getInt(context, ORG_OSGI_SERVICE_HTTP_PORT_SECURE, 443);
            }
            ((Dictionary)defaultSettings).put("https.port", httpsPort);
            String httpsHost = Details.getStringProp(context, "https.host", null);
            if (httpsHost != null) {
                ((Dictionary)defaultSettings).put("https.host", httpsHost);
            }
            if ((keystore = Details.getStringProp(context, "ssl.keystore", null)) != null) {
                ((Dictionary)defaultSettings).put("ssl.keystore", keystore);
            }
            if ((password = Details.getStringProp(context, "ssl.password", null)) != null) {
                ((Dictionary)defaultSettings).put("ssl.password", password);
            }
            if ((keypassword = Details.getStringProp(context, "ssl.keypassword", null)) != null) {
                ((Dictionary)defaultSettings).put("ssl.keypassword", keypassword);
            }
            if ((needclientauth = Details.getStringProp(context, "ssl.needclientauth", null)) != null) {
                ((Dictionary)defaultSettings).put("ssl.needclientauth", Boolean.valueOf(needclientauth));
            }
            if ((wantclientauth = Details.getStringProp(context, "ssl.wantclientauth", null)) != null) {
                ((Dictionary)defaultSettings).put("ssl.wantclientauth", Boolean.valueOf(wantclientauth));
            }
            if ((protocol = Details.getStringProp(context, "ssl.protocol", null)) != null) {
                ((Dictionary)defaultSettings).put("ssl.protocol", protocol);
            }
            if ((algorithm = Details.getStringProp(context, "ssl.algorithm", null)) != null) {
                ((Dictionary)defaultSettings).put("ssl.algorithm", algorithm);
            }
            if ((keystoretype = Details.getStringProp(context, "ssl.keystoretype", null)) != null) {
                ((Dictionary)defaultSettings).put("ssl.keystoretype", keystoretype);
            }
        }
        if ((contextpath = Details.getStringProp(context, "context.path", null)) != null) {
            ((Dictionary)defaultSettings).put("context.path", contextpath);
        }
        if ((sessionInactiveInterval = Details.getStringProp(context, "context.sessioninactiveinterval", null)) != null) {
            try {
                ((Dictionary)defaultSettings).put("context.sessioninactiveinterval", Integer.valueOf(sessionInactiveInterval));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((houseKeeperInterval = Details.getStringProp(context, "housekeeper.interval", null)) != null) {
            try {
                ((Dictionary)defaultSettings).put("housekeeper.interval", Long.valueOf(houseKeeperInterval));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((otherInfo = Details.getStringProp(context, "other.info", null)) != null) {
            ((Dictionary)defaultSettings).put("other.info", otherInfo);
        }
        if ((customizerClass = Details.getStringProp(context, "customizer.class", null)) != null) {
            ((Dictionary)defaultSettings).put("customizer.class", customizerClass);
        }
        return defaultSettings;
    }

    public static synchronized void startServer(String pid, Dictionary<String, ?> settings) throws Exception {
        if (staticServerManager == null) {
            throw new IllegalStateException("Inactive");
        }
        staticServerManager.updated(pid, settings);
    }

    public static synchronized void stopServer(String pid) throws Exception {
        if (staticServerManager != null) {
            staticServerManager.deleted(pid);
        }
    }

    private static synchronized void setStaticServerManager(HttpServerManager httpServerManager) {
        staticServerManager = httpServerManager;
    }
}

