/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.menuitemkit;

import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.protocol.WidgetOperationHandler;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MenuItem;

public class MenuItemOperationHandler
extends WidgetOperationHandler<MenuItem> {
    private static final String PROP_SELECTION = "selection";

    public MenuItemOperationHandler(MenuItem item) {
        super(item);
    }

    @Override
    public void handleSet(MenuItem item, JsonObject properties) {
        this.handleSetSelection(item, properties);
    }

    @Override
    public void handleNotify(MenuItem item, String eventName, JsonObject properties) {
        if ("Selection".equals(eventName)) {
            this.handleNotifySelection(item, properties);
        } else if ("Help".equals(eventName)) {
            this.handleNotifyHelp(item);
        } else {
            super.handleNotify(item, eventName, properties);
        }
    }

    public void handleSetSelection(MenuItem item, JsonObject properties) {
        JsonValue selection = properties.get(PROP_SELECTION);
        if (selection != null) {
            item.setSelection(selection.asBoolean());
        }
    }

    public void handleNotifySelection(MenuItem item, JsonObject properties) {
        Event event = MenuItemOperationHandler.createSelectionEvent(13, properties);
        if ((item.getStyle() & 0x10) != 0 && !item.getSelection()) {
            event.time = -1;
        }
        item.notifyListeners(13, event);
    }

    public void handleNotifyHelp(MenuItem item) {
        item.notifyListeners(28, new Event());
    }
}

