/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.textsize;

import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.internal.SerializableCompatibility;

class MeasurementItem
implements SerializableCompatibility {
    private final int wrapWidth;
    private final FontData fontData;
    private final String string;
    private final int mode;

    MeasurementItem(String textToMeasure, FontData fontData, int wrapWidth, int mode) {
        ParamCheck.notNull(textToMeasure, "textToMeasure");
        ParamCheck.notNull(fontData, "fontData");
        this.wrapWidth = wrapWidth;
        this.fontData = fontData;
        this.string = textToMeasure;
        this.mode = mode;
    }

    FontData getFontData() {
        return this.fontData;
    }

    String getTextToMeasure() {
        return this.string;
    }

    int getWrapWidth() {
        return this.wrapWidth;
    }

    int getMode() {
        return this.mode;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.fontData.hashCode();
        result = 31 * result + this.string.hashCode();
        result = 31 * result + this.wrapWidth;
        result = 31 * result + this.mode;
        return result;
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object != null && this.getClass() == object.getClass()) {
            if (this == object) {
                result = true;
            } else {
                MeasurementItem other = (MeasurementItem)object;
                result = this.fontData.equals(other.fontData) && this.string.equals(other.string) && this.wrapWidth == other.wrapWidth && this.mode == other.mode;
            }
        }
        return result;
    }
}

