/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.rap.demo.controls.HtmlDialog;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ListTab
extends ExampleTab {
    private static final List<String> ELEMENTS = new ArrayList<String>();
    private org.eclipse.swt.widgets.List list;
    private org.eclipse.swt.widgets.List list2;
    private ListViewer listViewer;
    private boolean markup;

    static {
        String text = "A very long item that demonstrates horizontal scrolling in a List";
        ELEMENTS.add(text);
        text = "An item with a linebreak\n(converted to a whitespace)";
        ELEMENTS.add(text);
        text = "...and other control chars: \u0003 \t \u0004 \u000f";
        ELEMENTS.add(text);
        int i = 1;
        while (i <= 25) {
            ELEMENTS.add("Item " + i);
            ++i;
        }
    }

    public ListTab() {
        super("List");
    }

    @Override
    protected void createStyleControls(Composite parent) {
        this.createStyleButton("BORDER", 2048);
        this.createStyleButton("SINGLE", 4);
        this.createStyleButton("MULTI", 2);
        this.createStyleButton("H_SCROLL", 256);
        this.createStyleButton("V_SCROLL", 512);
        this.createOrientationButton();
        this.createVisibilityButton();
        this.createEnablementButton();
        this.createMarkupButton();
        this.createFgColorButton();
        this.createBgColorButton();
        this.createBgImageButton();
        this.createFontChooser();
        this.createCursorCombo();
        this.createSelectionButton();
        Group group = new Group(parent, 0);
        group.setText("Manipulate Right List");
        group.setLayout((Layout)new GridLayout());
        this.createAddItemsControls((Composite)group);
        this.createSetTopIndexControls((Composite)group);
        this.createGetTopIndexControls((Composite)group);
        this.createShowSelectionControls((Composite)group);
        this.createRemoveFirstItemButton((Composite)group);
        this.createSelectAllButton((Composite)group);
        this.createDeselectAllButton((Composite)group);
        this.createSelectButton((Composite)group);
        this.createDeselectButton((Composite)group);
        this.createSetSelectionButton((Composite)group);
    }

    @Override
    protected void createExampleControls(final Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, true));
        int style = this.getStyle();
        this.list = new org.eclipse.swt.widgets.List(parent, style);
        this.list.setLayoutData((Object)new GridData(1808));
        Menu menu = new Menu((Control)this.list);
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText("Context menu item");
        this.list.setMenu(menu);
        this.listViewer = new ListViewer(this.list);
        this.listViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.listViewer.setInput(ELEMENTS);
        this.list.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                String item = ListTab.this.list.getItem(ListTab.this.list.getSelectionIndex());
                String message = "Selected Item: " + item;
                MessageDialog.openInformation((Shell)ListTab.this.getShell(), (String)"Selection", (String)message);
            }
        });
        this.registerControl((Control)this.list);
        this.list2 = new org.eclipse.swt.widgets.List(parent, style);
        this.list2.setData("org.eclipse.rap.rwt.markupEnabled", (Object)new Boolean(this.markup));
        this.list2.add("Item 0");
        this.list2.add("Item 1");
        this.list2.add("Item 2");
        if (this.markup) {
            this.list2.setData("org.eclipse.rap.rwt.customItemHeight", (Object)new Integer(60));
            this.list2.add("<b>Some Markup Text</b><br/><i>This is italic</i>");
            this.list2.add("A real <a href='http://eclipse.org/rap'>link</a>");
            this.list2.add("This one opens <a href='http://eclipse.org/rap' target='_blank'>a new tab</a>");
            this.list2.add("This is a special <a href='value_of_href' target='_rwt'>RWT Hyperlink</a>");
            this.list2.add("This RWT Hyperlik <a href='http://eclipse.org/rap' target='_rwt'>has an <i>URL</i></a>");
            this.list2.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (event.detail == 0x4000000) {
                        ListTab.this.log("Clicked link \"" + event.text + "\"");
                    }
                }
            });
        } else {
            this.createPopupMenu(parent.getShell(), this.list2);
        }
        this.list2.setLayoutData((Object)new GridData(1808));
        this.registerControl((Control)this.list2);
        int separatorStyle = 266;
        Label separator = new Label(parent, separatorStyle);
        separator.setLayoutData((Object)this.createGridDataWithSpan());
        Label codeLabel = new Label(parent, 64);
        String codeLabelText = "Please note that the content of the left List is provided by a ListViewer with JFace API.";
        codeLabel.setText(codeLabelText);
        codeLabel.setLayoutData((Object)this.createGridDataWithSpan());
        Link link = new Link(parent, 0);
        link.setText("See <a>example code</a>");
        link.setLayoutData((Object)this.createGridDataWithSpan());
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private final String code;
            {
                this.code = ListTab.this.getExampleCode();
            }

            public void widgetSelected(SelectionEvent event) {
                String title = "ListViewer Example Code";
                HtmlDialog dialog = new HtmlDialog(parent.getShell(), title, this.code);
                dialog.setSize(550, 400);
                dialog.open();
            }
        });
    }

    private GridData createGridDataWithSpan() {
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        return gridData;
    }

    private void createPopupMenu(Shell parent, final org.eclipse.swt.widgets.List list) {
        final Menu menu = new Menu((Decorations)parent, 8);
        String[] listItems = list.getItems();
        int i = 0;
        while (i < listItems.length) {
            MenuItem item = new MenuItem(menu, 8);
            item.setText(listItems[i]);
            ++i;
        }
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                MenuItem[] items = menu.getItems();
                int i = 0;
                while (i < items.length) {
                    MenuItem item = items[i];
                    item.setEnabled(list.isSelected(i));
                    ++i;
                }
            }
        });
        list.setMenu(menu);
    }

    private void createSelectionButton() {
        Button button = new Button(this.styleComp, 8);
        button.setText("Select first");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ListTab.this.listViewer.setSelection((ISelection)new StructuredSelection(ELEMENTS.get(0)));
            }
        });
    }

    protected Button createMarkupButton() {
        final Button button = new Button(this.styleComp, 32);
        button.setText("Markup");
        button.setSelection(this.markup);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ListTab.this.markup = button.getSelection();
                ListTab.this.createNew();
            }
        });
        return button;
    }

    private void createAddItemsControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label lblAddItem = new Label(composite, 0);
        lblAddItem.setText("Add");
        final Text txtAddItem = new Text(composite, 2048);
        txtAddItem.setLayoutData((Object)new GridData(50, -1));
        Button btnAddItem = new Button(composite, 8);
        btnAddItem.setText("Item(s)");
        btnAddItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int count = -1;
                String[] listItems = ListTab.this.list2.getItems();
                int existingItems = listItems.length;
                try {
                    count = Integer.parseInt(txtAddItem.getText());
                }
                catch (NumberFormatException numberFormatException) {}
                if (count < 0) {
                    String msg = "Invalid number of ListItems: " + txtAddItem.getText();
                    MessageDialog.openInformation((Shell)ListTab.this.getShell(), (String)"Information", (String)msg);
                } else {
                    int i = 0;
                    while (i < count) {
                        ListTab.this.list2.add("Item " + (existingItems + i));
                        ++i;
                    }
                }
            }
        });
    }

    private void createSetTopIndexControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        final Text txtTopIndex = new Text(composite, 2048);
        txtTopIndex.setLayoutData((Object)new GridData(50, -1));
        Button button = new Button(composite, 8);
        button.setText("setTopIndex");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    int topIndex = Integer.parseInt(txtTopIndex.getText());
                    ListTab.this.list2.setTopIndex(topIndex);
                }
                catch (NumberFormatException numberFormatException) {
                    String msg = "Invalid number of topIndex: " + txtTopIndex.getText();
                    MessageDialog.openInformation((Shell)ListTab.this.getShell(), (String)"Information", (String)msg);
                }
            }
        });
    }

    private void createGetTopIndexControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        final Text txtTopIndex = new Text(composite, 2048);
        txtTopIndex.setLayoutData((Object)new GridData(50, -1));
        txtTopIndex.setEditable(false);
        Button button = new Button(composite, 8);
        button.setText("getTopIndex");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int topIndex = ListTab.this.list2.getTopIndex();
                txtTopIndex.setText(String.valueOf(topIndex));
            }
        });
    }

    private void createShowSelectionControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Button button = new Button(composite, 8);
        button.setText("showSelection");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ListTab.this.list2.showSelection();
            }
        });
    }

    private void createRemoveFirstItemButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Remove First Item");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (ListTab.this.list2.getItemCount() > 0) {
                    ListTab.this.list2.remove(0);
                }
            }
        });
    }

    private void createSelectAllButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Select All");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ListTab.this.list2.selectAll();
            }
        });
    }

    private void createDeselectAllButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Deselect All");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ListTab.this.list2.deselectAll();
            }
        });
    }

    private void createSelectButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Select 100th item");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (ListTab.this.list2.getItemCount() > 100) {
                    ListTab.this.list2.select(100);
                }
            }
        });
    }

    private void createDeselectButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Deselect second item");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (ListTab.this.list2.getItemCount() > 1) {
                    ListTab.this.list2.deselect(1);
                }
            }
        });
    }

    private void createSetSelectionButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Set selection to first item");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (ListTab.this.list2.getItemCount() > 0) {
                    ListTab.this.list2.setSelection(new int[1]);
                }
            }
        });
    }

    private String getExampleCode() {
        String result = "<html><head></head></body><pre>class ListContentProvider implements IStructuredContentProvider {\n  public Object[] getElements( final Object inputElement ) {\n    return ( ( java.util.List )inputElement ).toArray();\n  }\n}\n...\njava.util.List elements = ...\n...\nListViewer viewer = new ListViewer( parent );\nviewer.setContentProvider( new ListContentProvider() );\nviewer.setLabelProvider( new LabelProvider() );\njava.util.List input = new ArrayList();\n... // populate list\nviewer.setInput( input );\n</pre></body>";
        return result;
    }
}

