/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.rap.rwt.internal.theme.Size;
import org.eclipse.rap.rwt.internal.theme.ThemeAdapter;
import org.eclipse.rap.rwt.theme.BoxDimensions;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.IToolItemAdapter;
import org.eclipse.swt.internal.widgets.MarkupUtil;
import org.eclipse.swt.internal.widgets.MarkupValidator;
import org.eclipse.swt.internal.widgets.toolbarkit.ToolBarThemeAdapter;
import org.eclipse.swt.internal.widgets.toolitemkit.ToolItemLCA;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TypedListener;

public class ToolItem
extends Item {
    private static final int DEFAULT_WIDTH = 24;
    private static final int DEFAULT_HEIGHT = 22;
    private final ToolBar parent;
    private boolean selected;
    private Control control;
    private int width;
    private boolean computedWidth;
    private String toolTipText;
    private boolean visible;
    private Image disabledImage;
    private Image hotImage;
    private transient IToolItemAdapter toolItemAdapter;

    public ToolItem(ToolBar parent, int style) {
        this(ToolItem.checkNull(parent), ToolItem.checkStyle(style), parent.getItemCount());
    }

    public ToolItem(ToolBar parent, int style, int index) {
        super(parent, ToolItem.checkStyle(style));
        this.parent = parent;
        this.visible = true;
        this.computedWidth = true;
        parent.createItem(this, index);
        this.computeInitialWidth();
    }

    public ToolBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    @Override
    public void setText(String text) {
        this.checkWidget();
        if (text == null) {
            SWT.error(4);
        }
        if ((this.style & 2) == 0) {
            super.setText(text);
            this.parent.layoutItems();
        }
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            super.setImage(image);
            this.parent.layoutItems();
        }
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            this.disabledImage = image;
            this.parent.layoutItems();
        }
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    public void setHotImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            this.hotImage = image;
            this.parent.layoutItems();
        }
    }

    public Image getHotImage() {
        this.checkWidget();
        return this.hotImage;
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                SWT.error(5);
            }
            if (control.getParent() != this.parent) {
                SWT.error(32);
            }
        }
        if ((this.style & 2) != 0) {
            if (this.control != null && !this.control.isDisposed()) {
                this.control.setVisible(false);
            }
            this.control = control;
            if (this.control != null) {
                this.control.setVisible(true);
            }
            this.resizeControl();
        }
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public void setToolTipText(String toolTipText) {
        this.checkWidget();
        if (toolTipText != null && MarkupUtil.isToolTipMarkupEnabledFor(this) && !MarkupValidator.isValidationDisabledFor(this)) {
            MarkupValidator.getInstance().validate(toolTipText);
        }
        this.toolTipText = toolTipText;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    @Override
    public void setData(String key, Object value) {
        if ("org.eclipse.rap.rwt.badge".equals(key) && (this.style & 8) == 0) {
            return;
        }
        if ("org.eclipse.rap.rwt.tooltipMarkupEnabled".equals(key) && MarkupUtil.isToolTipMarkupEnabledFor(this)) {
            return;
        }
        MarkupUtil.checkMarkupPrecondition(key, MarkupUtil.MarkupTarget.TOOLTIP, () -> this.toolTipText == null);
        super.setData(key, value);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if (enabled) {
            this.removeState(8);
        } else {
            this.addState(8);
        }
    }

    public boolean getEnabled() {
        this.checkWidget();
        return !this.hasState(8);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    public Rectangle getBounds() {
        this.checkWidget();
        Rectangle clientArea = this.parent.getClientArea();
        int left = clientArea.x;
        int top = clientArea.y;
        int width = this.getWidth();
        int height = this.getHeight();
        int index = this.parent.indexOf(this);
        BoxDimensions toolBarPadding = this.parent.getToolBarPadding();
        if ((this.parent.style & 0x200) != 0) {
            if (index > 0) {
                Rectangle upperSiblingBounds = this.parent.getItem(index - 1).getBounds();
                top += upperSiblingBounds.y + upperSiblingBounds.height;
                top += this.getToolBarSpacing();
            } else {
                top += toolBarPadding.top;
            }
            int innerParentWidth = this.parent.getSize().x - toolBarPadding.left - toolBarPadding.right;
            left += toolBarPadding.left + innerParentWidth / 2 - width / 2;
            left = Math.max(left, 0);
        } else {
            if (index > 0) {
                Rectangle leftSiblingBounds = this.parent.getItem(index - 1).getBounds();
                left += leftSiblingBounds.x + leftSiblingBounds.width;
                left += this.getToolBarSpacing();
            } else {
                left += toolBarPadding.left;
            }
            BoxDimensions border = this.parent.getBorder();
            int innerParentHeight = this.parent.getSize().y - (toolBarPadding.top + toolBarPadding.bottom) - (border.top + border.bottom);
            top += toolBarPadding.top + innerParentHeight / 2 - height / 2;
            top = Math.max(top, 0);
        }
        return new Rectangle(left, top, width, height);
    }

    private int getHeight() {
        int height;
        if ((this.parent.style & 0x200) != 0 && (this.style & 2) != 0 && this.getControl() == null) {
            height = this.getSeparatorWidth();
        } else {
            height = 0;
            ToolItem[] siblings = this.getParent().getItems();
            int i = 0;
            while (i < siblings.length) {
                height = Math.max(height, siblings[i].getPreferredHeight());
                ++i;
            }
        }
        return height;
    }

    public int getWidth() {
        int result;
        boolean isVertical;
        this.checkWidget();
        boolean bl = isVertical = (this.parent.style & 0x200) != 0;
        if (!((this.style & 2) == 0 || isVertical && this.computedWidth)) {
            result = this.width;
        } else if (isVertical) {
            result = 0;
            ToolItem[] siblings = this.getParent().getItems();
            int i = 0;
            while (i < siblings.length) {
                if ((siblings[i].style & 2) == 0) {
                    result = Math.max(result, siblings[i].getPreferredWidth());
                }
                ++i;
            }
        } else {
            result = this.getPreferredWidth();
        }
        return result;
    }

    int getPreferredHeight() {
        int result = 0;
        if ((this.style & 2) == 0) {
            boolean hasText;
            boolean styleRight = (this.parent.style & 0x20000) != 0;
            boolean hasImage = this.image != null;
            boolean bl = hasText = !"".equals(this.text);
            if (hasImage) {
                result += this.image.getBounds().height;
            }
            if (hasText) {
                int charHeight = TextSizeUtil.getCharHeight(this.parent.getFont());
                int n = result = styleRight ? Math.max(result, charHeight) : result + charHeight;
            }
            if (!styleRight && hasText && hasImage) {
                result += this.getSpacing();
            }
            result += this.getFrameHeight();
        }
        return Math.max(result, 22);
    }

    int getPreferredWidth() {
        boolean hasText;
        int result = 0;
        boolean styleRight = (this.parent.style & 0x20000) != 0;
        boolean hasImage = this.image != null;
        boolean bl = hasText = !"".equals(this.text);
        if (hasImage) {
            result += this.image.getBounds().width;
        }
        if (hasText) {
            int textWidth = TextSizeUtil.stringExtent((Font)this.parent.getFont(), (String)this.text).x;
            int n = result = styleRight ? result + textWidth : Math.max(result, textWidth);
        }
        if (styleRight && hasText && hasImage) {
            result += this.getSpacing();
        }
        if ((this.style & 4) != 0) {
            result += this.getSpacing() * 2;
            ++result;
            result += this.getDropDownImageSize().width;
        }
        return result += this.getFrameWidth();
    }

    private int getFrameWidth() {
        BoxDimensions border = this.getBorder();
        BoxDimensions padding = this.getPadding();
        return padding.left + padding.right + border.left + border.right;
    }

    private int getFrameHeight() {
        BoxDimensions border = this.getBorder();
        BoxDimensions padding = this.getPadding();
        return padding.top + padding.bottom + border.top + border.bottom;
    }

    private BoxDimensions getBorder() {
        return this.getToolBarThemeAdapter().getItemBorder(this);
    }

    private Size getDropDownImageSize() {
        return this.getToolBarThemeAdapter().getDropDownImageSize(this.parent);
    }

    private BoxDimensions getPadding() {
        return this.getToolBarThemeAdapter().getItemPadding(this);
    }

    private int getToolBarSpacing() {
        return this.getToolBarThemeAdapter().getToolBarSpacing(this.parent);
    }

    private int getSpacing() {
        return this.getToolBarThemeAdapter().getItemSpacing(this);
    }

    int getSeparatorWidth() {
        return this.getToolBarThemeAdapter().getSeparatorWidth(this.parent);
    }

    private ToolBarThemeAdapter getToolBarThemeAdapter() {
        return (ToolBarThemeAdapter)this.parent.getAdapter(ThemeAdapter.class);
    }

    public void setWidth(int width) {
        this.checkWidget();
        if ((this.style & 2) != 0 && width >= 0) {
            this.computedWidth = false;
            this.width = width;
            this.parent.layoutItems();
        }
    }

    public boolean getSelection() {
        this.checkWidget();
        boolean result = this.selected;
        if ((this.style & 0x30) == 0) {
            result = false;
        }
        return result;
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x30) != 0) {
            this.selected = selected;
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        this.parent.destroyItem(this);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IToolItemAdapter.class) {
            if (this.toolItemAdapter == null) {
                this.toolItemAdapter = new IToolItemAdapter(){

                    @Override
                    public boolean getVisible() {
                        return ToolItem.this.visible;
                    }
                };
            }
            return (T)this.toolItemAdapter;
        }
        if (adapter == WidgetLCA.class) {
            return (T)ToolItemLCA.INSTANCE;
        }
        return super.getAdapter(adapter);
    }

    void resizeControl() {
        if (this.control != null && !this.control.isDisposed()) {
            this.control.setBounds(this.getBounds());
        }
    }

    private void computeInitialWidth() {
        if ((this.style & 2) != 0) {
            this.width = this.getSeparatorWidth();
        } else {
            this.width = 24;
            if ((this.style & 4) != 0) {
                this.width += this.getDropDownImageSize().width;
            }
        }
    }

    private static ToolBar checkNull(ToolBar parent) {
        if (parent == null) {
            SWT.error(4);
        }
        return parent;
    }

    private static int checkStyle(int style) {
        return ToolItem.checkBits(style, 8, 32, 16, 2, 4, 0);
    }

    void setVisible(boolean visible) {
        this.visible = visible;
    }
}

