/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.Resource;

public class Path
extends Resource {
    private PointF currentPoint = new PointF();
    private PointF startPoint = new PointF();
    private byte[] types = new byte[0];
    private float[] points = new float[0];

    public Path(Device device) {
        super(device);
        this.moveTo(0.0f, 0.0f);
    }

    public Path(Device device, PathData data) {
        this(device);
        if (data == null) {
            SWT.error(4);
        }
        this.appendData(data);
    }

    public void addPath(Path path) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.isDisposed()) {
            SWT.error(5);
        }
        this.appendData(path.getPathData());
        if (this.currentPoint.x != path.currentPoint.x || this.currentPoint.y != path.currentPoint.y) {
            this.moveTo(path.currentPoint.x, path.currentPoint.y);
        }
    }

    public void addRectangle(float x, float y, float width, float height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.moveTo(x, y);
        this.lineTo(x + width, y);
        this.lineTo(x + width, y + height);
        this.lineTo(x, y + height);
        this.close();
        this.currentPoint.x = x;
        this.currentPoint.y = y;
    }

    public void moveTo(float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.addPoint(1, x, y);
        this.currentPoint.x = x;
        this.currentPoint.y = y;
        this.startPoint.x = x;
        this.startPoint.y = y;
    }

    public void lineTo(float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.addPoint(2, x, y);
        this.currentPoint.x = x;
        this.currentPoint.y = y;
    }

    public void quadTo(float cx, float cy, float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.addPoint(3, cx, cy, x, y);
        this.currentPoint.x = x;
        this.currentPoint.y = y;
    }

    public void cubicTo(float cx1, float cy1, float cx2, float cy2, float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.addPoint(4, cx1, cy1, cx2, cy2, x, y);
        this.currentPoint.x = x;
        this.currentPoint.y = y;
    }

    public void close() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.addPoint(5, new float[0]);
        this.currentPoint.x = this.startPoint.x;
        this.currentPoint.y = this.startPoint.y;
    }

    public PathData getPathData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int typesLength = this.types.length;
        int pointsLength = this.points.length;
        if (this.getLastPointType() == 1) {
            --typesLength;
            pointsLength -= 2;
        }
        PathData result = new PathData();
        result.types = new byte[typesLength];
        result.points = new float[pointsLength];
        System.arraycopy(this.types, 0, result.types, 0, typesLength);
        System.arraycopy(this.points, 0, result.points, 0, pointsLength);
        return result;
    }

    public void getCurrentPoint(float[] point) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (point == null) {
            SWT.error(4);
        }
        if (point.length < 2) {
            SWT.error(5);
        }
        point[0] = this.currentPoint.x;
        point[1] = this.currentPoint.y;
    }

    @Override
    void destroy() {
        this.types = null;
        this.points = null;
    }

    private void appendData(PathData data) {
        byte[] types = data.types;
        float[] points = data.points;
        int i = 0;
        int j = 0;
        while (i < types.length) {
            switch (types[i]) {
                case 1: {
                    this.moveTo(points[j++], points[j++]);
                    break;
                }
                case 2: {
                    this.lineTo(points[j++], points[j++]);
                    break;
                }
                case 4: {
                    this.cubicTo(points[j++], points[j++], points[j++], points[j++], points[j++], points[j++]);
                    break;
                }
                case 3: {
                    this.quadTo(points[j++], points[j++], points[j++], points[j++]);
                    break;
                }
                case 5: {
                    this.close();
                    break;
                }
                default: {
                    this.dispose();
                    SWT.error(5);
                }
            }
            ++i;
        }
    }

    private void addPoint(int type, float ... coords) {
        if (type != 1 || this.getLastPointType() != 1) {
            this.enlargeArrays(1, coords.length);
        }
        this.types[this.types.length - 1] = (byte)type;
        int i = coords.length;
        while (i > 0) {
            this.points[this.points.length - i] = coords[coords.length - i];
            --i;
        }
    }

    private int getLastPointType() {
        return this.types.length > 0 ? this.types[this.types.length - 1] : 0;
    }

    private void enlargeArrays(int typesAmount, int pointsAmount) {
        if (typesAmount > 0) {
            byte[] newTypes = new byte[this.types.length + typesAmount];
            System.arraycopy(this.types, 0, newTypes, 0, this.types.length);
            this.types = newTypes;
        }
        if (pointsAmount > 0) {
            float[] newPoints = new float[this.points.length + pointsAmount];
            System.arraycopy(this.points, 0, newPoints, 0, this.points.length);
            this.points = newPoints;
        }
    }

    private final class PointF {
        public float x;
        public float y;

        private PointF() {
        }
    }
}

