/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.ControlGC;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceGC;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GCDelegate;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Control;

public class GC
extends Resource {
    private final GCDelegate delegate;
    private boolean advanced;
    private int antialias;
    private int textAntialias;

    public GC(Drawable drawable) {
        this(drawable, 0);
    }

    public GC(Drawable drawable, int style) {
        super(GC.determineDevice(drawable));
        if (drawable == null) {
            SWT.error(4);
        }
        this.delegate = GC.determineDelegate(drawable);
        this.antialias = -1;
        this.textAntialias = -1;
    }

    public void setFont(Font font) {
        this.checkDisposed();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        Font newFont = font != null ? font : this.delegate.getDefaultFont();
        this.delegate.setFont(newFont);
    }

    public Font getFont() {
        this.checkDisposed();
        return this.delegate.getFont();
    }

    public int getCharWidth(char ch) {
        this.checkDisposed();
        return this.delegate.stringExtent((String)Character.toString((char)ch)).x;
    }

    public Point stringExtent(String string) {
        this.checkDisposed();
        if (string == null) {
            SWT.error(4);
        }
        return this.delegate.stringExtent(string);
    }

    public Point textExtent(String string) {
        this.checkDisposed();
        if (string == null) {
            SWT.error(4);
        }
        return this.delegate.textExtent(string, 0);
    }

    public FontMetrics getFontMetrics() {
        this.checkDisposed();
        return new FontMetrics(this.delegate.getFont());
    }

    public void setBackground(Color color) {
        this.checkDisposed();
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.delegate.setBackground(color);
    }

    public Color getBackground() {
        this.checkDisposed();
        return this.delegate.getBackground();
    }

    public void setForeground(Color color) {
        this.checkDisposed();
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.delegate.setForeground(color);
    }

    public Color getForeground() {
        this.checkDisposed();
        return this.delegate.getForeground();
    }

    public void setClipping(Rectangle rect) {
        this.checkDisposed();
        if (rect == null) {
            this.delegate.setClipping((Rectangle)null);
        } else {
            this.setClipping(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public void setClipping(int x, int y, int width, int height) {
        this.checkDisposed();
        this.delegate.setClipping(new Rectangle(x, y, width, height));
    }

    public void setClipping(Path path) {
        this.checkDisposed();
        if (path != null && path.isDisposed()) {
            SWT.error(5);
        }
        this.delegate.setClipping(path);
    }

    public Rectangle getClipping() {
        this.checkDisposed();
        return this.delegate.getClipping();
    }

    public void setAlpha(int alpha) {
        this.checkDisposed();
        if (alpha >= 0 && alpha <= 255 && this.delegate.getAlpha() != alpha) {
            this.delegate.setAlpha(alpha);
            this.advanced = true;
        }
    }

    public int getAlpha() {
        this.checkDisposed();
        return this.delegate.getAlpha();
    }

    public void setLineWidth(int lineWidth) {
        this.checkDisposed();
        if (this.delegate.getLineWidth() != lineWidth) {
            this.delegate.setLineWidth(lineWidth);
        }
    }

    public int getLineWidth() {
        this.checkDisposed();
        return this.delegate.getLineWidth();
    }

    public void setLineCap(int lineCap) {
        this.checkDisposed();
        if (this.delegate.getLineCap() != lineCap) {
            switch (lineCap) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
            this.delegate.setLineCap(lineCap);
        }
    }

    public int getLineCap() {
        this.checkDisposed();
        return this.delegate.getLineCap();
    }

    public void setLineJoin(int lineJoin) {
        this.checkDisposed();
        if (this.delegate.getLineJoin() != lineJoin) {
            switch (lineJoin) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
            this.delegate.setLineJoin(lineJoin);
        }
    }

    public int getLineJoin() {
        this.checkDisposed();
        return this.delegate.getLineJoin();
    }

    public void setLineAttributes(LineAttributes attributes) {
        this.checkDisposed();
        if (attributes == null) {
            SWT.error(4);
        }
        this.setLineWidth((int)attributes.width);
        this.setLineCap(attributes.cap);
        this.setLineJoin(attributes.join);
        this.advanced = true;
    }

    public LineAttributes getLineAttributes() {
        this.checkDisposed();
        int lineWidth = this.delegate.getLineWidth();
        int lineCap = this.delegate.getLineCap();
        int lineJoin = this.delegate.getLineJoin();
        return new LineAttributes(lineWidth, lineCap, lineJoin);
    }

    public void setAdvanced(boolean advanced) {
        this.checkDisposed();
        this.advanced = advanced;
        if (!advanced) {
            this.delegate.setAlpha(255);
            this.antialias = -1;
            this.textAntialias = -1;
        }
    }

    public void setAntialias(int antialias) {
        if (antialias != -1 && antialias != 1 && antialias != 0) {
            SWT.error(5);
        }
        this.antialias = antialias;
        this.advanced = true;
    }

    public int getAntialias() {
        return this.antialias;
    }

    public void setTextAntialias(int antialias) {
        if (antialias != -1 && antialias != 1 && antialias != 0) {
            SWT.error(5);
        }
        this.textAntialias = antialias;
        this.advanced = true;
    }

    public int getTextAntialias() {
        return this.textAntialias;
    }

    public boolean getAdvanced() {
        this.checkDisposed();
        return this.advanced;
    }

    public void setTransform(Transform transform) {
        this.checkDisposed();
        if (transform != null && transform.isDisposed()) {
            SWT.error(5);
        }
        float[] elements = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
        if (transform == null) {
            this.delegate.setTransform(elements);
        } else {
            transform.getElements(elements);
            this.delegate.setTransform(elements);
        }
    }

    public void getTransform(Transform transform) {
        this.checkDisposed();
        if (transform == null) {
            SWT.error(4);
        }
        if (transform.isDisposed()) {
            SWT.error(5);
        }
        float[] elements = this.delegate.getTransform();
        transform.setElements(elements[0], elements[1], elements[2], elements[3], elements[4], elements[5]);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.checkDisposed();
        this.delegate.drawLine(x1, y1, x2, y2);
    }

    public void drawRectangle(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        this.drawRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void drawRectangle(int x, int y, int width, int height) {
        this.checkDisposed();
        this.drawRectangle(x, y, width, height, 0, 0, false);
    }

    public void drawFocus(int x, int y, int width, int height) {
        this.drawRectangle(x, y, width, height);
    }

    public void fillRectangle(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        this.fillRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        this.checkDisposed();
        this.drawRectangle(x, y, width, height, 0, 0, true);
    }

    public void fillGradientRectangle(int x, int y, int width, int height, boolean vertical) {
        this.checkDisposed();
        if (width != 0 && height != 0) {
            if (this.delegate.getBackground().equals(this.delegate.getForeground())) {
                this.fillRectangle(x, y, width, height);
            } else {
                this.fillGradientRect(x, y, width, height, vertical);
            }
        }
    }

    public void drawRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.checkDisposed();
        this.drawRectangle(x, y, width, height, arcWidth, arcHeight, false);
    }

    public void fillRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.checkDisposed();
        this.drawRectangle(x, y, width, height, arcWidth, arcHeight, true);
    }

    public void drawOval(int x, int y, int width, int height) {
        this.checkDisposed();
        this.drawArc(x, y, width, height, 0, 360, false);
    }

    public void fillOval(int x, int y, int width, int height) {
        this.checkDisposed();
        this.drawArc(x, y, width, height, 0, 360, true);
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.checkDisposed();
        this.drawArc(x, y, width, height, startAngle, arcAngle, false);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.checkDisposed();
        this.drawArc(x, y, width, height, startAngle, arcAngle, true);
    }

    public void drawPolygon(int[] pointArray) {
        this.checkDisposed();
        if (pointArray == null) {
            SWT.error(4);
        }
        this.delegate.drawPolyline(pointArray, true, false);
    }

    public void fillPolygon(int[] pointArray) {
        this.checkDisposed();
        if (pointArray == null) {
            SWT.error(4);
        }
        this.delegate.drawPolyline(pointArray, true, true);
    }

    public void drawPolyline(int[] pointArray) {
        this.checkDisposed();
        if (pointArray == null) {
            SWT.error(4);
        }
        this.delegate.drawPolyline(pointArray, false, false);
    }

    public void drawPoint(int x, int y) {
        this.checkDisposed();
        this.delegate.drawPoint(x, y);
    }

    public void drawImage(Image image, int x, int y) {
        this.checkDisposed();
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        Rectangle src = new Rectangle(0, 0, -1, -1);
        Rectangle dest = new Rectangle(x, y, -1, -1);
        this.delegate.drawImage(image, src, dest, true);
    }

    public void drawImage(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight) {
        this.checkDisposed();
        if (srcWidth != 0 && srcHeight != 0 && destWidth != 0 && destHeight != 0) {
            if (srcX < 0 || srcY < 0 || srcWidth < 0 || srcHeight < 0 || destWidth < 0 || destHeight < 0) {
                SWT.error(5);
            }
            if (image == null) {
                SWT.error(4);
            }
            if (image.isDisposed()) {
                SWT.error(5);
            }
            int imgWidth = image.getBounds().width;
            int imgHeight = image.getBounds().height;
            if (srcX + srcWidth > imgWidth || srcY + srcHeight > imgHeight) {
                SWT.error(5);
            }
            Rectangle src = new Rectangle(srcX, srcY, srcWidth, srcHeight);
            Rectangle dest = new Rectangle(destX, destY, destWidth, destHeight);
            this.delegate.drawImage(image, src, dest, false);
        }
    }

    public void drawString(String string, int x, int y) {
        this.drawString(string, x, y, false);
    }

    public void drawString(String string, int x, int y, boolean isTransparent) {
        int flags = isTransparent ? 1 : 0;
        this.drawText(string, x, y, flags);
    }

    public void drawText(String string, int x, int y) {
        this.drawText(string, x, y, 6);
    }

    public void drawText(String string, int x, int y, boolean isTransparent) {
        int flags = 6;
        if (isTransparent) {
            flags |= 1;
        }
        this.drawText(string, x, y, flags);
    }

    public void drawText(String string, int x, int y, int flags) {
        this.checkDisposed();
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() != 0) {
            this.delegate.drawText(string, x, y, flags);
        }
    }

    public void drawPath(Path path) {
        this.checkDisposed();
        if (path == null) {
            SWT.error(4);
        }
        if (path.isDisposed()) {
            SWT.error(5);
        }
        this.delegate.drawPath(path, false);
    }

    public void fillPath(Path path) {
        this.checkDisposed();
        if (path == null) {
            SWT.error(4);
        }
        if (path.isDisposed()) {
            SWT.error(5);
        }
        this.delegate.drawPath(path, true);
    }

    public int getStyle() {
        this.checkDisposed();
        return 0x2000000;
    }

    GCDelegate getGCDelegate() {
        return this.delegate;
    }

    static Rectangle checkBounds(int x, int y, int width, int height) {
        Rectangle result = new Rectangle(x, y, width, height);
        if (width < 0) {
            result.x = x + width;
            result.width = -width;
        }
        if (height < 0) {
            result.y = y + height;
            result.height = -height;
        }
        return result;
    }

    private void checkDisposed() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    private void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle, boolean fill) {
        Rectangle bounds = GC.checkBounds(x, y, width, height);
        if (bounds.width != 0 && bounds.height != 0 && arcAngle != 0) {
            this.delegate.drawArc(bounds, startAngle, arcAngle, fill);
        }
    }

    private void drawRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight, boolean fill) {
        Rectangle bounds = GC.checkBounds(x, y, width, height);
        if (bounds.width != 0 && bounds.height != 0) {
            if (arcWidth == 0 || arcHeight == 0) {
                this.delegate.drawRectangle(bounds, fill);
            } else {
                int absArcWidth = Math.abs(arcWidth);
                int absArcHeight = Math.abs(arcHeight);
                this.delegate.drawRoundRectangle(bounds, absArcWidth, absArcHeight, fill);
            }
        }
    }

    private void fillGradientRect(int x, int y, int width, int height, boolean vertical) {
        Rectangle bounds = new Rectangle(x, y, width, height);
        this.delegate.fillGradientRectangle(bounds, vertical);
    }

    private static GCDelegate determineDelegate(Drawable drawable) {
        GCDelegate result = null;
        if (drawable instanceof Control) {
            result = new ControlGC((Control)drawable);
        } else if (drawable instanceof Device) {
            result = new DeviceGC((Device)drawable);
        }
        return result;
    }

    private static Device determineDevice(Drawable drawable) {
        Device result = null;
        if (drawable instanceof Control) {
            result = ((Control)drawable).getDisplay();
        } else if (drawable instanceof Device) {
            result = (Device)drawable;
        }
        return result;
    }

    void writeObject(ObjectOutputStream stream) throws IOException {
        throw new NotSerializableException(this.getClass().getName());
    }
}

