/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.TimerTask;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.widgets.TimerExecScheduler;

class TimerExecTask
extends TimerTask
implements SerializableCompatibility {
    private final TimerExecScheduler scheduler;
    private final Runnable runnable;

    TimerExecTask(TimerExecScheduler scheduler, Runnable runnable) {
        this.scheduler = scheduler;
        this.runnable = runnable;
        scheduler.serverPushManager.activateServerPushFor(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.scheduler.display.getDeviceLock();
        synchronized (object) {
            this.scheduler.removeTask(this);
            if (!this.scheduler.display.isDisposed()) {
                this.scheduler.display.asyncExec(this.runnable);
            }
        }
        this.scheduler.serverPushManager.deactivateServerPushFor(this);
    }

    @Override
    public boolean cancel() {
        this.scheduler.serverPushManager.deactivateServerPushFor(this);
        return super.cancel();
    }

    Runnable getRunnable() {
        return this.runnable;
    }
}

