/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.rap.rwt.internal.theme.Size;
import org.eclipse.rap.rwt.internal.theme.ThemeAdapter;
import org.eclipse.rap.rwt.theme.BoxDimensions;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.MarkupUtil;
import org.eclipse.swt.internal.widgets.MarkupValidator;
import org.eclipse.swt.internal.widgets.buttonkit.ButtonLCA;
import org.eclipse.swt.internal.widgets.buttonkit.ButtonThemeAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;

public class Button
extends Control {
    private String text = "";
    private boolean selected;
    private boolean grayed;
    private Image image;
    private boolean isDefault;

    public Button(Composite parent, int style) {
        super(parent, Button.checkStyle(style));
    }

    @Override
    void initState() {
        if ((this.style & 0xA) == 0) {
            this.addState(256);
        }
    }

    public void setText(String text) {
        this.checkWidget();
        if (text == null) {
            SWT.error(4);
        }
        if ((this.style & 4) == 0) {
            if (MarkupUtil.isMarkupEnabledFor(this) && !MarkupValidator.isValidationDisabledFor(this)) {
                MarkupValidator.getInstance().validate(text);
            }
            this.text = text;
        }
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean getSelection() {
        this.checkWidget();
        boolean result = false;
        if ((this.style & 0x32) != 0) {
            result = this.selected;
        }
        return result;
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x32) != 0) {
            this.selected = selected;
        }
    }

    public boolean getGrayed() {
        this.checkWidget();
        boolean result = false;
        if ((this.style & 0x20) != 0) {
            result = this.grayed;
        }
        return result;
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.style & 0x20) != 0) {
            this.grayed = grayed;
        }
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            SWT.error(5);
        }
        if ((this.style & 4) == 0) {
            this.image = image;
        }
    }

    public int getAlignment() {
        this.checkWidget();
        int result = (this.style & 4) != 0 ? ((this.style & 0x80) != 0 ? 128 : ((this.style & 0x400) != 0 ? 1024 : ((this.style & 0x4000) != 0 ? 16384 : ((this.style & 0x20000) != 0 ? 131072 : 128)))) : ((this.style & 0x4000) != 0 ? 16384 : ((this.style & 0x1000000) != 0 ? 0x1000000 : ((this.style & 0x20000) != 0 ? 131072 : 16384)));
        return result;
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x24480) != 0) {
                this.style &= 0xFFFDBB7F;
                this.style |= alignment & 0x24480;
            }
        } else if ((alignment & 0x1024000) != 0) {
            this.style &= 0xFEFDBFFF;
            this.style |= alignment & 0x1024000;
        }
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        ButtonThemeAdapter themeAdapter = this.getThemeAdapter();
        BoxDimensions padding = themeAdapter.getPadding(this);
        if ((this.style & 4) != 0) {
            Size arrowSize = themeAdapter.getArrowSize(this);
            width = arrowSize.width;
            height = arrowSize.height;
        } else {
            boolean hasImage = this.image != null;
            boolean hasText = this.text.length() > 0;
            Font font = this.getFont();
            if ((this.style & 0x30) != 0) {
                Size checkSize = themeAdapter.getCheckSize(this);
                width += checkSize.width;
                if (hasText || hasImage) {
                    width += themeAdapter.getCheckSpacing(this);
                }
                height = Math.max(height, checkSize.height);
            }
            if (hasImage) {
                Rectangle imageBounds = this.image.getBounds();
                width += imageBounds.width;
                height = Math.max(height, imageBounds.height);
            }
            if (hasText && hasImage) {
                width += themeAdapter.getSpacing(this);
            }
            if (hasText) {
                boolean markupEnabled = MarkupUtil.isMarkupEnabledFor(this);
                int wrapWidth = -1;
                if ((this.style & 0x40) != 0 && wHint != -1) {
                    wrapWidth = wHint - width - (padding.left + padding.right);
                }
                Point extent = TextSizeUtil.textExtent(font, this.text, wrapWidth, markupEnabled);
                width += extent.x;
                height = Math.max(height, extent.y);
            }
            if (height == 0) {
                height = TextSizeUtil.getCharHeight(font);
            }
        }
        width += padding.left + padding.right;
        height += padding.top + padding.bottom;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        BoxDimensions border = this.getBorder();
        return new Point(width += border.left + border.right, height += border.top + border.bottom);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    @Override
    public void setData(String key, Object value) {
        if ("org.eclipse.rap.rwt.badge".equals(key) && (this.style & 8) == 0) {
            return;
        }
        if ("org.eclipse.rap.rwt.markupEnabled".equals(key) && MarkupUtil.isMarkupEnabledFor(this)) {
            return;
        }
        super.setData(key, value);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == WidgetLCA.class) {
            return (T)ButtonLCA.INSTANCE;
        }
        return super.getAdapter(adapter);
    }

    void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    boolean getDefault() {
        return this.isDefault;
    }

    @Override
    boolean isTabGroup() {
        return true;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    private static int checkStyle(int style) {
        int result = Button.checkBits(style, 8, 4, 32, 16, 2, 0);
        if ((result & 0xA) != 0) {
            result = Button.checkBits(result, 0x1000000, 16384, 131072, 0, 0, 0);
        } else if ((result & 0x30) != 0) {
            result = Button.checkBits(result, 16384, 131072, 0x1000000, 0, 0, 0);
        } else if ((result & 4) != 0) {
            result |= 0x80000;
            result = Button.checkBits(result, 128, 1024, 16384, 131072, 0, 0);
        }
        return result;
    }

    private ButtonThemeAdapter getThemeAdapter() {
        return (ButtonThemeAdapter)this.getAdapter(ThemeAdapter.class);
    }
}

