/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.dnd.droptargetkit.DropTargetLCA;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class DropTarget
extends Widget {
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DropTargetEffect dropEffect;
    TransferData selectedDataType;
    int selectedOperation;
    int keyOperation = -1;
    static final String DEFAULT_DROP_TARGET_EFFECT = "DEFAULT_DROP_TARGET_EFFECT";

    public DropTarget(Control control, int style) {
        super(control, DropTarget.checkStyle(style));
        this.control = control;
        if (control.getData("DropTarget") != null) {
            DND.error(2001);
        }
        control.setData("DropTarget", this);
        this.controlListener = new Listener(){

            @Override
            public void handleEvent(Event event) {
                if (!DropTarget.this.isDisposed()) {
                    DropTarget.this.dispose();
                }
            }
        };
        control.addListener(12, this.controlListener);
        this.addListener(12, new Listener(){

            @Override
            public void handleEvent(Event event) {
                DropTarget.this.onDispose();
            }
        });
        Object effect = control.getData(DEFAULT_DROP_TARGET_EFFECT);
        if (effect instanceof DropTargetEffect) {
            this.dropEffect = (DropTargetEffect)effect;
        }
    }

    static int checkStyle(int style) {
        if (style == 0) {
            return 2;
        }
        return style;
    }

    public void addDropListener(DropTargetListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        DNDListener typedListener = new DNDListener(listener);
        typedListener.dndWidget = this;
        this.addListener(2002, typedListener);
        this.addListener(2003, typedListener);
        this.addListener(2004, typedListener);
        this.addListener(2005, typedListener);
        this.addListener(2006, typedListener);
        this.addListener(2007, typedListener);
    }

    @Override
    protected void checkSubclass() {
        String name = this.getClass().getName();
        String validName = DropTarget.class.getName();
        if (!validName.equals(name)) {
            DND.error(43);
        }
    }

    public Control getControl() {
        return this.control;
    }

    public DropTargetListener[] getDropListeners() {
        Listener[] listeners = this.getListeners(2002);
        int length = listeners.length;
        DropTargetListener[] dropListeners = new DropTargetListener[length];
        int count = 0;
        int i = 0;
        while (i < length) {
            Listener listener = listeners[i];
            if (listener instanceof DNDListener) {
                dropListeners[count] = (DropTargetListener)((DNDListener)listener).getEventListener();
                ++count;
            }
            ++i;
        }
        if (count == length) {
            return dropListeners;
        }
        DropTargetListener[] result = new DropTargetListener[count];
        System.arraycopy(dropListeners, 0, result, 0, count);
        return result;
    }

    public DropTargetEffect getDropTargetEffect() {
        return this.dropEffect;
    }

    void onDispose() {
        if (this.control == null) {
            return;
        }
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData("DropTarget", null);
        this.transferAgents = null;
        this.control = null;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    public void removeDropListener(DropTargetListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        this.removeListener(2002, listener);
        this.removeListener(2003, listener);
        this.removeListener(2004, listener);
        this.removeListener(2005, listener);
        this.removeListener(2006, listener);
        this.removeListener(2007, listener);
    }

    public void setDropTargetEffect(DropTargetEffect effect) {
        this.dropEffect = effect;
    }

    public void setTransfer(Transfer[] transferAgents) {
        if (transferAgents == null) {
            DND.error(4);
        }
        this.transferAgents = transferAgents;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == WidgetLCA.class) {
            return (T)DropTargetLCA.INSTANCE;
        }
        return super.getAdapter(adapter);
    }
}

