/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.servletbridge;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class CloseableURLClassLoader
extends URLClassLoader {
    private static final boolean CLOSEABLE_REGISTERED_AS_PARALLEL;
    static final String DOT_CLASS = ".class";
    static final String BANG_SLASH = "!/";
    static final String JAR = "jar";
    private static final String UNC_PREFIX = "//";
    private static final String SCHEME_FILE = "file";
    final ArrayList loaders = new ArrayList<E>();
    private final ArrayList loaderURLs = new ArrayList<E>();
    boolean closed = false;
    private final AccessControlContext context;
    private final boolean verifyJars;
    private final boolean registeredAsParallel;
    private final Map classNameLocks = new HashMap<K, V>(5);
    private final Object pkgLock = new Object();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        boolean registeredAsParallel;
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.ClassLoader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Method parallelCapableMetod = clazz.getDeclaredMethod("registerAsParallelCapable", null);
            parallelCapableMetod.setAccessible(true);
            registeredAsParallel = (Boolean)parallelCapableMetod.invoke(null, null);
        }
        catch (Throwable throwable) {
            registeredAsParallel = true;
        }
        CLOSEABLE_REGISTERED_AS_PARALLEL = registeredAsParallel;
    }

    public CloseableURLClassLoader(URL[] urls) {
        this(urls, ClassLoader.getSystemClassLoader(), true);
    }

    public CloseableURLClassLoader(URL[] urls, ClassLoader parent) {
        this(CloseableURLClassLoader.excludeFileJarURLS(urls), parent, true);
    }

    /*
     * Unable to fully structure code
     */
    public CloseableURLClassLoader(URL[] urls, ClassLoader parent, boolean verifyJars) {
        super(CloseableURLClassLoader.excludeFileJarURLS(urls), parent);
        if (!CloseableURLClassLoader.CLOSEABLE_REGISTERED_AS_PARALLEL) ** GOTO lbl-1000
        v0 = this.getClass();
        v1 = CloseableURLClassLoader.class$1;
        if (v1 == null) {
            try {
                v1 = CloseableURLClassLoader.class$1 = Class.forName("org.eclipse.equinox.servletbridge.CloseableURLClassLoader");
            }
            catch (ClassNotFoundException v2) {
                throw new NoClassDefFoundError(v2.getMessage());
            }
        }
        if (v0 == v1) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = false;
        }
        this.registeredAsParallel = v3;
        this.context = AccessController.getContext();
        this.verifyJars = verifyJars;
        i = 0;
        while (i < urls.length) {
            if (CloseableURLClassLoader.isFileJarURL(urls[i])) {
                this.loaderURLs.add(urls[i]);
                this.safeAddLoader(urls[i]);
            }
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean safeAddLoader(URL url) {
        File file = new File(CloseableURLClassLoader.toURI(url));
        if (!file.exists()) return false;
        try {
            this.loaders.add(new CloseableJarFileLoader(file, this.verifyJars));
            return true;
        }
        catch (IOException iOException) {
            try {
                return false;
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return false;
    }

    private static URI toURI(URL url) throws URISyntaxException {
        if (!SCHEME_FILE.equals(url.getProtocol())) {
            throw new IllegalArgumentException("bad prototcol: " + url.getProtocol());
        }
        String pathString = url.toExternalForm().substring(5);
        if (pathString.indexOf(47) != 0) {
            pathString = String.valueOf('/') + pathString;
        } else if (pathString.startsWith(UNC_PREFIX) && !pathString.startsWith(UNC_PREFIX, 2)) {
            pathString = CloseableURLClassLoader.ensureUNCPath(pathString);
        }
        return new URI(SCHEME_FILE, null, pathString, null);
    }

    private static String ensureUNCPath(String path) {
        int len = path.length();
        StringBuffer result = new StringBuffer(len);
        int i = 0;
        while (i < 4) {
            if (i >= len || result.length() > 0 || path.charAt(i) != '/') {
                result.append('/');
            }
            ++i;
        }
        result.append(path);
        return ((Object)result).toString();
    }

    private static URL[] excludeFileJarURLS(URL[] urls) {
        ArrayList<URL> urlList = new ArrayList<URL>();
        int i = 0;
        while (i < urls.length) {
            if (!CloseableURLClassLoader.isFileJarURL(urls[i])) {
                urlList.add(urls[i]);
            }
            ++i;
        }
        return urlList.toArray(new URL[urlList.size()]);
    }

    private static boolean isFileJarURL(URL url) {
        if (!url.getProtocol().equals(SCHEME_FILE)) {
            return false;
        }
        String path = url.getPath();
        return path == null || !path.endsWith("/");
    }

    protected Class findClass(final String name) throws ClassNotFoundException {
        try {
            Class clazz = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws ClassNotFoundException {
                    String resourcePath = String.valueOf(name.replace('.', '/')) + CloseableURLClassLoader.DOT_CLASS;
                    CloseableJarFileLoader loader = null;
                    URL resourceURL = null;
                    ArrayList arrayList = CloseableURLClassLoader.this.loaders;
                    synchronized (arrayList) {
                        block8: {
                            if (!CloseableURLClassLoader.this.closed) break block8;
                            return null;
                        }
                        Iterator iterator = CloseableURLClassLoader.this.loaders.iterator();
                        while (iterator.hasNext()) {
                            loader = (CloseableJarFileLoader)iterator.next();
                            resourceURL = loader.getURL(resourcePath);
                            if (resourceURL != null) break;
                        }
                    }
                    if (resourceURL != null) {
                        try {
                            return CloseableURLClassLoader.this.defineClass(name, resourceURL, loader.getManifest());
                        }
                        catch (IOException e) {
                            throw new ClassNotFoundException(name, e);
                        }
                    }
                    return null;
                }
            }, this.context);
            if (clazz != null) {
                return clazz;
            }
        }
        catch (PrivilegedActionException e) {
            throw (ClassNotFoundException)e.getException();
        }
        return super.findClass(name);
    }

    /*
     * Exception decompiling
     */
    Class defineClass(String name, URL resourceURL, Manifest manifest) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkForSealedPackage(Package pkg, String packageName, Manifest manifest, URL jarFileURL) {
        if (pkg.isSealed()) {
            if (!pkg.isSealed(jarFileURL)) {
                throw new SecurityException("The package '" + packageName + "' was previously loaded and is already sealed.");
            }
        } else {
            Attributes mainAttributes;
            String entryPath = String.valueOf(packageName.replace('.', '/')) + "/";
            Attributes entryAttributes = manifest.getAttributes(entryPath);
            String sealed = null;
            if (entryAttributes != null) {
                sealed = entryAttributes.getValue(Attributes.Name.SEALED);
            }
            if (sealed == null && (mainAttributes = manifest.getMainAttributes()) != null) {
                sealed = mainAttributes.getValue(Attributes.Name.SEALED);
            }
            if (Boolean.valueOf(sealed).booleanValue()) {
                throw new SecurityException("The package '" + packageName + "' was previously loaded unsealed. Cannot seal package.");
            }
        }
    }

    public URL findResource(final String name) {
        URL url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                ArrayList arrayList = CloseableURLClassLoader.this.loaders;
                synchronized (arrayList) {
                    block5: {
                        if (!CloseableURLClassLoader.this.closed) break block5;
                        return null;
                    }
                    Iterator iterator = CloseableURLClassLoader.this.loaders.iterator();
                    while (iterator.hasNext()) {
                        CloseableJarFileLoader loader = (CloseableJarFileLoader)iterator.next();
                        URL resourceURL = loader.getURL(name);
                        if (resourceURL == null) continue;
                        return resourceURL;
                    }
                }
                return null;
            }
        }, this.context);
        if (url != null) {
            return url;
        }
        return super.findResource(name);
    }

    public Enumeration findResources(final String name) throws IOException {
        final ArrayList<URL> resources = new ArrayList<URL>();
        AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                ArrayList arrayList = CloseableURLClassLoader.this.loaders;
                synchronized (arrayList) {
                    block5: {
                        if (!CloseableURLClassLoader.this.closed) break block5;
                        return null;
                    }
                    Iterator iterator = CloseableURLClassLoader.this.loaders.iterator();
                    while (iterator.hasNext()) {
                        CloseableJarFileLoader loader = (CloseableJarFileLoader)iterator.next();
                        URL resourceURL = loader.getURL(name);
                        if (resourceURL == null) continue;
                        resources.add(resourceURL);
                    }
                }
                return null;
            }
        }, this.context);
        Enumeration<URL> e = super.findResources(name);
        while (e.hasMoreElements()) {
            resources.add(e.nextElement());
        }
        return Collections.enumeration(resources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ArrayList arrayList = this.loaders;
        synchronized (arrayList) {
            if (this.closed) {
                return;
            }
            Iterator iterator = this.loaders.iterator();
            while (iterator.hasNext()) {
                CloseableJarFileLoader loader = (CloseableJarFileLoader)iterator.next();
                loader.close();
            }
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addURL(URL url) {
        ArrayList arrayList = this.loaders;
        synchronized (arrayList) {
            if (CloseableURLClassLoader.isFileJarURL(url)) {
                if (this.closed) {
                    throw new IllegalStateException("Cannot add url. CloseableURLClassLoader is closed.");
                }
                this.loaderURLs.add(url);
                if (this.safeAddLoader(url)) {
                    return;
                }
            }
        }
        super.addURL(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] getURLs() {
        ArrayList<URL> result = new ArrayList<URL>();
        ArrayList arrayList = this.loaders;
        synchronized (arrayList) {
            result.addAll(this.loaderURLs);
        }
        result.addAll(Arrays.asList(super.getURLs()));
        return result.toArray(new URL[result.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean lockClassName(String classname) {
        Map map = this.classNameLocks;
        synchronized (map) {
            Object lockingThread = this.classNameLocks.get(classname);
            Thread current = Thread.currentThread();
            if (lockingThread == current) {
                return false;
            }
            boolean previousInterruption = Thread.interrupted();
            try {
                while (true) {
                    if (lockingThread == null) {
                        this.classNameLocks.put(classname, current);
                        return true;
                    }
                    this.classNameLocks.wait();
                    lockingThread = this.classNameLocks.get(classname);
                    continue;
                    break;
                }
            }
            catch (InterruptedException e) {
                current.interrupt();
                throw (LinkageError)new LinkageError(classname).initCause(e);
            }
            finally {
                if (previousInterruption) {
                    current.interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockClassName(String classname) {
        Map map = this.classNameLocks;
        synchronized (map) {
            this.classNameLocks.remove(classname);
            this.classNameLocks.notifyAll();
        }
    }

    protected boolean isRegisteredAsParallel() {
        return this.registeredAsParallel;
    }

    private static class CloseableJarFileLoader {
        private final JarFile jarFile;
        private final Manifest manifest;
        private final CloseableJarURLStreamHandler jarURLStreamHandler;
        private final String jarFileURLPrefixString;

        public CloseableJarFileLoader(File file, boolean verify) throws IOException {
            this.jarFile = new JarFile(file, verify);
            this.manifest = this.jarFile.getManifest();
            this.jarURLStreamHandler = new CloseableJarURLStreamHandler(this.jarFile);
            this.jarFileURLPrefixString = String.valueOf(((Object)file.toURL()).toString()) + CloseableURLClassLoader.BANG_SLASH;
        }

        public URL getURL(String name) {
            if (this.jarFile.getEntry(name) != null) {
                try {
                    return new URL(CloseableURLClassLoader.JAR, null, -1, String.valueOf(this.jarFileURLPrefixString) + name, this.jarURLStreamHandler);
                }
                catch (MalformedURLException malformedURLException) {}
            }
            return null;
        }

        public Manifest getManifest() {
            return this.manifest;
        }

        public void close() {
            try {
                this.jarFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static class CloseableJarURLConnection
    extends JarURLConnection {
        private final JarFile jarFile;
        private JarEntry entry;

        public CloseableJarURLConnection(URL url, JarFile jarFile) throws MalformedURLException {
            super(url);
            this.jarFile = jarFile;
        }

        public void connect() throws IOException {
            this.internalGetEntry();
        }

        private synchronized JarEntry internalGetEntry() throws IOException {
            if (this.entry != null) {
                return this.entry;
            }
            this.entry = this.jarFile.getJarEntry(this.getEntryName());
            if (this.entry == null) {
                throw new FileNotFoundException(this.getEntryName());
            }
            return this.entry;
        }

        public InputStream getInputStream() throws IOException {
            return this.jarFile.getInputStream(this.internalGetEntry());
        }

        public JarFile getJarFile() throws IOException {
            return this.jarFile;
        }

        public JarEntry getJarEntry() throws IOException {
            return this.internalGetEntry();
        }
    }

    private static class CloseableJarURLStreamHandler
    extends URLStreamHandler {
        private final JarFile jarFile;

        public CloseableJarURLStreamHandler(JarFile jarFile) {
            this.jarFile = jarFile;
        }

        protected URLConnection openConnection(URL u) throws IOException {
            return new CloseableJarURLConnection(u, this.jarFile);
        }

        protected void parseURL(URL u, String spec, int start, int limit) {
            this.setURL(u, CloseableURLClassLoader.JAR, null, 0, null, null, spec.substring(start, limit), null, null);
        }
    }
}

