/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.InvalidObjectException;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DateFormat
extends Format {
    private static final long serialVersionUID = 1L;
    public final java.text.DateFormat dateFormat;
    public static final int ERA_FIELD = 0;
    public static final int YEAR_FIELD = 1;
    public static final int MONTH_FIELD = 2;
    public static final int DATE_FIELD = 3;
    public static final int HOUR_OF_DAY1_FIELD = 4;
    public static final int HOUR_OF_DAY0_FIELD = 5;
    public static final int MINUTE_FIELD = 6;
    public static final int SECOND_FIELD = 7;
    public static final int FRACTIONAL_SECOND_FIELD = 8;
    public static final int MILLISECOND_FIELD = 8;
    public static final int DAY_OF_WEEK_FIELD = 9;
    public static final int DAY_OF_YEAR_FIELD = 10;
    public static final int DAY_OF_WEEK_IN_MONTH_FIELD = 11;
    public static final int WEEK_OF_YEAR_FIELD = 12;
    public static final int WEEK_OF_MONTH_FIELD = 13;
    public static final int AM_PM_FIELD = 14;
    public static final int HOUR1_FIELD = 15;
    public static final int HOUR0_FIELD = 16;
    public static final int TIMEZONE_FIELD = 17;
    public static final int YEAR_WOY_FIELD = 18;
    public static final int DOW_LOCAL_FIELD = 19;
    public static final int EXTENDED_YEAR_FIELD = 20;
    public static final int JULIAN_DAY_FIELD = 21;
    public static final int MILLISECONDS_IN_DAY_FIELD = 22;
    public static final int TIMEZONE_RFC_FIELD = 23;
    public static final int TIMEZONE_GENERIC_FIELD = 24;
    public static final int STANDALONE_DAY_FIELD = 25;
    public static final int STANDALONE_MONTH_FIELD = 26;
    public static final int QUARTER_FIELD = 27;
    public static final int STANDALONE_QUARTER_FIELD = 28;
    public static final int TIMEZONE_SPECIAL_FIELD = 29;
    public static final int FIELD_COUNT = 30;
    public static final int NONE = -1;
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    public static final int DEFAULT = 2;
    public static final int RELATIVE = 128;
    public static final int RELATIVE_FULL = 128;
    public static final int RELATIVE_LONG = 129;
    public static final int RELATIVE_MEDIUM = 130;
    public static final int RELATIVE_SHORT = 131;
    public static final int RELATIVE_DEFAULT = 130;
    public static final String YEAR = "y";
    public static final String QUARTER = "QQQQ";
    public static final String ABBR_QUARTER = "QQQ";
    public static final String YEAR_QUARTER = "yQQQQ";
    public static final String YEAR_ABBR_QUARTER = "yQQQ";
    public static final String MONTH = "MMMM";
    public static final String ABBR_MONTH = "MMM";
    public static final String NUM_MONTH = "M";
    public static final String YEAR_MONTH = "yMMMM";
    public static final String YEAR_ABBR_MONTH = "yMMM";
    public static final String YEAR_NUM_MONTH = "yM";
    public static final String DAY = "d";
    public static final String YEAR_MONTH_DAY = "yMMMMd";
    public static final String YEAR_ABBR_MONTH_DAY = "yMMMd";
    public static final String YEAR_NUM_MONTH_DAY = "yMd";
    public static final String WEEKDAY = "EEEE";
    public static final String ABBR_WEEKDAY = "E";
    public static final String YEAR_MONTH_WEEKDAY_DAY = "yMMMMEEEEd";
    public static final String YEAR_ABBR_MONTH_WEEKDAY_DAY = "yMMMEd";
    public static final String YEAR_NUM_MONTH_WEEKDAY_DAY = "yMEd";
    public static final String MONTH_DAY = "MMMMd";
    public static final String ABBR_MONTH_DAY = "MMMd";
    public static final String NUM_MONTH_DAY = "Md";
    public static final String MONTH_WEEKDAY_DAY = "MMMMEEEEd";
    public static final String ABBR_MONTH_WEEKDAY_DAY = "MMMEd";
    public static final String NUM_MONTH_WEEKDAY_DAY = "MEd";
    public static final String HOUR = "j";
    public static final String HOUR24 = "H";
    public static final String MINUTE = "m";
    public static final String HOUR_MINUTE = "jm";
    public static final String HOUR24_MINUTE = "Hm";
    public static final String SECOND = "s";
    public static final String HOUR_MINUTE_SECOND = "jms";
    public static final String HOUR24_MINUTE_SECOND = "Hms";
    public static final String MINUTE_SECOND = "ms";
    public static final String LOCATION_TZ = "VVVV";
    public static final String GENERIC_TZ = "vvvv";
    public static final String ABBR_GENERIC_TZ = "v";
    public static final String SPECIFIC_TZ = "zzzz";
    public static final String ABBR_SPECIFIC_TZ = "z";
    public static final String ABBR_UTC_TZ = "ZZZZ";
    public static final String STANDALONE_MONTH = "LLLL";
    public static final String ABBR_STANDALONE_MONTH = "LLL";
    public static final String HOUR_MINUTE_GENERIC_TZ = "jmv";
    public static final String HOUR_MINUTE_TZ = "jmz";
    public static final String HOUR_GENERIC_TZ = "jv";
    public static final String HOUR_TZ = "jz";
    private static volatile ULocale[] availableULocales;

    public DateFormat(java.text.DateFormat delegate) {
        this.dateFormat = delegate;
    }

    protected DateFormat() {
        this.dateFormat = java.text.DateFormat.getDateTimeInstance(3, 3, ULocale.getDefault(ULocale.Category.FORMAT).toLocale());
    }

    public final StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        if (obj instanceof Calendar) {
            return this.format((Calendar)obj, toAppendTo, fieldPosition);
        }
        if (obj instanceof Date) {
            return this.format((Date)obj, toAppendTo, fieldPosition);
        }
        if (obj instanceof Number) {
            return this.format(new Date(((Number)obj).longValue()), toAppendTo, fieldPosition);
        }
        throw new IllegalArgumentException("Cannot format given Object (" + obj.getClass().getName() + ") as a Date");
    }

    public StringBuffer format(Calendar cal, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        return this.format(cal.getTime(), toAppendTo, fieldPosition);
    }

    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        FieldPosition jdkPos = DateFormat.toJDKFieldPosition(fieldPosition);
        StringBuffer buf = this.dateFormat.format(date, toAppendTo, jdkPos);
        if (jdkPos != null) {
            fieldPosition.setBeginIndex(jdkPos.getBeginIndex());
            fieldPosition.setEndIndex(jdkPos.getEndIndex());
        }
        return buf;
    }

    public final String format(Date date) {
        return this.dateFormat.format(date);
    }

    public Date parse(String text) throws ParseException {
        return this.dateFormat.parse(text);
    }

    public void parse(String text, Calendar cal, ParsePosition pos) {
        Date result = this.dateFormat.parse(text, pos);
        cal.setTime(result);
    }

    public Date parse(String text, ParsePosition pos) {
        return this.dateFormat.parse(text, pos);
    }

    public Object parseObject(String source, ParsePosition pos) {
        return this.parse(source, pos);
    }

    public static final DateFormat getTimeInstance() {
        return new DateFormat(java.text.DateFormat.getTimeInstance(2, ULocale.getDefault(ULocale.Category.FORMAT).toLocale()));
    }

    public static final DateFormat getTimeInstance(int style) {
        return new DateFormat(java.text.DateFormat.getTimeInstance(DateFormat.getJDKFormatStyle(style), ULocale.getDefault(ULocale.Category.FORMAT).toLocale()));
    }

    public static final DateFormat getTimeInstance(int style, Locale aLocale) {
        return new DateFormat(java.text.DateFormat.getTimeInstance(DateFormat.getJDKFormatStyle(style), aLocale));
    }

    public static final DateFormat getTimeInstance(int style, ULocale locale) {
        return new DateFormat(java.text.DateFormat.getTimeInstance(DateFormat.getJDKFormatStyle(style), locale.toLocale()));
    }

    public static final DateFormat getDateInstance() {
        return new DateFormat(java.text.DateFormat.getDateInstance(2, ULocale.getDefault(ULocale.Category.FORMAT).toLocale()));
    }

    public static final DateFormat getDateInstance(int style) {
        return new DateFormat(java.text.DateFormat.getDateInstance(DateFormat.getJDKFormatStyle(style), ULocale.getDefault(ULocale.Category.FORMAT).toLocale()));
    }

    public static final DateFormat getDateInstance(int style, Locale aLocale) {
        return new DateFormat(java.text.DateFormat.getDateInstance(DateFormat.getJDKFormatStyle(style), aLocale));
    }

    public static final DateFormat getDateInstance(int style, ULocale locale) {
        return new DateFormat(java.text.DateFormat.getDateInstance(DateFormat.getJDKFormatStyle(style), locale.toLocale()));
    }

    public static final DateFormat getDateTimeInstance() {
        return new DateFormat(java.text.DateFormat.getDateTimeInstance(2, 2, ULocale.getDefault(ULocale.Category.FORMAT).toLocale()));
    }

    public static final DateFormat getDateTimeInstance(int dateStyle, int timeStyle) {
        if (dateStyle != -1) {
            if (timeStyle != -1) {
                return new DateFormat(java.text.DateFormat.getDateTimeInstance(DateFormat.getJDKFormatStyle(dateStyle), DateFormat.getJDKFormatStyle(timeStyle), ULocale.getDefault(ULocale.Category.FORMAT).toLocale()));
            }
            return new DateFormat(java.text.DateFormat.getDateInstance(DateFormat.getJDKFormatStyle(dateStyle), ULocale.getDefault(ULocale.Category.FORMAT).toLocale()));
        }
        if (timeStyle != -1) {
            return new DateFormat(java.text.DateFormat.getTimeInstance(DateFormat.getJDKFormatStyle(timeStyle), ULocale.getDefault(ULocale.Category.FORMAT).toLocale()));
        }
        return null;
    }

    public static final DateFormat getDateTimeInstance(int dateStyle, int timeStyle, Locale aLocale) {
        if (dateStyle != -1) {
            if (timeStyle != -1) {
                return new DateFormat(java.text.DateFormat.getDateTimeInstance(DateFormat.getJDKFormatStyle(dateStyle), DateFormat.getJDKFormatStyle(timeStyle), aLocale));
            }
            return new DateFormat(java.text.DateFormat.getDateInstance(DateFormat.getJDKFormatStyle(dateStyle), aLocale));
        }
        if (timeStyle != -1) {
            return new DateFormat(java.text.DateFormat.getTimeInstance(DateFormat.getJDKFormatStyle(timeStyle), aLocale));
        }
        return null;
    }

    public static final DateFormat getDateTimeInstance(int dateStyle, int timeStyle, ULocale locale) {
        if (dateStyle != -1) {
            if (timeStyle != -1) {
                return new DateFormat(java.text.DateFormat.getDateTimeInstance(DateFormat.getJDKFormatStyle(dateStyle), DateFormat.getJDKFormatStyle(timeStyle), locale.toLocale()));
            }
            return new DateFormat(java.text.DateFormat.getDateInstance(DateFormat.getJDKFormatStyle(dateStyle), locale.toLocale()));
        }
        if (timeStyle != -1) {
            return new DateFormat(java.text.DateFormat.getTimeInstance(DateFormat.getJDKFormatStyle(timeStyle), locale.toLocale()));
        }
        return null;
    }

    public static final DateFormat getInstance() {
        return new DateFormat(java.text.DateFormat.getDateTimeInstance(3, 3, ULocale.getDefault(ULocale.Category.FORMAT).toLocale()));
    }

    public static Locale[] getAvailableLocales() {
        return java.text.DateFormat.getAvailableLocales();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ULocale[] getAvailableULocales() {
        if (availableULocales != null) return availableULocales;
        Class<DateFormat> clazz = DateFormat.class;
        synchronized (DateFormat.class) {
            if (availableULocales != null) return availableULocales;
            Locale[] locales = java.text.DateFormat.getAvailableLocales();
            availableULocales = new ULocale[locales.length];
            int i = 0;
            while (i < locales.length) {
                DateFormat.availableULocales[i] = ULocale.forLocale(locales[i]);
                ++i;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return availableULocales;
        }
    }

    public void setCalendar(Calendar newCalendar) {
        this.dateFormat.setCalendar(newCalendar.calendar);
    }

    public Calendar getCalendar() {
        return new Calendar(this.dateFormat.getCalendar());
    }

    public void setNumberFormat(NumberFormat newNumberFormat) {
        this.dateFormat.setNumberFormat(newNumberFormat.numberFormat);
    }

    public NumberFormat getNumberFormat() {
        return new NumberFormat(this.dateFormat.getNumberFormat());
    }

    public void setTimeZone(TimeZone zone) {
        this.dateFormat.setTimeZone(zone.timeZone);
    }

    public TimeZone getTimeZone() {
        return new TimeZone(this.dateFormat.getTimeZone());
    }

    public void setLenient(boolean lenient) {
        this.dateFormat.setLenient(lenient);
    }

    public boolean isLenient() {
        return this.dateFormat.isLenient();
    }

    public int hashCode() {
        return this.dateFormat.hashCode();
    }

    public boolean equals(Object obj) {
        try {
            return this.dateFormat.equals(((DateFormat)obj).dateFormat);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Object clone() {
        return new DateFormat((java.text.DateFormat)this.dateFormat.clone());
    }

    public static final DateFormat getDateInstance(Calendar cal, int dateStyle, Locale locale) {
        DateFormat df = DateFormat.getDateInstance(dateStyle, locale);
        df.setCalendar(cal);
        return df;
    }

    public static final DateFormat getDateInstance(Calendar cal, int dateStyle, ULocale locale) {
        DateFormat df = DateFormat.getDateInstance(dateStyle, locale);
        df.setCalendar(cal);
        return df;
    }

    public static final DateFormat getTimeInstance(Calendar cal, int timeStyle, Locale locale) {
        DateFormat df = DateFormat.getTimeInstance(timeStyle, locale);
        df.setCalendar(cal);
        return df;
    }

    public static final DateFormat getTimeInstance(Calendar cal, int timeStyle, ULocale locale) {
        DateFormat df = DateFormat.getTimeInstance(timeStyle, locale);
        df.setCalendar(cal);
        return df;
    }

    public static final DateFormat getDateTimeInstance(Calendar cal, int dateStyle, int timeStyle, Locale locale) {
        DateFormat df = DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale);
        df.setCalendar(cal);
        return df;
    }

    public static final DateFormat getDateTimeInstance(Calendar cal, int dateStyle, int timeStyle, ULocale locale) {
        DateFormat df = DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale);
        df.setCalendar(cal);
        return df;
    }

    public static final DateFormat getInstance(Calendar cal, Locale locale) {
        return DateFormat.getDateTimeInstance(cal, 2, 3, locale);
    }

    public static final DateFormat getInstance(Calendar cal, ULocale locale) {
        return DateFormat.getDateTimeInstance(cal, 2, 3, locale);
    }

    public static final DateFormat getInstance(Calendar cal) {
        return DateFormat.getInstance(cal, ULocale.getDefault(ULocale.Category.FORMAT));
    }

    public static final DateFormat getDateInstance(Calendar cal, int dateStyle) {
        return DateFormat.getDateInstance(cal, dateStyle, ULocale.getDefault(ULocale.Category.FORMAT));
    }

    public static final DateFormat getTimeInstance(Calendar cal, int timeStyle) {
        return DateFormat.getTimeInstance(cal, timeStyle, ULocale.getDefault(ULocale.Category.FORMAT));
    }

    public static final DateFormat getDateTimeInstance(Calendar cal, int dateStyle, int timeStyle) {
        return DateFormat.getDateTimeInstance(cal, dateStyle, timeStyle, ULocale.getDefault(ULocale.Category.FORMAT));
    }

    private static int getJDKFormatStyle(int icuFormatStyle) {
        switch (icuFormatStyle) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        throw new UnsupportedOperationException("Style not supported by com.ibm.icu.base");
    }

    protected static FieldPosition toJDKFieldPosition(FieldPosition icuPos) {
        if (icuPos == null) {
            return null;
        }
        int fieldID = icuPos.getField();
        Format.Field fieldAttribute = icuPos.getFieldAttribute();
        FieldPosition jdkPos = null;
        if (fieldID >= 0) {
            switch (fieldID) {
                case 0: {
                    fieldID = 0;
                    break;
                }
                case 1: {
                    fieldID = 1;
                    break;
                }
                case 2: {
                    fieldID = 2;
                    break;
                }
                case 3: {
                    fieldID = 3;
                    break;
                }
                case 4: {
                    fieldID = 4;
                    break;
                }
                case 5: {
                    fieldID = 5;
                    break;
                }
                case 6: {
                    fieldID = 6;
                    break;
                }
                case 7: {
                    fieldID = 7;
                    break;
                }
                case 8: {
                    fieldID = 8;
                    break;
                }
                case 9: {
                    fieldID = 9;
                    break;
                }
                case 10: {
                    fieldID = 10;
                    break;
                }
                case 11: {
                    fieldID = 11;
                    break;
                }
                case 12: {
                    fieldID = 12;
                    break;
                }
                case 13: {
                    fieldID = 13;
                    break;
                }
                case 14: {
                    fieldID = 14;
                    break;
                }
                case 15: {
                    fieldID = 15;
                    break;
                }
                case 16: {
                    fieldID = 16;
                    break;
                }
                case 17: {
                    fieldID = 17;
                    break;
                }
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    throw new UnsupportedOperationException("Format Field ID not supported by com.ibm.icu.base");
                }
            }
        }
        if (fieldAttribute != null) {
            if (fieldAttribute.equals(Field.AM_PM)) {
                fieldAttribute = DateFormat.Field.AM_PM;
            } else if (fieldAttribute.equals(Field.DAY_OF_MONTH)) {
                fieldAttribute = DateFormat.Field.DAY_OF_MONTH;
            } else if (fieldAttribute.equals(Field.DAY_OF_WEEK)) {
                fieldAttribute = DateFormat.Field.DAY_OF_WEEK;
            } else if (fieldAttribute.equals(Field.DAY_OF_WEEK_IN_MONTH)) {
                fieldAttribute = DateFormat.Field.DAY_OF_WEEK_IN_MONTH;
            } else if (fieldAttribute.equals(Field.DAY_OF_YEAR)) {
                fieldAttribute = DateFormat.Field.DAY_OF_YEAR;
            } else if (fieldAttribute.equals(Field.ERA)) {
                fieldAttribute = DateFormat.Field.ERA;
            } else if (fieldAttribute.equals(Field.HOUR_OF_DAY0)) {
                fieldAttribute = DateFormat.Field.HOUR_OF_DAY0;
            } else if (fieldAttribute.equals(Field.HOUR_OF_DAY1)) {
                fieldAttribute = DateFormat.Field.HOUR_OF_DAY1;
            } else if (fieldAttribute.equals(Field.HOUR0)) {
                fieldAttribute = DateFormat.Field.HOUR0;
            } else if (fieldAttribute.equals(Field.HOUR1)) {
                fieldAttribute = DateFormat.Field.HOUR1;
            } else if (fieldAttribute.equals(Field.MILLISECOND)) {
                fieldAttribute = DateFormat.Field.MILLISECOND;
            } else if (fieldAttribute.equals(Field.MINUTE)) {
                fieldAttribute = DateFormat.Field.MINUTE;
            } else if (fieldAttribute.equals(Field.MONTH)) {
                fieldAttribute = DateFormat.Field.MONTH;
            } else if (fieldAttribute.equals(Field.SECOND)) {
                fieldAttribute = DateFormat.Field.SECOND;
            } else if (fieldAttribute.equals(Field.TIME_ZONE)) {
                fieldAttribute = DateFormat.Field.TIME_ZONE;
            } else if (fieldAttribute.equals(Field.WEEK_OF_MONTH)) {
                fieldAttribute = DateFormat.Field.WEEK_OF_MONTH;
            } else if (fieldAttribute.equals(Field.WEEK_OF_YEAR)) {
                fieldAttribute = DateFormat.Field.WEEK_OF_YEAR;
            } else if (fieldAttribute.equals(Field.YEAR)) {
                fieldAttribute = DateFormat.Field.YEAR;
            }
            jdkPos = new FieldPosition(fieldAttribute, fieldID);
        } else {
            jdkPos = new FieldPosition(fieldID);
        }
        jdkPos.setBeginIndex(icuPos.getBeginIndex());
        jdkPos.setEndIndex(icuPos.getEndIndex());
        return jdkPos;
    }

    public static class Field
    extends Format.Field {
        private static final long serialVersionUID = -3627456821000730829L;
        private static final int CAL_FIELD_COUNT;
        private static final Field[] CAL_FIELDS;
        private static final Map<String, Field> FIELD_NAME_MAP;
        public static final Field AM_PM;
        public static final Field DAY_OF_MONTH;
        public static final Field DAY_OF_WEEK;
        public static final Field DAY_OF_WEEK_IN_MONTH;
        public static final Field DAY_OF_YEAR;
        public static final Field ERA;
        public static final Field HOUR_OF_DAY0;
        public static final Field HOUR_OF_DAY1;
        public static final Field HOUR0;
        public static final Field HOUR1;
        public static final Field MILLISECOND;
        public static final Field MINUTE;
        public static final Field MONTH;
        public static final Field SECOND;
        public static final Field TIME_ZONE;
        public static final Field WEEK_OF_MONTH;
        public static final Field WEEK_OF_YEAR;
        public static final Field YEAR;
        private final int calendarField;

        static {
            Calendar cal = Calendar.getInstance();
            CAL_FIELD_COUNT = cal.getFieldCount();
            CAL_FIELDS = new Field[CAL_FIELD_COUNT];
            FIELD_NAME_MAP = new HashMap<String, Field>(CAL_FIELD_COUNT);
            AM_PM = new Field("am pm", 9);
            DAY_OF_MONTH = new Field("day of month", 5);
            DAY_OF_WEEK = new Field("day of week", 7);
            DAY_OF_WEEK_IN_MONTH = new Field("day of week in month", 8);
            DAY_OF_YEAR = new Field("day of year", 6);
            ERA = new Field("era", 0);
            HOUR_OF_DAY0 = new Field("hour of day", 11);
            HOUR_OF_DAY1 = new Field("hour of day 1", -1);
            HOUR0 = new Field("hour", 10);
            HOUR1 = new Field("hour 1", -1);
            MILLISECOND = new Field("millisecond", 14);
            MINUTE = new Field("minute", 12);
            MONTH = new Field("month", 2);
            SECOND = new Field("second", 13);
            TIME_ZONE = new Field("time zone", -1);
            WEEK_OF_MONTH = new Field("week of month", 4);
            WEEK_OF_YEAR = new Field("week of year", 3);
            YEAR = new Field("year", 1);
        }

        protected Field(String name, int calendarField) {
            super(name);
            this.calendarField = calendarField;
            if (this.getClass() == Field.class) {
                FIELD_NAME_MAP.put(name, this);
                if (calendarField >= 0 && calendarField < CAL_FIELD_COUNT) {
                    Field.CAL_FIELDS[calendarField] = this;
                }
            }
        }

        public static Field ofCalendarField(int calendarField) {
            if (calendarField < 0 || calendarField >= CAL_FIELD_COUNT) {
                throw new IllegalArgumentException("Calendar field number is out of range");
            }
            return CAL_FIELDS[calendarField];
        }

        public int getCalendarField() {
            return this.calendarField;
        }

        protected Object readResolve() throws InvalidObjectException {
            if (this.getClass() != Field.class) {
                throw new InvalidObjectException("A subclass of DateFormat.Field must implement readResolve.");
            }
            Field o = FIELD_NAME_MAP.get(this.getName());
            if (o == null) {
                throw new InvalidObjectException("Unknown attribute name.");
            }
            return o;
        }
    }
}

