/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.workbenchintegration.QueryOptions;

import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class MemoryQueryTriggerIndirectionTest
extends AutoVerifyTestCase {
    protected ReadAllQuery queryAll;
    protected Vector allEmployees;
    protected Vector inMemoryResult;

    public MemoryQueryTriggerIndirectionTest() {
        this.setDescription("Test memory query trigger indirection option");
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.allEmployees = (Vector)this.getSession().executeQuery("memoryQueryTriggerIndirectionQuery", Employee.class);
        this.queryAll = (ReadAllQuery)this.getSession().getDescriptor(Employee.class).getQueryManager().getQuery("memoryQueryTriggerIndirectionQuery");
    }

    public void test() {
        ReadAllQuery queryAllCopy = (ReadAllQuery)this.queryAll.clone();
        queryAllCopy.checkCacheOnly();
        queryAllCopy.setSelectionCriteria(new ExpressionBuilder().get("address").get("city").notEqual((Object)"Montreal"));
        this.inMemoryResult = (Vector)this.getSession().executeQuery((DatabaseQuery)queryAllCopy);
    }

    public void verify() {
        if (this.inMemoryResult.size() != this.allEmployees.size() - 1) {
            throw new TestErrorException("In Memory Query did not return all objects.  Auto-indirection triggering is not working");
        }
    }
}

