/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.workbenchintegration;

import java.io.FileReader;
import java.io.LineNumberReader;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.factories.ProjectClassGenerator;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class ProjectClassGeneratorResultFileTest
extends AutoVerifyTestCase {
    protected Exception generationException = null;
    protected Exception fileReadException = null;
    protected String testString = null;
    protected Project project = null;
    protected ProjectClassGenerator generator = null;
    protected String fileName = null;

    public ProjectClassGeneratorResultFileTest(Project project) {
        this.project = project;
    }

    public ProjectClassGeneratorResultFileTest(Project project, String testString) {
        this.project = project;
        this.testString = testString;
    }

    public void test() {
        try {
            ProjectClassGenerator generator = new ProjectClassGenerator(this.project);
            generator.generate();
            this.fileName = generator.getOutputFileName();
        }
        catch (Exception exception) {
            this.generationException = exception;
        }
    }

    public void verify() {
        if (this.generationException != null) {
            throw new TestErrorException("Exception thrown while generating Java source. ", (Throwable)this.generationException);
        }
        if (!this.findStringInFile(this.testString, this.fileName)) {
            String exceptionString = "String: " + this.testString + " not found in " + this.fileName + ". This string should be generated by the ProjectClassGenerator.";
            if (this.fileReadException != null) {
                exceptionString = exceptionString + " Exception thrown while reading file. - " + this.fileReadException.toString();
            }
            throw new TestErrorException(exceptionString, (Throwable)this.fileReadException);
        }
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public boolean findStringInFile(String string, String fileName) {
        try {
            FileReader reader = new FileReader(fileName);
            LineNumberReader lnr = new LineNumberReader(reader);
            String line = lnr.readLine();
            while (line != null) {
                if (line.indexOf(string) > -1) {
                    return true;
                }
                line = lnr.readLine();
            }
        }
        catch (Exception exception) {
            this.fileReadException = exception;
        }
        return false;
    }
}

