/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.models.employee.interfaces.SmallProject;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class ClassIndicatorFieldNotFoundTest
extends ExceptionTest {
    ClassDescriptor orgDescriptor;
    IntegrityChecker orgIntegrityChecker;

    public ClassIndicatorFieldNotFoundTest() {
        this.setDescription("This tests Class Indicator Field Not Found (TL-ERROR 08) ");
    }

    protected void setup() {
        this.expectedException = DescriptorException.classIndicatorFieldNotFound(null, null);
        this.orgDescriptor = this.getSession().getDescriptor(org.eclipse.persistence.testing.models.employee.domain.SmallProject.class);
        this.orgIntegrityChecker = this.getSession().getIntegrityChecker();
    }

    @Override
    public void reset() {
        this.getSession().getDescriptors().remove(org.eclipse.persistence.testing.models.employee.domain.SmallProject.class);
        if (this.orgDescriptor != null) {
            ((DatabaseSession)this.getSession()).addDescriptor(this.orgDescriptor);
        }
        if (this.orgIntegrityChecker != null) {
            this.getSession().setIntegrityChecker(this.orgIntegrityChecker);
        }
    }

    public void test() {
        try {
            this.getSession().setIntegrityChecker(new IntegrityChecker());
            this.getSession().getIntegrityChecker().dontCatchExceptions();
            ((DatabaseSession)this.getSession()).addDescriptor((ClassDescriptor)this.descriptor());
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }

    public RelationalDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.employee.domain.SmallProject.class);
        descriptor.addTableName("PROJECT");
        descriptor.addPrimaryKeyFieldName("PROJECT.PROJ_ID");
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("PROJECT.PROJ_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        descriptor.getInheritancePolicy().dontReadSubclassesOnQueries();
        descriptor.getInterfacePolicy().addParentInterface(SmallProject.class);
        descriptor.getQueryManager().checkCacheForDoesExist();
        return descriptor;
    }
}

