/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork.changeflag;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.indirection.IndirectContainer;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.models.relationshipmaintenance.FieldOffice;
import org.eclipse.persistence.testing.models.relationshipmaintenance.SalesPerson;

public class TransparentIndirectionAddRemoveTest
extends TransactionalTestCase {
    private Boolean lazyInstantiationForSalesPeople = null;

    public TransparentIndirectionAddRemoveTest() {
        this.setDescription("Test the add/remove optimization of indirect collections with change tracking.");
    }

    public void setup() {
        CollectionMapping mapping = (CollectionMapping)this.getSession().getClassDescriptor(FieldOffice.class).getMappingForAttributeName("salespeople");
        this.lazyInstantiationForSalesPeople = mapping.shouldUseLazyInstantiationForIndirectCollection();
        mapping.setUseLazyInstantiationForIndirectCollection(Boolean.valueOf(true));
    }

    public void test() {
        this.testAddRemove();
        this.testSetUnset();
    }

    public void testAddRemove() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        FieldOffice office = (FieldOffice)uow.readObject(FieldOffice.class, new ExpressionBuilder().get("location").get("city").equal((Object)"Toronto"));
        SalesPerson person = new SalesPerson();
        person.setName("Bob");
        person.setFieldOffice(office);
        office.getSalespeople().add(person);
        uow.commit();
        if (((IndirectContainer)office.getSalespeople()).isInstantiated()) {
            this.throwError("Sales people indirect collection should not be instantiated on add.");
        }
        if (!office.getSalespeople().contains(person)) {
            this.throwError("Person not added in clone.");
        }
        office = (FieldOffice)this.getSession().readObject((Object)office);
        person = (SalesPerson)this.getSession().readObject((Object)person);
        if (!office.getSalespeople().contains(person)) {
            this.throwError("Person not added in cache.");
        }
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        uow = this.getSession().acquireUnitOfWork();
        office = (FieldOffice)uow.readObject((Object)office);
        person = (SalesPerson)uow.readObject((Object)person);
        office.getSalespeople().remove(person);
        uow.commit();
        if (((IndirectContainer)office.getSalespeople()).isInstantiated()) {
            this.throwError("Sales people indirect collection should not be instantiated on remove.");
        }
        if (office.getSalespeople().contains(person)) {
            this.throwError("Person not removed in clone.");
        }
        office = (FieldOffice)this.getSession().readObject((Object)office);
        person = (SalesPerson)this.getSession().readObject((Object)person);
        if (office.getSalespeople().contains(person)) {
            this.throwError("Person not removed in cache.");
        }
    }

    public void testSetUnset() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        FieldOffice office = (FieldOffice)uow.readObject(FieldOffice.class, new ExpressionBuilder().get("location").get("city").equal((Object)"Toronto"));
        SalesPerson person = new SalesPerson();
        person.setName("Bob");
        person = (SalesPerson)uow.registerObject((Object)person);
        person.setFieldOffice(office);
        uow.commit();
        if (((IndirectContainer)office.getSalespeople()).isInstantiated()) {
            this.throwError("Sales people indirect collection should not be instantiated on add.");
        }
        if (!office.getSalespeople().contains(person)) {
            this.throwError("Person not added in clone.");
        }
        office = (FieldOffice)this.getSession().readObject((Object)office);
        person = (SalesPerson)this.getSession().readObject((Object)person);
        if (!office.getSalespeople().contains(person)) {
            this.throwError("Person not added in cache.");
        }
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        uow = this.getSession().acquireUnitOfWork();
        office = (FieldOffice)uow.readObject((Object)office);
        person = (SalesPerson)uow.readObject((Object)person);
        person.setFieldOffice(null);
        uow.commit();
        if (((IndirectContainer)office.getSalespeople()).isInstantiated()) {
            this.throwError("Sales people indirect collection should not be instantiated on remove.");
        }
        if (office.getSalespeople().contains(person)) {
            this.throwError("Person not removed in clone.");
        }
        office = (FieldOffice)this.getSession().readObject((Object)office);
        person = (SalesPerson)this.getSession().readObject((Object)person);
        if (office.getSalespeople().contains(person)) {
            this.throwError("Person not removed in cache.");
        }
    }

    public void reset() {
        CollectionMapping mapping = (CollectionMapping)this.getSession().getClassDescriptor(FieldOffice.class).getMappingForAttributeName("salespeople");
        mapping.setUseLazyInstantiationForIndirectCollection(this.lazyInstantiationForSalesPeople);
    }
}

