/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.transparentindirection;

import java.util.Enumeration;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.indirection.IndirectContainer;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.models.transparentindirection.AbstractOrder;
import org.eclipse.persistence.testing.models.transparentindirection.AbstractOrderLine;
import org.eclipse.persistence.testing.models.transparentindirection.AbstractSalesRep;
import org.eclipse.persistence.testing.models.transparentindirection.Order;
import org.eclipse.persistence.testing.models.transparentindirection.OrderLine;
import org.eclipse.persistence.testing.models.transparentindirection.SalesRep;
import org.eclipse.persistence.testing.tests.transparentindirection.ZTestCase;

public class IndirectContainerTestDatabase
extends ZTestCase {
    int originalID;

    public IndirectContainerTestDatabase(String name) {
        super(name);
    }

    protected AbstractOrder buildOrderShell() {
        return new Order();
    }

    protected String buildTestContact1() {
        return "Freddy";
    }

    protected String buildTestContact2() {
        return "Richard";
    }

    protected AbstractOrder buildTestOrder1() {
        AbstractOrder order = this.buildTestOrderShell("Tommy 2Tone");
        order.addSalesRep(this.newSalesRep("Slippery Sam"));
        order.addSalesRep(this.newSalesRep("Slippery Sam's Brother"));
        order.addSalesRep(this.newSalesRep("Slippery Samantha"));
        order.addSalesRep2(this.newSalesRep("Edgar"));
        order.addSalesRep2(this.newSalesRep("Rick"));
        order.addSalesRep2(this.newSalesRep("Dan"));
        order.addSalesRep2(this.newSalesRep("Johnny"));
        order.addContact("Tommy");
        order.addContact("Pato");
        order.addContact("Ranking Roger");
        order.addContact2("Jimmy");
        order.addContact2("Robert");
        order.addContact2("John");
        order.addContact2("Keith");
        order.addLine(this.newOrderLine("Specials", 1));
        order.addLine(this.newOrderLine("General Public", 3));
        order.addLine(this.newOrderLine("Madness", 1));
        order.setTotal(765);
        order.total2 = 987;
        return order;
    }

    protected AbstractOrder buildTestOrder2() {
        AbstractOrder order = this.buildTestOrderShell("Ferdinand Fox");
        order.addSalesRep(this.newSalesRep("Tricky Dick"));
        order.addSalesRep(this.newSalesRep("Shady Shakeem"));
        order.addSalesRep2(this.newSalesRep("John"));
        order.addSalesRep2(this.newSalesRep("Paul"));
        order.addSalesRep2(this.newSalesRep("George"));
        order.addSalesRep2(this.newSalesRep("Ringo"));
        order.addContact("Ferdy");
        order.addContact("Franny");
        order.addContact2("Gene");
        order.addContact2("Paul");
        order.addContact2("Ace");
        order.addContact2("Peter");
        order.addLine(this.newOrderLine("Squirrel Feeder", 3));
        order.addLine(this.newOrderLine("Squirrel Trap", 6));
        order.addLine(this.newOrderLine("Squirrel Cookbook", 1));
        order.setTotal(1234);
        order.total2 = 7890;
        return order;
    }

    protected AbstractOrder buildTestOrder3() {
        AbstractOrder order = this.buildTestOrderShell("Conform Test");
        order.addSalesRep(this.newSalesRep("Tom"));
        order.addSalesRep2(this.newSalesRep("Mark"));
        order.addContact("Jason");
        order.addContact2("Guy");
        order.addLine(this.newOrderLine(null, 1));
        order.setTotal(3456);
        order.total2 = 5678;
        return order;
    }

    protected AbstractOrderLine buildTestOrderLine1() {
        return this.newOrderLine("Spice Girls", 5);
    }

    protected AbstractOrder buildTestOrderShell(String customerName) {
        return new Order(customerName);
    }

    protected AbstractOrderLine newOrderLine(String item, int quanity) {
        return new OrderLine(item, quanity);
    }

    protected AbstractSalesRep newSalesRep(String name) {
        return new SalesRep(name);
    }

    protected AbstractSalesRep buildTestSalesRep1() {
        return this.newSalesRep("Sales Weasel");
    }

    protected AbstractSalesRep buildTestSalesRep2() {
        return this.newSalesRep("Uncle Ernie");
    }

    protected void compareOrders(AbstractOrder expected, AbstractOrder actual) {
        IndirectContainerTestDatabase.assertEquals((String)"The customer name is incorrect.", (String)expected.customerName, (String)actual.customerName);
        IndirectContainerTestDatabase.assertTrue((String)"The sales reps should NOT be populated yet.", (!((IndirectContainer)actual.getSalesRepContainer()).isInstantiated() ? 1 : 0) != 0);
        IndirectContainerTestDatabase.assertEquals((String)"The number of sales reps is incorrect.", (int)expected.getNumberOfSalesReps(), (int)actual.getNumberOfSalesReps());
        IndirectContainerTestDatabase.assertTrue((String)"The sales reps should be populated.", (boolean)((IndirectContainer)actual.getSalesRepContainer()).isInstantiated());
        IndirectContainerTestDatabase.assertUnorderedElementsEqual("The sales reps are not correct.", expected.getSalesRepVector(), actual.getSalesRepVector());
        IndirectContainerTestDatabase.assertTrue((String)"The contacts should NOT be populated.", (!((IndirectContainer)actual.getContactContainer()).isInstantiated() ? 1 : 0) != 0);
        IndirectContainerTestDatabase.assertEquals((String)"Number of contacts is incorrect.", (int)expected.getNumberOfContacts(), (int)actual.getNumberOfContacts());
        IndirectContainerTestDatabase.assertTrue((String)"The contacts should be populated.", (boolean)((IndirectContainer)actual.getContactContainer()).isInstantiated());
        IndirectContainerTestDatabase.assertUnorderedElementsEqual("The contacts are not correct.", expected.getContactVector(), actual.getContactVector());
        IndirectContainerTestDatabase.assertTrue((String)"The order lines should NOT be populated yet.", (!((IndirectContainer)actual.getLineContainer()).isInstantiated() ? 1 : 0) != 0);
        IndirectContainerTestDatabase.assertEquals((String)"The number of order lines is incorrect.", (int)expected.getNumberOfLines(), (int)actual.getNumberOfLines());
        IndirectContainerTestDatabase.assertTrue((String)"The order lines should be populated.", (boolean)((IndirectContainer)actual.getLineContainer()).isInstantiated());
        IndirectContainerTestDatabase.assertUnorderedElementsEqual("The order lines are not correct.", expected.getLineVector(), actual.getLineVector());
        IndirectContainerTestDatabase.assertEquals((String)"Number of contacts2 is incorrect.", (int)expected.getNumberOfContacts2(), (int)actual.getNumberOfContacts2());
        IndirectContainerTestDatabase.assertUnorderedElementsEqual("The contacts2 are not correct.", expected.getContactVector2(), actual.getContactVector2());
        IndirectContainerTestDatabase.assertEquals((String)"The number of sales reps 2 is incorrect.", (int)expected.getNumberOfSalesReps2(), (int)actual.getNumberOfSalesReps2());
        IndirectContainerTestDatabase.assertUnorderedElementsEqual("The sales reps 2 are not correct.", expected.getSalesRepVector2(), actual.getSalesRepVector2());
        IndirectContainerTestDatabase.assertTrue((String)"The total should NOT be instantiated yet.", (!actual.total.isInstantiated() ? 1 : 0) != 0);
        IndirectContainerTestDatabase.assertEquals((String)"The total is incorrect.", (int)expected.getTotal(), (int)actual.getTotal());
        IndirectContainerTestDatabase.assertTrue((String)"The total should be instantiated.", (boolean)actual.total.isInstantiated());
        IndirectContainerTestDatabase.assertEquals((String)"The total 2 is incorrect.", (int)expected.total2, (int)actual.total2);
    }

    protected Session getBackdoorSession() {
        return this.getSession();
    }

    public static void modifyOrderDescriptor(RelationalDescriptor d) {
        ((CollectionMapping)d.getMappingForAttributeName("salesReps")).useTransparentCollection();
        ((CollectionMapping)d.getMappingForAttributeName("contacts")).useTransparentCollection();
        ((CollectionMapping)d.getMappingForAttributeName("lines")).useTransparentCollection();
    }

    protected AbstractOrder readOrder(AbstractOrder key) {
        return (AbstractOrder)this.getSession().readObject((Object)key);
    }

    @Override
    protected void setUp() {
        super.setUp();
        AbstractOrder order = this.buildTestOrder1();
        this.writeNewOrder(order);
        this.originalID = order.id;
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    @Override
    protected void tearDown() {
        super.tearDown();
    }

    public void testReadAndWriteObject() {
        AbstractOrder key = this.buildOrderShell();
        key.id = this.originalID;
        AbstractOrder orderFromDB = this.readOrder(key);
        orderFromDB.customerName = "DoubleTake";
        this.updateOrder(orderFromDB);
        this.compareOrders(orderFromDB, orderFromDB);
    }

    public void testRefreshNewObject() {
        AbstractOrder originalOrder = this.buildTestOrder2();
        this.writeNewOrder(originalOrder);
        originalOrder = (AbstractOrder)this.getSession().readObject((Object)originalOrder);
        AbstractOrderLine orderLine = (AbstractOrderLine)((AbstractOrderLine)originalOrder.getLineStream().nextElement()).clone();
        orderLine.itemName = "munged";
        this.getBackdoorSession().executeNonSelectingSQL("update ORDLINE set ITEM_NAME = '" + orderLine.itemName + "' where ID = " + orderLine.id);
        AbstractOrder orderFromDB = (AbstractOrder)this.getSession().refreshObject((Object)originalOrder);
        IndirectContainerTestDatabase.assertTrue((String)"The order lines should NOT be populated.", (!((IndirectContainer)orderFromDB.getLineContainer()).isInstantiated() ? 1 : 0) != 0);
        IndirectContainerTestDatabase.assertTrue((String)"New order line not found.", (boolean)orderFromDB.containsLine(orderLine));
        IndirectContainerTestDatabase.assertTrue((String)"The order lines should be populated.", (boolean)((IndirectContainer)orderFromDB.getLineContainer()).isInstantiated());
        IndirectContainerTestDatabase.assertTrue((String)"The total should NOT be instantiated yet.", (!orderFromDB.total.isInstantiated() ? 1 : 0) != 0);
        IndirectContainerTestDatabase.assertEquals((String)"The total is incorrect.", (int)this.buildTestOrder2().getTotal(), (int)orderFromDB.getTotal());
        IndirectContainerTestDatabase.assertTrue((String)"The total should be instantiated.", (boolean)orderFromDB.total.isInstantiated());
        IndirectContainerTestDatabase.assertEquals((String)"The total 2 is incorrect.", (int)this.buildTestOrder2().total2, (int)orderFromDB.total2);
    }

    public void testRefreshObject() {
        AbstractOrder key = this.buildOrderShell();
        key.id = this.originalID;
        AbstractOrder orderFromDB = (AbstractOrder)this.getSession().readObject((Object)key);
        IndirectContainerTestDatabase.assertTrue((String)"The order lines should NOT be populated.", (!((IndirectContainer)orderFromDB.getLineContainer()).isInstantiated() ? 1 : 0) != 0);
        AbstractOrderLine orderLine = (AbstractOrderLine)orderFromDB.getLineStream().nextElement();
        IndirectContainerTestDatabase.assertTrue((String)"The order lines should be populated.", (boolean)((IndirectContainer)orderFromDB.getLineContainer()).isInstantiated());
        AbstractOrder expected = this.buildTestOrder1();
        IndirectContainerTestDatabase.assertTrue((String)"The total should NOT be instantiated yet.", (!orderFromDB.total.isInstantiated() ? 1 : 0) != 0);
        IndirectContainerTestDatabase.assertEquals((String)"The total is incorrect.", (int)expected.getTotal(), (int)orderFromDB.getTotal());
        IndirectContainerTestDatabase.assertTrue((String)"The total should be instantiated.", (boolean)orderFromDB.total.isInstantiated());
        IndirectContainerTestDatabase.assertEquals((String)"The total 2 is incorrect.", (int)expected.total2, (int)orderFromDB.total2);
        orderLine = (AbstractOrderLine)orderLine.clone();
        orderLine.itemName = "munged";
        this.getBackdoorSession().executeNonSelectingSQL("update ORDLINE set ITEM_NAME = '" + orderLine.itemName + "' where ID = " + orderLine.id);
        orderFromDB = (AbstractOrder)this.getSession().refreshObject((Object)orderFromDB);
        IndirectContainerTestDatabase.assertTrue((String)"The order lines should NOT be populated.", (!((IndirectContainer)orderFromDB.getLineContainer()).isInstantiated() ? 1 : 0) != 0);
        IndirectContainerTestDatabase.assertTrue((String)"New order line not found.", (boolean)orderFromDB.containsLine(orderLine));
        IndirectContainerTestDatabase.assertTrue((String)"The order lines should be populated.", (boolean)((IndirectContainer)orderFromDB.getLineContainer()).isInstantiated());
        IndirectContainerTestDatabase.assertTrue((String)"The total should NOT be instantiated yet.", (!orderFromDB.total.isInstantiated() ? 1 : 0) != 0);
        IndirectContainerTestDatabase.assertEquals((String)"The total is incorrect.", (int)expected.getTotal(), (int)orderFromDB.getTotal());
        IndirectContainerTestDatabase.assertTrue((String)"The total should be instantiated.", (boolean)orderFromDB.total.isInstantiated());
        IndirectContainerTestDatabase.assertEquals((String)"The total 2 is incorrect.", (int)expected.total2, (int)orderFromDB.total2);
    }

    public void testUOWAddContact() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        AbstractOrder key = this.buildOrderShell();
        key.id = this.originalID;
        AbstractOrder orderFromDB = (AbstractOrder)uow.readObject((Object)key);
        String contact = this.buildTestContact1();
        orderFromDB.addContact(contact);
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        orderFromDB = (AbstractOrder)this.getSession().readObject((Object)key);
        IndirectContainerTestDatabase.assertTrue((String)"The contacts should NOT be populated.", (!((IndirectContainer)orderFromDB.getContactContainer()).isInstantiated() ? 1 : 0) != 0);
        IndirectContainerTestDatabase.assertEquals((String)"The number of contacts is incorrect.", (int)(this.buildTestOrder1().getNumberOfContacts() + 1), (int)orderFromDB.getNumberOfContacts());
        IndirectContainerTestDatabase.assertTrue((String)"New contact not found.", (boolean)orderFromDB.containsContact(contact));
    }

    public void testUOWAddContact2() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        AbstractOrder key = this.buildOrderShell();
        key.id = this.originalID;
        AbstractOrder orderFromDB = (AbstractOrder)uow.readObject((Object)key);
        String contact = this.buildTestContact2();
        orderFromDB.addContact2(contact);
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        orderFromDB = (AbstractOrder)this.getSession().readObject((Object)key);
        IndirectContainerTestDatabase.assertEquals((String)"The number of contacts2 is incorrect.", (int)(this.buildTestOrder1().getNumberOfContacts2() + 1), (int)orderFromDB.getNumberOfContacts2());
        IndirectContainerTestDatabase.assertTrue((String)"New contact2 not found.", (boolean)orderFromDB.containsContact2(contact));
    }

    public void testUOWAddLine() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        AbstractOrder key = this.buildOrderShell();
        key.id = this.originalID;
        AbstractOrder orderFromDB = (AbstractOrder)uow.readObject((Object)key);
        AbstractOrderLine orderLine = this.buildTestOrderLine1();
        orderFromDB.addLine(orderLine);
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        orderFromDB = (AbstractOrder)this.getSession().readObject((Object)key);
        IndirectContainerTestDatabase.assertTrue((String)"The order lines should NOT be populated.", (!((IndirectContainer)orderFromDB.getLineContainer()).isInstantiated() ? 1 : 0) != 0);
        IndirectContainerTestDatabase.assertEquals((String)"The number of order lines is incorrect.", (int)(this.buildTestOrder1().getNumberOfLines() + 1), (int)orderFromDB.getNumberOfLines());
        IndirectContainerTestDatabase.assertTrue((String)"New order line not found.", (boolean)orderFromDB.containsLine(orderLine));
    }

    public void testUOWAddSalesRep() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        AbstractOrder key = this.buildOrderShell();
        key.id = this.originalID;
        AbstractOrder orderFromDB = (AbstractOrder)uow.readObject((Object)key);
        AbstractSalesRep salesRep = this.buildTestSalesRep1();
        orderFromDB.addSalesRep(salesRep);
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        orderFromDB = (AbstractOrder)this.getSession().readObject((Object)key);
        IndirectContainerTestDatabase.assertTrue((String)"The sales reps should NOT be populated.", (!((IndirectContainer)orderFromDB.getSalesRepContainer()).isInstantiated() ? 1 : 0) != 0);
        IndirectContainerTestDatabase.assertEquals((String)"The number of sales reps is incorrect.", (int)(this.buildTestOrder1().getNumberOfSalesReps() + 1), (int)orderFromDB.getNumberOfSalesReps());
        IndirectContainerTestDatabase.assertTrue((String)"New sales rep not found.", (boolean)orderFromDB.containsSalesRep(salesRep));
    }

    public void testUOWAddSalesRep2() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        AbstractOrder key = this.buildOrderShell();
        key.id = this.originalID;
        AbstractOrder orderFromDB = (AbstractOrder)uow.readObject((Object)key);
        AbstractSalesRep salesRep = this.buildTestSalesRep2();
        orderFromDB.addSalesRep2(salesRep);
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        orderFromDB = (AbstractOrder)this.getSession().readObject((Object)key);
        IndirectContainerTestDatabase.assertEquals((String)"The number of sales reps 2 is incorrect.", (int)(this.buildTestOrder1().getNumberOfSalesReps2() + 1), (int)orderFromDB.getNumberOfSalesReps2());
        IndirectContainerTestDatabase.assertTrue((String)"New sales rep 2 not found.", (boolean)orderFromDB.containsSalesRep2(salesRep));
    }

    public void testUOWChangeTotal() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        AbstractOrder key = this.buildOrderShell();
        key.id = this.originalID;
        AbstractOrder orderFromDB = (AbstractOrder)uow.readObject((Object)key);
        int newTotal = 1111;
        orderFromDB.setTotal(newTotal);
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        orderFromDB = (AbstractOrder)this.getSession().readObject((Object)key);
        IndirectContainerTestDatabase.assertTrue((String)"The total should NOT be instantiated.", (!orderFromDB.total.isInstantiated() ? 1 : 0) != 0);
        IndirectContainerTestDatabase.assertEquals((String)"The total is incorrect.", (int)newTotal, (int)orderFromDB.getTotal());
        IndirectContainerTestDatabase.assertTrue((String)"The total should be instantiated.", (boolean)orderFromDB.total.isInstantiated());
    }

    public void testUOWChangeTotal2() {
        int newTotal2;
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        AbstractOrder key = this.buildOrderShell();
        key.id = this.originalID;
        AbstractOrder orderFromDB = (AbstractOrder)uow.readObject((Object)key);
        orderFromDB.total2 = newTotal2 = 2222;
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        orderFromDB = (AbstractOrder)this.getSession().readObject((Object)key);
        IndirectContainerTestDatabase.assertEquals((String)"The total 2 is incorrect.", (int)newTotal2, (int)orderFromDB.total2);
    }

    public void testUOWNewObject() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        AbstractOrder originalOrder = this.buildTestOrder2();
        uow.registerObject((Object)originalOrder);
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        AbstractOrder key = this.buildOrderShell();
        key.id = originalOrder.id;
        AbstractOrder orderFromDB = (AbstractOrder)this.getSession().readObject((Object)key);
        this.compareOrders(originalOrder, orderFromDB);
    }

    public void testUOWRemoveContact() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        AbstractOrder key = this.buildOrderShell();
        key.id = this.originalID;
        AbstractOrder orderFromDB = (AbstractOrder)uow.readObject((Object)key);
        String contact = (String)orderFromDB.getContactStream().nextElement();
        orderFromDB.removeContact(contact);
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        orderFromDB = (AbstractOrder)this.getSession().readObject((Object)key);
        IndirectContainerTestDatabase.assertTrue((String)"The contacts should NOT be populated.", (!((IndirectContainer)orderFromDB.getContactContainer()).isInstantiated() ? 1 : 0) != 0);
        IndirectContainerTestDatabase.assertEquals((String)"The number of contacts is incorrect.", (int)(this.buildTestOrder1().getNumberOfContacts() - 1), (int)orderFromDB.getNumberOfContacts());
        IndirectContainerTestDatabase.assertTrue((String)"Removed contact still present.", (!orderFromDB.containsContact(contact) ? 1 : 0) != 0);
    }

    public void testUOWRemoveContact2() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        AbstractOrder key = this.buildOrderShell();
        key.id = this.originalID;
        AbstractOrder orderFromDB = (AbstractOrder)uow.readObject((Object)key);
        String contact = (String)orderFromDB.getContactStream2().nextElement();
        orderFromDB.removeContact2(contact);
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        orderFromDB = (AbstractOrder)this.getSession().readObject((Object)key);
        IndirectContainerTestDatabase.assertEquals((String)"The number of contacts2 is incorrect.", (int)(this.buildTestOrder1().getNumberOfContacts2() - 1), (int)orderFromDB.getNumberOfContacts2());
        IndirectContainerTestDatabase.assertTrue((String)"Removed contact2 still present.", (!orderFromDB.containsContact2(contact) ? 1 : 0) != 0);
    }

    public void testUOWRemoveLine() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        AbstractOrder key = this.buildOrderShell();
        key.id = this.originalID;
        AbstractOrder orderFromDB = (AbstractOrder)uow.readObject((Object)key);
        AbstractOrderLine orderLine = (AbstractOrderLine)orderFromDB.getLineStream().nextElement();
        orderFromDB.removeLine(orderLine);
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        orderFromDB = (AbstractOrder)this.getSession().readObject((Object)key);
        IndirectContainerTestDatabase.assertTrue((String)"The order lines should NOT be populated.", (!((IndirectContainer)orderFromDB.getLineContainer()).isInstantiated() ? 1 : 0) != 0);
        IndirectContainerTestDatabase.assertEquals((String)"The number of order lines is incorrect.", (int)(this.buildTestOrder1().getNumberOfLines() - 1), (int)orderFromDB.getNumberOfLines());
        IndirectContainerTestDatabase.assertTrue((String)"Removed order line still present.", (!orderFromDB.containsLine(orderLine) ? 1 : 0) != 0);
    }

    public void testUOWRemoveSalesRep() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        AbstractOrder key = this.buildOrderShell();
        key.id = this.originalID;
        AbstractOrder orderFromDB = (AbstractOrder)uow.readObject((Object)key);
        AbstractSalesRep salesRep = (AbstractSalesRep)orderFromDB.getSalesRepStream().nextElement();
        orderFromDB.removeSalesRep(salesRep);
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        orderFromDB = (AbstractOrder)this.getSession().readObject((Object)key);
        IndirectContainerTestDatabase.assertTrue((String)"The sales reps should NOT be populated.", (!((IndirectContainer)orderFromDB.getSalesRepContainer()).isInstantiated() ? 1 : 0) != 0);
        IndirectContainerTestDatabase.assertEquals((String)"The number of sales reps is incorrect.", (int)(this.buildTestOrder1().getNumberOfSalesReps() - 1), (int)orderFromDB.getNumberOfSalesReps());
        IndirectContainerTestDatabase.assertTrue((String)"Removed sales rep still present.", (!orderFromDB.containsSalesRep(salesRep) ? 1 : 0) != 0);
    }

    public void testUOWRemoveSalesRep2() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        AbstractOrder key = this.buildOrderShell();
        key.id = this.originalID;
        AbstractOrder orderFromDB = (AbstractOrder)uow.readObject((Object)key);
        AbstractSalesRep salesRep = (AbstractSalesRep)orderFromDB.getSalesRepStream2().nextElement();
        orderFromDB.removeSalesRep2(salesRep);
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        orderFromDB = (AbstractOrder)this.getSession().readObject((Object)key);
        IndirectContainerTestDatabase.assertEquals((String)"The number of sales reps 2 is incorrect.", (int)(this.buildTestOrder1().getNumberOfSalesReps2() - 1), (int)orderFromDB.getNumberOfSalesReps2());
        IndirectContainerTestDatabase.assertTrue((String)"Removed sales rep 2 still present.", (!orderFromDB.containsSalesRep2(salesRep) ? 1 : 0) != 0);
    }

    public void testUOWUnchanged() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        AbstractOrder key = this.buildOrderShell();
        key.id = this.originalID;
        AbstractOrder orderFromDB = (AbstractOrder)uow.readObject((Object)key);
        IndirectContainerTestDatabase.assertTrue((String)"The sales reps should NOT be populated.", (!((IndirectContainer)orderFromDB.getSalesRepContainer()).isInstantiated() ? 1 : 0) != 0);
        IndirectContainerTestDatabase.assertTrue((String)"The order lines should NOT be populated.", (!((IndirectContainer)orderFromDB.getLineContainer()).isInstantiated() ? 1 : 0) != 0);
        IndirectContainerTestDatabase.assertTrue((String)"The contacts should NOT be populated.", (!((IndirectContainer)orderFromDB.getContactContainer()).isInstantiated() ? 1 : 0) != 0);
        uow.commit();
        IndirectContainerTestDatabase.assertTrue((String)"The sales reps should NOT be populated.", (!((IndirectContainer)orderFromDB.getSalesRepContainer()).isInstantiated() ? 1 : 0) != 0);
        IndirectContainerTestDatabase.assertEquals((String)"The number of sales reps is incorrect.", (int)this.buildTestOrder1().getNumberOfSalesReps(), (int)orderFromDB.getNumberOfSalesReps());
        IndirectContainerTestDatabase.assertTrue((String)"The sales reps should be populated.", (boolean)((IndirectContainer)orderFromDB.getSalesRepContainer()).isInstantiated());
        IndirectContainerTestDatabase.assertTrue((String)"The contacts should NOT be populated.", (!((IndirectContainer)orderFromDB.getContactContainer()).isInstantiated() ? 1 : 0) != 0);
        IndirectContainerTestDatabase.assertEquals((String)"The number of contacts is incorrect.", (int)this.buildTestOrder1().getNumberOfContacts(), (int)orderFromDB.getNumberOfContacts());
        IndirectContainerTestDatabase.assertTrue((String)"The contacts should be populated.", (boolean)((IndirectContainer)orderFromDB.getContactContainer()).isInstantiated());
        IndirectContainerTestDatabase.assertTrue((String)"The order lines should NOT be populated.", (!((IndirectContainer)orderFromDB.getLineContainer()).isInstantiated() ? 1 : 0) != 0);
        IndirectContainerTestDatabase.assertEquals((String)"The number of order lines is incorrect.", (int)this.buildTestOrder1().getNumberOfLines(), (int)orderFromDB.getNumberOfLines());
        IndirectContainerTestDatabase.assertTrue((String)"The order lines should be populated.", (boolean)((IndirectContainer)orderFromDB.getLineContainer()).isInstantiated());
        IndirectContainerTestDatabase.assertEquals((String)"The number of contacts2 is incorrect.", (int)this.buildTestOrder1().getNumberOfContacts2(), (int)orderFromDB.getNumberOfContacts2());
        IndirectContainerTestDatabase.assertEquals((String)"The number of sales reps 2 is incorrect.", (int)this.buildTestOrder1().getNumberOfSalesReps2(), (int)orderFromDB.getNumberOfSalesReps2());
        IndirectContainerTestDatabase.assertTrue((String)"The total should NOT be instantiated yet.", (!orderFromDB.total.isInstantiated() ? 1 : 0) != 0);
        IndirectContainerTestDatabase.assertEquals((String)"The total is incorrect.", (int)this.buildTestOrder1().getTotal(), (int)orderFromDB.getTotal());
        IndirectContainerTestDatabase.assertTrue((String)"The total should be instantiated.", (boolean)orderFromDB.total.isInstantiated());
        IndirectContainerTestDatabase.assertEquals((String)"The total 2 is incorrect.", (int)this.buildTestOrder1().total2, (int)orderFromDB.total2);
    }

    public void testUOWReplaceCollection() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        AbstractOrder key = this.buildOrderShell();
        key.id = this.originalID;
        AbstractOrder orderFromDB = (AbstractOrder)uow.readObject((Object)key);
        orderFromDB.clearLines();
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        orderFromDB = (AbstractOrder)this.getSession().readObject((Object)key);
        IndirectContainerTestDatabase.assertTrue((String)"Order lines were not removed.", (boolean)orderFromDB.getLineVector().isEmpty());
    }

    public void testMergeCloneWithSerializedTransparentIndirection() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Order originalClone = (Order)uow.readObject(Order.class);
        originalClone.addSalesRep(new SalesRep("George the Customer"));
        uow.release();
        uow = this.getSession().acquireUnitOfWork();
        uow.readObject((Object)originalClone);
        uow.mergeCloneWithReferences((Object)originalClone);
        try {
            uow.commit();
        }
        catch (NullPointerException ex) {
            IndirectContainerTestDatabase.assertTrue((String)("Merging of the clone did not trigger the back up value holder" + ex.toString()), (boolean)false);
        }
    }

    public void testWriteAndReadObject() {
        AbstractOrder originalOrder = this.buildTestOrder2();
        this.writeNewOrder(originalOrder);
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        AbstractOrder key = this.buildOrderShell();
        key.id = originalOrder.id;
        AbstractOrder orderFromDB = (AbstractOrder)this.getSession().readObject((Object)key);
        this.compareOrders(originalOrder, orderFromDB);
    }

    public void updateOrder(AbstractOrder order) {
        this.getDatabaseSession().writeObject((Object)order);
    }

    protected void writeNewOrder(AbstractOrder order) {
        Enumeration stream = order.getSalesRepStream();
        while (stream.hasMoreElements()) {
            this.getDatabaseSession().writeObject(stream.nextElement());
        }
        stream = order.getSalesRepStream2();
        while (stream.hasMoreElements()) {
            this.getDatabaseSession().writeObject(stream.nextElement());
        }
        this.getDatabaseSession().writeObject((Object)order);
    }
}

