/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.tableswithspacesmodel;

import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class QuotedTableNameInitializationTest
extends TestCase {
    public QuotedTableNameInitializationTest() {
        this.setDescription("Test that a database table with spaces is properly delimited");
    }

    public void test() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Employee.class);
        String tableName = "SPACED EMPLOYEE TABLE";
        DatabaseTable table = new DatabaseTable();
        table.setName(tableName);
        table.setUseDelimiters(true);
        descriptor.addTable(table);
        descriptor.addPrimaryKeyFieldName("EMP_ID");
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("EMP_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        descriptor.preInitialize(this.getAbstractSession());
        DatasourcePlatform plaf = (DatasourcePlatform)this.getAbstractSession().getDatasourcePlatform();
        String expectedTableName = plaf.getStartDelimiter() + tableName + plaf.getEndDelimiter();
        String newTableName = table.getNameDelimited(plaf);
        QuotedTableNameInitializationTest.assertEquals((String)"Table name should be between the platform delimiters", (String)expectedTableName, (String)newTableName);
    }
}

