/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.readonly;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.mapping.Employee;
import org.eclipse.persistence.testing.models.mapping.Phone;

public class ReadOnlyClassManyToManyTestCase
extends AutoVerifyTestCase {
    public Employee originalEmployee;
    UnitOfWork uow;
    Phone originalPhone;
    String origAreaCode;

    public void reset() {
        this.originalPhone.areaCode = this.origAreaCode;
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    protected void setup() {
        this.beginTransaction();
        this.originalEmployee = (Employee)this.getSession().readObject(Employee.class);
        this.originalPhone = (Phone)this.originalEmployee.getPhoneNumbers().firstElement();
        this.origAreaCode = this.originalPhone.areaCode;
        this.uow = this.getSession().acquireUnitOfWork();
        this.uow.addReadOnlyClass(Phone.class);
        Employee cloneEmp = (Employee)this.uow.registerObject((Object)this.originalEmployee);
        ((Phone)cloneEmp.getPhoneNumbers().firstElement()).setAreaCode("000");
    }

    protected void test() {
        this.uow.commit();
    }

    protected void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        ExpressionBuilder expBuilder = new ExpressionBuilder();
        Expression exp = expBuilder.get("id").equal((Object)this.originalPhone.id);
        Phone dbPhone = (Phone)this.getSession().readObject(Phone.class, exp);
        if (!this.origAreaCode.equals(dbPhone.areaCode)) {
            throw new TestErrorException("We succeed in changing a read-only objects in a logical 1:M implemented with a M:M mapping. This is very bad!");
        }
    }
}

