/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.oracle;

import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.models.mapping.Employee;
import org.eclipse.persistence.testing.tests.queries.oracle.HierarchicalQueryTest;

public class HierarchicalQueryWithWhere
extends HierarchicalQueryTest {
    private Vector expected;

    public HierarchicalQueryWithWhere() {
        this.setName("HierarchicalQueryWithWhereClauseTest");
        this.setDescription("Tests the use of a Hierarchical Query with a Where Clause");
    }

    @Override
    public Vector expectedResults() {
        if (this.expected == null) {
            this.expected = new Vector();
            Employee daveVadis = (Employee)this.getSession().readObject(Employee.class, new ExpressionBuilder().get("lastName").equal((Object)"Vadis"));
            this.addEmployee(this.expected, daveVadis);
            this.expected.removeElement(daveVadis);
        }
        return this.expected;
    }

    @Override
    public ReadAllQuery getQuery() {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        ExpressionBuilder expb = new ExpressionBuilder();
        query.setSelectionCriteria(expb.get("firstName").notEqual((Object)"Dave").or(expb.get("lastName").notEqual((Object)"Vadis")));
        Expression startWith = expb.get("firstName").equal((Object)"Dave").and(expb.get("lastName").equal((Object)"Vadis"));
        Expression connectBy = expb.get("managedEmployees");
        query.setHierarchicalQueryClause(startWith, connectBy, null);
        return query;
    }
}

