/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.optimization;

import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.collections.Restaurant;

public class BatchReadingWithInvalidQueryKeyTest
extends TestCase {
    private ValidationException m_validationException;
    private int m_expectedErrorCode = 7051;
    BatchFetchType batchType;

    public BatchReadingWithInvalidQueryKeyTest(BatchFetchType batchType) {
        this.setDescription("Tests an invalid batch attribute set on a query.");
        this.batchType = batchType;
        this.setName(this.getName() + batchType);
    }

    public void test() {
        this.getSession().readAllObjects(Restaurant.class);
        ReadAllQuery query = new ReadAllQuery();
        query.setBatchFetchType(this.batchType);
        query.setReferenceClass(Restaurant.class);
        query.addBatchReadAttribute("I_must_surely_not_exist");
        try {
            this.getSession().executeQuery((DatabaseQuery)query);
        }
        catch (ValidationException e) {
            this.m_validationException = e;
        }
    }

    public void verify() {
        if (this.m_validationException == null) {
            throw new TestErrorException("No exception was caught on the invalid query key");
        }
        if (this.m_validationException.getErrorCode() != this.m_expectedErrorCode) {
            throw new TestErrorException("Incorrect validation exception was caught (" + this.m_validationException.getErrorCode() + ") was expecting (" + this.m_expectedErrorCode + ")", (Throwable)this.m_validationException);
        }
    }
}

