/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.UpdateAllQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.insurance.Claim;

public class UpdateAllQueryExpressionMathTest
extends AutoVerifyTestCase {
    private Session m_session;
    private Hashtable m_originalClaims;
    private Hashtable m_updatedClaims;

    public void reset() {
        this.m_session.getIdentityMapAccessor().initializeIdentityMaps();
        this.rollbackTransaction();
    }

    protected void setup() {
        this.m_session = this.getSession();
        this.beginTransaction();
        this.m_session.getIdentityMapAccessor().initializeIdentityMaps();
        this.m_originalClaims = this.getClaims();
    }

    public void test() {
        ExpressionBuilder eb = new ExpressionBuilder();
        UpdateAllQuery updateQuery = new UpdateAllQuery(Claim.class);
        updateQuery.setSelectionCriteria(eb.get("amount").greaterThan(1000));
        updateQuery.addUpdate(eb.get("amount"), ExpressionMath.multiply((Expression)eb.get("amount"), (Object)1.1));
        this.m_session.executeQuery((DatabaseQuery)updateQuery);
    }

    protected void verify() {
        this.m_session.getIdentityMapAccessor().initializeIdentityMaps();
        this.m_updatedClaims = this.getClaims();
        Enumeration e = this.m_originalClaims.keys();
        while (e.hasMoreElements()) {
            Long id = (Long)e.nextElement();
            Float original = (Float)this.m_originalClaims.get(id);
            Float updated = (Float)this.m_updatedClaims.get(id);
            if (original.compareTo(Float.valueOf(1001.0f)) < 0) {
                if (updated.compareTo(original) == 0) continue;
                throw new TestErrorException("Claim amount was updated when it shouldn't have been");
            }
            if (updated.compareTo(Float.valueOf(original.floatValue() * 1.1f)) == 0) continue;
            throw new TestErrorException("Claim amount (" + original + ") was NOT properly updated. Value = " + updated);
        }
    }

    private Hashtable getClaims() {
        Hashtable<Long, Float> claimsToReturn = new Hashtable<Long, Float>();
        Vector claims = this.m_session.readAllObjects(Claim.class);
        Enumeration e = claims.elements();
        while (e.hasMoreElements()) {
            Claim claim = (Claim)e.nextElement();
            claimsToReturn.put(claim.getId(), Float.valueOf(claim.getAmount()));
        }
        return claimsToReturn;
    }
}

