/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimization.queryandsqlcounting.querycache;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.optimization.queryandsqlcounting.querycache.NamedQueryQueryCacheTest;

public class ReadObjectQueryCacheTest
extends NamedQueryQueryCacheTest {
    public ReadObjectQueryCacheTest() {
        this.setDescription("Ensure query caches work for ReadObject queries.");
    }

    @Override
    public ReadQuery getQueryForTest() {
        ReadObjectQuery testQuery = new ReadObjectQuery(Employee.class);
        ExpressionBuilder employees = new ExpressionBuilder();
        Expression exp = employees.get("firstName").like("B%");
        testQuery.setSelectionCriteria(exp);
        testQuery.cacheQueryResults();
        return testQuery;
    }

    @Override
    public void verify() {
        if (this.tracker.getSqlStatements().size() != this.expectedSQLCount) {
            throw new TestErrorException("An incorrect number of SQL statements were generated: " + this.tracker.getSqlStatements().size() + ". This likely indicates a problem with the query cache.");
        }
        if (!((Employee)this.results).getFirstName().startsWith("B")) {
            throw new TestErrorException("The cached query did not yeild the correct result. " + this.results);
        }
    }
}

