/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpql;

import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.tests.jpql.JPQLTestCase;

public class SimpleNotMemberOfTest
extends JPQLTestCase {
    @Override
    public void setup() {
        ExpressionBuilder projects = new ExpressionBuilder();
        ExpressionBuilder managed = new ExpressionBuilder();
        Expression subQueryWhereClause = projects.equal(managed.get("manager").anyOf("managedEmployees"));
        ReportQuery subQuery = new ReportQuery(Employee.class, managed);
        subQuery.setSelectionCriteria(subQueryWhereClause);
        Expression whereClause = projects.get("teamLeader").exists(subQuery);
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(LargeProject.class);
        raq.setSelectionCriteria(whereClause);
        Object o = this.getSession().executeQuery((DatabaseQuery)raq);
        Vector allProjects = this.getSomeProjects();
        Vector<Project> selectedProjects = new Vector<Project>();
        for (int i = 0; i < allProjects.size(); ++i) {
            Project currentProject = (Project)allProjects.elementAt(i);
            if (!this.shouldIncludeProject(currentProject)) continue;
            selectedProjects.addElement(currentProject);
        }
        String ejbqlString = "SELECT OBJECT(proj) FROM Employee emp, Project proj  WHERE  (proj.teamLeader NOT MEMBER OF emp.manager.managedEmployees) AND (emp.lastName = \"Chan\")";
        this.setEjbqlString(ejbqlString);
        this.setOriginalOject(selectedProjects);
        super.setup();
    }

    public boolean shouldIncludeProject(Project someProject) {
        return someProject.getName().equals("Enterprise System") || someProject.getName().equals("Problem Reporting System") || someProject.getName().equals("Sales System");
    }
}

