/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import org.eclipse.persistence.internal.helper.IdentityWeakHashMap;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class IdentityWeakHashMapConcurrentModTest
extends AutoVerifyTestCase {
    protected IdentityWeakHashMap<Integer, Integer> map = null;
    protected ConcurrentModificationException exception = null;

    public void setup() {
        this.map = new IdentityWeakHashMap(100);
        for (int i = 0; i < 1000; ++i) {
            this.map.put((Object)i, (Object)i);
        }
    }

    public void test() {
        try {
            Iterator i = this.map.keySet().iterator();
            int count = 0;
            while (i.hasNext()) {
                ++count;
                i.next();
                this.map.get((Object)10);
                System.gc();
            }
        }
        catch (ConcurrentModificationException e) {
            this.exception = e;
        }
    }

    public void verify() {
        if (this.exception != null) {
            throw new TestErrorException("ConcurrentModificationException thrown in IdentityWeakHashMap because of System GC", (Throwable)this.exception);
        }
    }
}

