/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.directmap;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.directmap.DirectMapMappings;
import org.eclipse.persistence.testing.models.directmap.IndirectMapSubclass;

public class DirectMapMappingIndirectionTest
extends AutoVerifyTestCase {
    protected DirectMapMappings resultMapping = null;

    public DirectMapMappingIndirectionTest() {
        this.setDescription("Tests that objects deleted from the properties object in a DirectMapMapping are properly removed.");
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.rollbackTransaction();
    }

    public void setup() throws Exception {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.beginTransaction();
    }

    public void test() throws Exception {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        DirectMapMappings maps1 = (DirectMapMappings)uow.registerObject((Object)new DirectMapMappings());
        maps1.indirectionDirectMap.put(1, "guy");
        maps1.indirectionDirectMap.put(2, "axemen");
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.resultMapping = (DirectMapMappings)this.getSession().readObject((Object)maps1);
    }

    public void verify() throws Exception {
        if (this.resultMapping.indirectionDirectMap.getClass() != IndirectMapSubclass.class) {
            throw new TestErrorException("DirectMap with transparent indirection does not properly use IndirectMap");
        }
    }
}

